-- MySQL dump 8.22
--
-- Host: localhost    Database: resume
---------------------------------------------------------
-- Server version	3.23.52-log

--
-- Table structure for table 'assignment'
--

CREATE TABLE assignment (
  assignmentid int(10) unsigned NOT NULL auto_increment,
  orderid int(10) unsigned NOT NULL default '0',
  writerid int(10) unsigned NOT NULL default '0',
  changed timestamp(14) NOT NULL,
  created timestamp(14) NOT NULL,
  deadline date NOT NULL default '0000-00-00',
  deadlineh tinyint(3) unsigned NOT NULL default '0',
  completed datetime default NULL,
  filename varchar(255) NOT NULL default '',
  diskfilename varchar(255) NOT NULL default '',
  PRIMARY KEY  (assignmentid),
  KEY writerid (writerid),
  KEY orderid (orderid),
  KEY deadline (deadline)
) TYPE=MyISAM;

--
-- Dumping data for table 'assignment'
--



--
-- Table structure for table 'assignmode'
--

CREATE TABLE assignmode (
  mode tinyint(3) unsigned NOT NULL default '0'
) TYPE=MyISAM;

--
-- Dumping data for table 'assignmode'
--


INSERT INTO assignmode VALUES (0);

--
-- Table structure for table 'autoassign'
--

CREATE TABLE autoassign (
  autoassignid int(10) unsigned NOT NULL auto_increment,
  writerid int(10) unsigned NOT NULL default '0',
  assigndate date NOT NULL default '0000-00-00',
  capacity tinyint(3) unsigned NOT NULL default '0',
  assigned tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (autoassignid),
  KEY writerid (writerid),
  KEY writerid_2 (writerid,assigndate)
) TYPE=MyISAM;

--
-- Dumping data for table 'autoassign'
--



--
-- Table structure for table 'autoassignlog'
--

CREATE TABLE autoassignlog (
  autoassignlogid int(10) unsigned NOT NULL auto_increment,
  created datetime NOT NULL default '0000-00-00 00:00:00',
  writerid int(10) unsigned NOT NULL default '0',
  logentry varchar(255) NOT NULL default '',
  PRIMARY KEY  (autoassignlogid),
  KEY writerid (writerid)
) TYPE=MyISAM;

--
-- Dumping data for table 'autoassignlog'
--
--
-- Table structure for table 'card'
--

CREATE TABLE card (
  cardid int(10) unsigned NOT NULL auto_increment,
  cctype enum('VISA','AMEX','MC','DISC') NOT NULL default 'VISA',
  ccnum varchar(255) NOT NULL default '',
  ccexpm tinyint(3) unsigned NOT NULL default '0',
  ccexpy year(4) NOT NULL default '0000',
  ccholder varchar(255) NOT NULL default '',
  ccbank varchar(255) NOT NULL default '',
  changed timestamp(14) NOT NULL,
  created timestamp(14) NOT NULL,
  PRIMARY KEY  (cardid),
  KEY ccnum (ccnum)
) TYPE=MyISAM;

--
-- Dumping data for table 'card'
--

--
-- Table structure for table 'cardlog'
--

CREATE TABLE cardlog (
  cardlogid int(10) unsigned NOT NULL auto_increment,
  cardid int(10) unsigned NOT NULL default '0',
  result varchar(255) NOT NULL default '',
  result2 varchar(255) NOT NULL default '',
  time datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (cardlogid),
  KEY cardid (cardid)
) TYPE=MyISAM;

--
-- Dumping data for table 'cardlog'
--

--
-- Table structure for table 'client'
--

CREATE TABLE client (
  clid int(10) unsigned NOT NULL auto_increment,
  mail varchar(255) NOT NULL default '',
  first varchar(255) NOT NULL default '',
  last varchar(255) NOT NULL default '',
  addr1 varchar(255) NOT NULL default '',
  addr2 varchar(255) NOT NULL default '',
  city varchar(255) NOT NULL default '',
  state varchar(255) NOT NULL default '',
  zip varchar(255) NOT NULL default '',
  tlf varchar(255) NOT NULL default '',
  tlf2 varchar(255) NOT NULL default '',
  country varchar(255) NOT NULL default 'USA',
  changed timestamp(14) NOT NULL,
  created timestamp(14) NOT NULL,
  PRIMARY KEY  (clid),
  UNIQUE KEY mail (mail),
  KEY last (last),
  KEY first (first)
) TYPE=MyISAM;

--
-- Dumping data for table 'client'
--


INSERT INTO client VALUES (1,'rafamiga@noria.pl','first','last','Testowa Str','','Testowoa','WA','90120','+48-22-5555555','','Zimwabwe',20040118234031,20040110083446);

--
-- Table structure for table 'comment'
--

CREATE TABLE comment (
  commentid int(10) unsigned NOT NULL auto_increment,
  writerid int(10) unsigned NOT NULL default '0',
  orderid int(10) unsigned NOT NULL default '0',
  datecomment datetime NOT NULL default '0000-00-00 00:00:00',
  comment text,
  poster varchar(255) NOT NULL default '',
  PRIMARY KEY  (commentid),
  KEY orderid (orderid)
) TYPE=MyISAM;

--
-- Dumping data for table 'comment'
--



--
-- Table structure for table 'coupon'
--

CREATE TABLE coupon (
  couponid int(10) unsigned NOT NULL auto_increment,
  phrase varchar(255) NOT NULL default '',
  discount float(4,2) NOT NULL default '0.00',
  PRIMARY KEY  (couponid)
) TYPE=MyISAM;

--
-- Dumping data for table 'coupon'
--


INSERT INTO coupon VALUES (2,'1234',1.00);
INSERT INTO coupon VALUES (3,'3',-3.00);

--
-- Table structure for table 'login'
--

CREATE TABLE login (
  loginid int(10) unsigned NOT NULL auto_increment,
  time datetime NOT NULL default '0000-00-00 00:00:00',
  userid int(10) unsigned NOT NULL default '0',
  ip varchar(16) NOT NULL default '',
  logout tinyint(4) unsigned default NULL,
  PRIMARY KEY  (loginid),
  KEY userid (userid)
) TYPE=MyISAM;

--
-- Dumping data for table 'login'
--


--
-- Table structure for table 'orderdata'
--

CREATE TABLE orderdata (
  orderid int(10) unsigned NOT NULL auto_increment,
  clid int(10) unsigned NOT NULL default '0',
  cardid int(10) unsigned NOT NULL default '0',
  websiteid int(10) unsigned NOT NULL default '0',
  pkgid tinyint(3) unsigned NOT NULL default '0',
  rushid tinyint(3) unsigned NOT NULL default '0',
  snail tinyint(3) unsigned NOT NULL default '0',
  jobhunter tinyint(3) unsigned NOT NULL default '0',
  letter1 tinyint(3) unsigned NOT NULL default '0',
  sale float(5,2) NOT NULL default '0.00',
  changed timestamp(14) NOT NULL,
  createdy year(4) NOT NULL default '0000',
  createdm tinyint(3) unsigned NOT NULL default '0',
  createdd tinyint(3) unsigned NOT NULL default '0',
  createdw tinyint(3) unsigned NOT NULL default '0',
  createdt time default NULL,
  created datetime NOT NULL default '0000-00-00 00:00:00',
  coupontxt varchar(255) NOT NULL default '',
  coupondisc float(4,2) NOT NULL default '0.00',
  PRIMARY KEY  (orderid),
  KEY custid (clid),
  KEY cardid (cardid),
  KEY pkgid (pkgid),
  KEY rushid (rushid),
  KEY extras (snail),
  KEY createdy (createdy),
  KEY createdm (createdm),
  KEY createdd (createdd),
  KEY createdw (createdw),
  KEY jobhunter (jobhunter),
  KEY snail (snail),
  KEY websiteid (websiteid),
  KEY websiteid_2 (websiteid)
) TYPE=MyISAM;

--
-- Dumping data for table 'orderdata'
--

--
-- Table structure for table 'package'
--

CREATE TABLE package (
  packageid int(10) unsigned NOT NULL auto_increment,
  name varchar(255) NOT NULL default '',
  price float(4,2) NOT NULL default '0.00',
  PRIMARY KEY  (packageid)
) TYPE=MyISAM;

--
-- Dumping data for table 'package'
--


INSERT INTO package VALUES (1,'Standard Package',11.00);

--
-- Table structure for table 'price'
--

CREATE TABLE price (
  name varchar(255) NOT NULL default '',
  season tinyint(3) unsigned NOT NULL default '0',
  value float(6,2) NOT NULL default '0.00',
  visible varchar(255) NOT NULL default '',
  PRIMARY KEY  (name),
  UNIQUE KEY name (name),
  KEY season (season)
) TYPE=MyISAM;

--
-- Dumping data for table 'price'
--


INSERT INTO price VALUES ('WEB_STD_PACKAGE',1,89.95,'Standard resume package');
INSERT INTO price VALUES ('WEB_RUSH1_SERVICE',1,19.95,'Rush Service');
INSERT INTO price VALUES ('WEB_SNAIL_SERVICE',1,24.95,'Snail Mail Service');
INSERT INTO price VALUES ('WEB_JOBHUNTER_PACKAGE',1,85.00,'Job Hunter Package');
INSERT INTO price VALUES ('WEB_LETTER1_SERVICE',1,28.95,'Follow-Up/Thank You Letter');

--
-- Table structure for table 'priceseason'
--

CREATE TABLE priceseason (
  current tinyint(3) unsigned NOT NULL default '0'
) TYPE=MyISAM;

--
-- Dumping data for table 'priceseason'
--


INSERT INTO priceseason VALUES (1);

--
-- Table structure for table 'resfile'
--

CREATE TABLE resfile (
  fileid int(10) unsigned NOT NULL auto_increment,
  orderid int(10) unsigned NOT NULL default '0',
  filename varchar(255) NOT NULL default '',
  diskfilename varchar(255) NOT NULL default '',
  deleted set('0','1') NOT NULL default '0',
  uploaded datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (fileid),
  KEY orderid (orderid),
  KEY deleted (deleted)
) TYPE=MyISAM;

--
-- Dumping data for table 'resfile'
--


--
-- Table structure for table 'resinfo'
--

CREATE TABLE resinfo (
  resinfoid int(10) unsigned NOT NULL auto_increment,
  orderid int(10) unsigned NOT NULL default '0',
  objective text NOT NULL,
  education text NOT NULL,
  experience text NOT NULL,
  activities text NOT NULL,
  misc text NOT NULL,
  restype set('f','c','n') NOT NULL default 'n',
  changed timestamp(14) NOT NULL,
  created timestamp(14) NOT NULL,
  PRIMARY KEY  (resinfoid),
  KEY orderid (orderid)
) TYPE=MyISAM;

--
-- Dumping data for table 'resinfo'
--


--
-- Table structure for table 'retrievecase'
--

CREATE TABLE retrievecase (
  retrievecaseid int(10) unsigned NOT NULL auto_increment,
  orderid int(10) unsigned NOT NULL default '0',
  casenumber int(10) unsigned NOT NULL default '0',
  created datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (retrievecaseid),
  KEY orderid (orderid),
  KEY casenumber (casenumber)
) TYPE=MyISAM;

--
-- Dumping data for table 'retrievecase'
--



--
-- Table structure for table 'rush'
--

CREATE TABLE rush (
  rushid int(10) unsigned NOT NULL auto_increment,
  name varchar(255) NOT NULL default '',
  price float(4,2) NOT NULL default '0.00',
  timeoffset int(11) NOT NULL default '0',
  PRIMARY KEY  (rushid)
) TYPE=MyISAM;

--
-- Dumping data for table 'rush'
--


INSERT INTO rush VALUES (1,'Rush Service',22.00,86400);

--
-- Table structure for table 'user'
--

CREATE TABLE user (
  userid int(10) unsigned NOT NULL auto_increment,
  login varchar(30) NOT NULL default '',
  pass varchar(255) NOT NULL default '',
  realname varchar(255) NOT NULL default '',
  rep enum('y','n') NOT NULL default 'n',
  writer enum('y','n') NOT NULL default 'n',
  manager enum('y','n') NOT NULL default 'n',
  admin enum('y','n') NOT NULL default 'n',
  email varchar(40) default NULL,
  taxfederal decimal(7,2) default NULL,
  taxstate decimal(7,2) default NULL,
  taxfica decimal(7,2) default NULL,
  taxstateunemp decimal(7,2) default NULL,
  taxss decimal(7,2) default NULL,
  taxunemp decimal(7,2) default NULL,
  taxmisc decimal(7,2) default NULL,
  rateperhour decimal(12,2) default NULL,
  PRIMARY KEY  (userid)
) TYPE=MyISAM;

--
-- Dumping data for table 'user'
--


INSERT INTO user VALUES (1,'rafd','','rafal','y','y','y','y','rafamiga@noria.pp',0.00,0.00,0.00,0.00,0.00,0.00,0.00,0.00);
INSERT INTO user VALUES (2,'dom','81dc9bdb52d04dc20036dbd8313ed055','dominik','y','y','y','y','dominik2k@i-2000.com',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
INSERT INTO user VALUES (3,'andrew','40f48b6ecf1733cc3311ed8ae2a14b3b','andrew','y','y','y','y','andrew@azoos.com',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

--
-- Table structure for table 'website'
--

CREATE TABLE website (
  websiteid int(10) unsigned NOT NULL auto_increment,
  name varchar(255) NOT NULL default '',
  webname varchar(255) NOT NULL default '',
  mail varchar(255) NOT NULL default '',
  pass varchar(255) NOT NULL default '',
  created datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (websiteid),
  KEY webname (webname)
) TYPE=MyISAM;

--
-- Dumping data for table 'website'
--



--
-- Table structure for table 'writer'
--

CREATE TABLE writer (
  writerid int(10) unsigned NOT NULL auto_increment,
  userid int(10) unsigned NOT NULL default '0',
  name varchar(255) NOT NULL default '',
  company varchar(255) NOT NULL default '',
  email varchar(255) NOT NULL default '',
  email2 varchar(255) NOT NULL default '',
  phone1 varchar(255) NOT NULL default '',
  phone2 varchar(255) NOT NULL default '',
  fax varchar(255) NOT NULL default '',
  address1 varchar(255) NOT NULL default '',
  address2 varchar(255) NOT NULL default '',
  address3 varchar(255) NOT NULL default '',
  city varchar(60) NOT NULL default '',
  state varchar(20) NOT NULL default '',
  zip varchar(20) NOT NULL default '',
  country varchar(25) NOT NULL default 'us',
  ssn varchar(15) NOT NULL default '',
  taxid varchar(30) NOT NULL default '',
  dob date default NULL,
  filenamecodes varchar(255) NOT NULL default '',
  rateperpage decimal(12,2) NOT NULL default '0.00',
  rateperpaper decimal(12,2) NOT NULL default '0.00',
  royalityperpaper decimal(12,2) NOT NULL default '0.00',
  royalityperpage decimal(12,2) NOT NULL default '0.00',
  salary decimal(12,2) NOT NULL default '0.00',
  comments text,
  PRIMARY KEY  (writerid)
) TYPE=MyISAM;

--
-- Dumping data for table 'writer'
--


INSERT INTO writer VALUES (1,1,'RAFWRITER','','raf@nor.pl','','','','','','','','','','','','','','0000-00-00','',0.00,0.00,0.00,0.00,0.00,'');
INSERT INTO writer VALUES (2,2,'dominik jatczak','','dominik@paperdb.com','','','','','','','','','','','','','','0000-00-00','',0.00,0.00,0.00,0.00,0.00,'');
INSERT INTO writer VALUES (3,3,'andrew greenstein','azoos','andrew@azoos.com','andrew@azoos.com','352 429 5448','','419 781 4948','9512 oak island ln','','','clermont','fl','34711','usa','092 70 24323','','0000-00-00','',0.00,0.00,0.00,0.00,0.00,'');

