<?

# $Id: website.inc.php 246 2004-02-22 20:38:43Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class Website extends SimpleClassCommon
	{
	var $name = "";
	var $webname = "";
	var $mail = "";
	var $pass = "";

	var $enforce_requirements = true; //Set False when doing bulk uploads

	function Website($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"website","websiteid","created");
		if (!$ok)
			{
			$this->_error("Website ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);
		if (!$r)
			{
			$this->_error("Website Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->name = $r["name"];
		$this->webname = $r["webname"];
		$this->mail = $r["mail"];
		$this->pass = $r["pass"];

		return true;
		}

	function getIDByWebname($wn)
		{
     ini_set("memory_limit","256M");
		$r = $this->_internalFetchDataGeneric(
			array("webname" => $wn));      
		if ($r) return $r[$this->idcol];
		return 0;
		}

	function Update()
		{
		global $db;

		if ($this->getWebname() == "")
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setName($this->getName());
		if (!$ok) return false;
		$fields["name"] = $this->getName();

		$ok = $this->setWebname($this->getWebname());
		if (!$ok) return false;
		$fields["webname"] = $this->getWebname();

		$ok = $this->setMail($this->getMail());
		if (!$ok) return false;
		$fields["mail"] = $this->getMail();

		$ok = $this->setPass($this->getPass());
		if (!$ok) return false;
		$fields["pass"] = $this->getPass();

		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("Website " . $this->lastError());
			return false;
			}

		return true;
		}

	function setName($n)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkStr($n,CONST_WEBSITE_NAME_MINLEN,
				CONST_WEBSITE_NAME_MAXLEN,NOT_NULL);
			if (!$ok)
				{
				$this->_error("Website Name " . $this->lastError());
				return false;
				}
		}
		$this->name = $n;
		return true;
		}

	function getName()
		{
		return $this->name;
		}

	function setWebname($wn)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkStr($wn,CONST_WEBSITE_WEBNAME_MINLEN,
				CONST_WEBSITE_WEBNAME_MAXLEN,NOT_NULL);
			if (!$ok)
				{
				$this->_error("Website Webname " . $this->lastError());
				return false;
				}
		}
		$this->webname = $wn;
		return true;
		}

	function getWebname()
		{
		return $this->webname;
		}

	function setMail($m)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkMail($m);
			if (!$ok)
				{
				$this->_error("Website Mail " . $this->lastError());
				return false;
				}
		}
		$this->mail = $m;
		return true;
		}

	function getMail()
		{
		return $this->mail;
		}

	function setPass($p)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkStr($p,CONST_PASS_MINLEN,
				CONST_PASS_MAXLEN,NOT_NULL);
			if (!$ok)
				{
				$this->_error("Website Pass " . $this->lastError());
				return false;
				}
		}
		$this->pass = $p;
		return true;
		}

	function getPass()
		{
		return $this->pass;
		}

	function listAllOrdered()
		{
		return $this->listSQL("1","","name");
		}

	}

?>
