<?

# $Id: order.inc.php 744 2005-11-21 19:09:08Z raf $

require_once("../inc/simpleclasscommon.inc.php");
require_once("../inc/revision.inc.php");

class Order1 extends SimpleClassCommon
	{
	var $ordertype = ORDER_TYPE_COMMON;
	var $clid = 0;
	var $cardid = 0;
	var $websiteid = 0;
	var $pkgid = 1;
	var $explvlid = 0;
	var $ksaservice = 0;
	var $fedresid = 0;
	var $execresid = 0;
	var $rushid = 0;
	var $snail = 0;
	var $jobhunter = 0;
	var $letter1 = 0;
	var $coverletter = 0;
	var $consult = 0;
	var $telephone_interview = 0;
  	var $interview_prep = 0;
	var $htmlservice = 0;
	var $extdl = 1;
	var $help = 0;
  	var $emp_completed = 0;
	var $sale = 0;
	var $coupontxt = "";
	var $coupondisc = 0;
	var $whichresume = 0;

	var $rvids;
  var $linkedin = 0;
  var $chk_file = 0;

	function Order1($id=0)
		{
		$this->rv = new Revision();    
		$ok = parent::SimpleClassCommon($id,"orderdata","orderid","created");
		if (!$ok)
			{
			$this->_error("Order ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);
		if (!$r)
			{
			$this->_error("Order Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->ordertype = $r["ordertype"];
		$this->clid = $r["clid"];
		$this->cardid = $r["cardid"];
		$this->websiteid = $r["websiteid"];
		$this->pkgid = $r["pkgid"];
		$this->explvlid = $r["explvlid"];		
		$this->ksaservice = $r["ksaservice"];
		$this->fedresid = $r["fedresid"];
		$this->execresid = $r["execresid"];
		$this->rushid = $r["rushid"];
		$this->snail = $r["snail"];
		$this->jobhunter = $r["jobhunter"];
		$this->letter1 = $r["letter1"];
		$this->coverletter = $r["coverletter"];
		$this->consult = $r["consult"];
		$this->telephone_interview = $r["telephone_interview"];
    $this->interview_prep = $r["interview_prep"];
		$this->htmlservice = $r["htmlservice"];
		$this->extdl = $r["extdl"];
		$this->help = $r["help"];
		$this->sale = $r["sale"];
		$this->coupontxt = $r["coupontxt"];
		$this->coupondisc = $r["coupondisc"];
		$this->whichresume = $r["whichresume"];
    
    $this->linkedin = $r["linkedin"];
    $this->emp_completed = $r["emp_completed"];
    $this->chk_file = $r["chk_file"];

		$rv = new Revision();
		$this->rvids = $rv->listSQL("oldorderid = '" . $this->id .
			"'");
		return true;
		}

	function Update()
		{
		global $db;

		if ($this->getClid() == -1)
			{
			$this->_error(__CLASS__ . ": New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setOrderType($this->getOrderType());
		if (!$ok) return false;
		$fields["ordertype"] = $this->getOrderType();

		$ok = $this->setClid($this->getClid());
		if (!$ok) return false;
		$fields["clid"] = $this->getClid();

		$ok = $this->setCardID($this->getCardID());
		if (!$ok) return false;
		$fields["cardid"] = $this->getCardID();

		$ok = $this->setWebsiteID($this->getWebsiteID());
		if (!$ok) return false;
		$fields["websiteid"] = $this->getWebsiteID();

		$ok = $this->setPkgID($this->getPkgID());
		if (!$ok) return false;
		$fields["pkgid"] = $this->getPkgID();

		$ok = $this->setExpLvlID($this->getExpLvlID());
		if (!$ok) return false;
		$fields["explvlid"] = $this->getExpLvlID();

		$ok = $this->setKSAService($this->getKSAService());
		if (!$ok) return false;
		$fields["ksaservice"] = $this->getKSAService();

		$ok = $this->setFedResID($this->getFedResID());
		if (!$ok) return false;
		$fields["fedresid"] = $this->getFedResID();

		$ok = $this->setExecResID($this->getExecResID());
		if (!$ok) return false;
		$fields["execresid"] = $this->getExecResID();

		$ok = $this->setRushID($this->getRushID());
		if (!$ok) return false;
		$fields["rushid"] = $this->getRushID();

		$ok = $this->setSnail($this->getSnail());
		if (!$ok) return false;
		$fields["snail"] = $this->getSnail();

		$ok = $this->setJobhunter($this->getJobhunter());
		if (!$ok) return false;
		$fields["jobhunter"] = $this->getJobhunter();

		$ok = $this->setLetter1($this->getLetter1());
		if (!$ok) return false;
		$fields["letter1"] = $this->getLetter1();

		$ok = $this->setCoverLetter($this->getCoverLetter());
		if (!$ok) return false;
		$fields["coverletter"] = $this->getCoverLetter();

		$ok = $this->setConsult($this->getConsult());
		if (!$ok) return false;
		$fields["consult"] = $this->getConsult();
		
		$ok = $this->setPhoneInterview($this->getPhoneInterview());
		if (!$ok) return false;
		$fields["telephone_interview"] = $this->getPhoneInterview();
    
    $ok = $this->setInterviewPrep($this->getInterviewPrep());
		if (!$ok) return false;
		$fields["interview_prep"] = $this->getInterviewPrep();

		$ok = $this->setHTMLService($this->getHTMLService());
		if (!$ok) return false;
		$fields["htmlservice"] = $this->getHTMLService();

		$ok = $this->setExtendedDl($this->getExtendedDl());
		if (!$ok) return false;
		$fields["extdl"] = $this->getExtendedDl();
		
		
		$ok = $this->setHelp($this->getHelp());
		if (!$ok) return false;
		$fields["help"] = $this->getHelp();

		$ok = $this->setSale($this->getSale());
		if (!$ok) return false;
		$fields["sale"] = $this->getSale();

		$ok = $this->setCouponTxt($this->getCouponTxt());
		if (!$ok) return false;
		$fields["couponTxt"] = $this->getCoupontxt();

		$ok = $this->setCouponDisc($this->getCouponDisc());
		if (!$ok) return false;
		$fields["coupondisc"] = $this->getCouponDisc();
    
    $ok = $this->setLinkedInID($this->getLinkedInID());
		if (!$ok) return false;
		$fields["linkedin"] = $this->getLinkedInID();
    
    $ok = $this->setEmp_Completed($this->getEmp_Completed());
		if (!$ok) return false;
		$fields["emp_completed"] = $this->getEmp_Completed();
    
    $ok = $this->setchk_file($this->getchk_file());
		if (!$ok) return false;
		$fields["chk_file"] = $this->getchk_file();
		
		$ok = $this->setwhichresume($this->getwhichresume());
		if (!$ok) return false;
		$fields["whichresume"] = $this->getwhichresume(); 		
    
		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("Order " . $this->lastError());
			return false;
			}

		if ($ok != 1) # nowy
			{
			$q = "UPDATE " . $this->table .
				" SET createdy = NOW()" .
				",createdm=" . date("m") .
				",createdd=" . date("d") .
				",createdw=" . date("W") .
				",createdt='" . date("h:i:s") . "'" .
				" WHERE " . $this->idcol .
				"=" . ($ok-1);
#			echo "q=$q<br>";
			$db->query($q);
			}

		return true;
		}
	
  function setsitename($id,$sitename)
  {
    global $db;
      if ($id)
			{
    			$q = "UPDATE " . $this->table .
    				" SET sitename = '" .$sitename."' WHERE " . $this->idcol .
    				"=" . ($id);
#   			echo "q=$q<br>";
    			$db->query($q);
			}
  }		

	function setOrderType($ot)
		{
		global $ORDERTYPE_ARR;

		$ok = $this->_checkInt($ot,0,9);
		if (!$ok)
			{
			$this->_error("Order OrderType " . $this->lastError());
			return false;
			}

		if (!array_key_exists($ot,$ORDERTYPE_ARR))
			{
			$this->_error("Order OrderType invalid ($ot)");
			return false;
			}

		$this->ordertype = $ot;
		
		return true;
		}

	function getOrderType()
		{
		return $this->ordertype;
		}

	function setClid($id)
		{
		$ok = $this->_checkId($id);
		if (!$ok)
			{
			$this->_error("Order Clid " . $this->lastError());
			return false;
			}
		$this->clid = $id;
		return true;
		}

	function getClid()
		{
		return $this->clid;
		}

	function setCardID($id)
		{
		$ok = $this->_checkId($id,ZERO_OK);
		if (!$ok)
			{
			$this->_error("Order Cardid " . $this->lastError());
			return false;
			}
		$this->cardid = $id;
		return true;
		}

	function getCardID()
		{
		return $this->cardid;
		}

	function setWebsiteid($id)
		{
		$ok = $this->_checkId($id,ZERO_OK);
		if (!$ok)
			{
			$this->_error("Order Websiteid " . $this->lastError());
			return false;
			}
		$this->websiteid = $id;
		return true;
		}

	function getWebsiteid()
		{
		return $this->websiteid;
		}
	
	function setwhichresume($whichresume)
		{
		$this->whichresume = $whichresume;
		return true;
		}

	function getwhichresume()
		{
		return $this->whichresume;
		}
		
	function setPkgid($id)
		{
		$ok = $this->_checkId($id,ZERO_OK);
		if (!$ok)
			{
			$this->_error("Order Pkgid " . $this->lastError());
			return false;
			}
		$this->pkgid = $id;
		return true;
		}

	function getPkgid()
		{
		return $this->pkgid;
		}

	function setExpLvlID($id)
		{
		$ok = $this->_checkId($id,ZERO_OK);
		if (!$ok)
			{
			$this->_error("Order ExpLvlID " . $this->lastError());
			return false;
			}
		$this->explvlid = $id;
		return true;
		}

	function getExpLvlID()
		{
		return $this->explvlid;
		}

	function setKSAService($id)
		{
		$ok = $this->_checkId($id,ZERO_OK);
		if (!$ok)
			{
			$this->_error("Order KSAs " . $this->lastError());
			return false;
			}
		$this->ksaservice = $id;
		return true;
		}

	function getKSAService()
		{
		return $this->ksaservice;
		}

	function setFedResID($id)
		{
		$ok = $this->_checkId($id,ZERO_OK);
		if (!$ok)
			{
			$this->_error("Order FedResID " . $this->lastError());
			return false;
			}
		$this->fedresid = $id;
		return true;
		}

	function getFedResID()
		{
		return $this->fedresid;
		}

	function setExecResID($id)
		{
		$ok = $this->_checkId($id,ZERO_OK);
		if (!$ok)
			{
			$this->_error("Order ExecResID " . $this->lastError());
			return false;
			}
		$this->execresid = $id;
		return true;
		}

	function getExecResID()
		{
		return $this->execresid;
		}

	function setRushid($id)
		{
		$ok = $this->_checkId($id,ZERO_OK);
		if (!$ok)
			{
			$this->_error("Order Rushid " . $this->lastError());
			return false;
			}
		$this->rushid = $id;
		return true;
		}

	function getRushid()
		{
		return $this->rushid;
		}
    
    function setchk_file($id)
		{
		$ok = $this->_checkId($id,ZERO_OK);
		if (!$ok)
			{
			$this->_error("Order chk file " . $this->lastError());
			return false;
			}
		$this->chk_file = $id;
		return true;
		}

	function getchk_file()
		{        
		return $this->chk_file;
		}    

	function setSnail($s)
		{
		$ok = $this->_checkBool($s);
		if (!$ok)
			{
			$this->_error("Order Snail " . $this->lastError());
			return false;
			}
		$this->snail = $s;
		return true;
		}

	function getSnail()
		{
		return $this->snail;
		}

	function setJobhunter($j)
		{
		$ok = $this->_checkBool($j);
		if (!$ok)
			{
			$this->_error("Order Jobhunter " . $this->lastError());
			return false;
			}
		$this->jobhunter = $j;
		return true;
		}

	function getJobhunter()
		{
		return $this->jobhunter;
		}

	function setLetter1($l1)
		{
		$ok = $this->_checkBool($l1);
		if (!$ok)
			{
			$this->_error("Order Letter1 " . $this->lastError());
			return false;
			}
		$this->letter1 = $l1;
		return true;
		}

	function getLetter1()
		{
		return $this->letter1;
		}

	function setCoverLetter($cl)
		{
		$ok = $this->_checkBool($cl);
		if (!$ok)
			{
			$this->_error("Order CoverLetter " . $this->lastError());
			return false;
			}
		$this->coverletter = $cl;
		return true;
		}

	function getCoverLetter()
		{
		return $this->coverletter;
		}

	function setConsult($cs)
		{
		//$ok = $this->_checkBool($cs);
		$ok = $this->_checkId($cs,ZERO_OK);
		if (!$ok)
			{
			$this->_error("Order Coaching Service " . $this->lastError());
			return false;
			}
		$this->consult = $cs;
		return true;
		}

	function setPhoneInterview($cs)
		{
		$ok = $this->_checkBool($cs);
		if (!$ok)
			{
			$this->_error("Order Phone Interview Service " . $this->lastError());
			return false;
			}
		$this->telephone_interview = $cs;
		return true;
		}	
    
  	function setInterviewPrep($cs)
		{
		$ok = $this->_checkBool($cs);
		if (!$ok)
			{
			$this->_error("Order Interview Prep Service " . $this->lastError());
			return false;
			}
		$this->interview_prep = $cs;
		return true;
		}	  

	function getConsult()
		{
		return $this->consult;
		}
	
  function getPhoneInterview()
		{
		return $this->telephone_interview;
		}
    
  function getInterviewPrep()
		{
		return $this->interview_prep;
		}  

	function setHTMLService($hs)
		{
		$ok = $this->_checkBool($hs);
		if (!$ok)
			{
			$this->_error("Order HTMLService " . $this->lastError());
			return false;
			}
		$this->htmlservice = $hs;
		return true;
		}

	function getHTMLService()
		{
		return $this->htmlservice;
		}

	function setExtendedDl($ex)
		{
		$ok = $this->_checkBool($ex);
		if (!$ok)
			{
			$this->_error("Order ExtendedDl " . $this->lastError());
			return false;
			}
		$this->extdl = $ex;
		return true;
		}

	function getExtendedDl()
		{
		return $this->extdl;
		}
	
	function setHelp($ex)
		{
		$ok = $this->_checkBool($ex);
		if (!$ok)
			{
			$this->_error("Order Help " . $this->lastError());
			return false;
			}
		$this->help = $ex;
		return true;
		}

	function getHelp()
		{
		return $this->help;
		}
		    
    	function setLinkedInID($hs)
		{
		
		$ok = $this->_checkBool($hs);
		if (!$ok)
		{
			$this->_error("Order LinkedIn Service " . $this->lastError());
			return false;
		}
		$this->linkedin = $hs;
		
		return true;
		}

	function getLinkedInID()
		{
		return $this->linkedin;
		}
    
    function setEmp_Completed($hs)
		{
		
		$ok = $this->_checkBool($hs);
		if (!$ok)
		{
			$this->_error("Order Emp_Completed Service " . $this->lastError());
			return false;
		}
		$this->emp_completed = $hs;
		
		return true;
		}

    
  function getEmp_Completed()
		{
		return $this->emp_completed;
		}  

	function setSale($s)
		{
		$ok = $this->_checkFloat($s,0,999999);
		if (!$ok)
			{
			$this->_error("Order Sale " . $this->lastError());
			return false;
			}
		$this->sale = $s;
		return true;
		}

	function getSale()
		{
		return $this->sale;
		}

	function setCouponTxt($t)
		{
		$ok = $this->_checkStr($t,CONST_COUPON_MINLEN,
			CONST_COUPON_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Order CouponTxt " . $this->lastError());
			return false;
			}
		$this->coupontxt = $t;
		return true;
		}

	function getCouponTxt()
		{
		return $this->coupontxt;
		}

	function setCouponDisc($d)
		{
		$ok = $this->_checkFloat($d,CONST_COUPON_MINDISC,
			CONST_COUPON_MAXDISC);
		if (!$ok)
			{
			$this->_error("Order CouponDiscount " . $this->lastError());
			return false;
			}
		$this->coupondisc = $d;
		return true;
		}

	function getCouponDisc()
		{
		return $this->coupondisc;
		}

	function listSnailOrders($exclude="")
		{
		global $db;

		$q = "SELECT " . $this->table . ".orderid,
			assignment.completed
			FROM " . $this->table . "
			LEFT JOIN assignment USING (orderid)
			WHERE " . $this->table . ".snail = 1";
		if (strlen($exclude))
			$q .= " AND " . $this->table . ".orderid
				NOT IN ($exclude)";
		$q .= " ORDER BY " . $this->table . ".orderid";

		$got = $db->query($q);

		$orders = array();

		while ($orderid = $got->f(0))
			{
			$orders[$orderid] = $orderid;
			}

		return $orders;
		}

	function getIDByClientID($clid)
		{
		return $this->listSQL("clid = '$clid'");
		}

	function isRevision()
		{
		$rv = new Revision();
		$rvids = $rv->getIDByOrderID($this->id);
		if (count($rvids) != 1) return false;
		return true;
		}

	function hasRevision()
		{
		if (!count($this->rvids)) return false;
		return true;
		}

	function hasAltPayment()
		{
		if (!$this->id) return false;

		$ap = new AltPayment();
		$apid = $ap->getIDByOrderID($this->id);

		if (!$apid) return false;
		return true;
		}

	function hasThisInRevisionChain($what)
		{
		$method = "get$what";
		$hasit = false;

		foreach ($this->rvids as $rvid)
			{
			$rv = new Revision($rvid);
			if (!$rv->wasOK()) continue;

			$oid = $rv->getOrderID();
			$or = new Order($oid);
			if ($or->$method()) $hasit = true;
			}

		return $hasit;
		}

	function listRevisionChain()
		{
		if (!$this->id) return array();
		
		$revchain = array();
		
		foreach ($this->rvids as $rvid)
			{

			$rv = new Revision($rvid);
			if (!$rv->wasOK()) continue;
			
			array_push($revchain,$rv->getOrderID());
			}

		return $revchain;
		}

	function _descot($ot)
		{
		global $ORDERTYPE_ARR;
		$r = "Unknown OrdeType ($ot)";
		if (!array_key_exists($this->getOrderType(),$ORDERTYPE_ARR))
			return array("UNK",$r);
		return $ORDERTYPE_ARR[$this->getOrderType()];
		}

	# returns long description like "Cover Letter order"

	function descOrderType()
		{
		$r = $this->_descot($this->getOrderType());
		return $r[1]; // 1 - long descrption
		}

	# returns short description, max 3 chars, like "STD"
	
	function descOrderTypeShort()
		{
		$r = $this->_descot($this->getOrderType());
		return $r[0]; // 0 - short descrption
		}

	# returns "" when STD or "-" . short description; usefull for filenames!

	function descOrderTypeSuffix()
		{
		if ($this->getOrderType() == ORDER_TYPE_COMMON)
			return "";
		$r = $this->_descot($this->getOrderType());
		return "-" . $r[0]; // 0 - short descrption
		}

	function descOrderTypeName()
		{
		$r = $this->_descot($this->getOrderType());
		return $r[2]; // 2 - name, for messages etc.
		}

	function descOrderTypeCCDesc()
		{
		$r = $this->_descot($this->getOrderType());
		return $r[3]; // 3 - card transaction description
		}

	}

?>
