<?

# $Id: rush.inc.php 160 2004-02-01 21:19:13Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class Rush extends SimpleClassCommon
	{
	var $name = "";
	var $price = 0;
	var $timeoffset = 0;

	function Rush($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"rush","rushid");
		if (!$ok)
			{
			$this->_error("Rush ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);
		if (!$r)
			{
			$this->_error("Rush Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->name = $r["name"];
		$this->price = $r["price"];
		$this->timeoffset = $r["timeoffset"];

		return true;
		}

	function Update()
		{
		global $db;

		if ($this->getName() == "")
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setName($this->getName());
		if (!$ok) return false;
		$fields["name"] = $this->getName();

		$ok = $this->setPrice($this->getPrice());
		if (!$ok) return false;
		$fields["price"] = $this->getPrice();

		$ok = $this->setTimeOffset($this->getTimeOffset());
		if (!$ok) return false;
		$fields["timeoffset"] = $this->getTimeOffset();

		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("Rush " . $this->lastError());
			return false;
			}

		return true;
		}

	function setName($n)
		{
		$ok = $this->_checkStr($n,CONST_PKG_NAME_MINLEN,
			CONST_PKG_NAME_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("Rush Name " . $this->lastError());
			return false;
			}
		$this->name = $n;
		return true;
		}

	function getName()
		{
		return $this->name;
		}

	function setPrice($p)
		{
		$ok = $this->_checkFloat($f,0.01,9999.99);
		if (!$ok)
			{
			$this->_error("Rush Price " . $this->lastError());
			return false;
			}
		$this->price = $p;
		return true;
		}

	function getPrice()
		{
		return $this->price;
		}

	function setTimeOffset($t)
		{
		$ok = $this->_checkInt($t,-1000000,1000000);
		if (!$ok)
			{
			$this->_error("Rush Timeoffset " . $this->lastError());
			return false;
			}
		$this->timeoffset = $t;
		return true;
		}

	function getTimeOffset()
		{
		return $this->timeoffset;
		}

	function listAll()
		{
		global $db;

		$q = "SELECT * FROM " . $this->table .
			" ORDER BY " . $this->idcol;

		$got = $db->query($q);

		$ids = array(0 => "No rush");

		while ($r = $got->fetchArray())
			{
			$ids[$r[$this->idcol]] = $r["name"]; # . " $" . $r["price"];
			}

		return $ids;
		}
	}

?>
