<?

# $Id: revision.inc.php 498 2004-04-10 11:42:55Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class Revision extends SimpleClassCommon
	{
	var $orderid = 0;
	var $oldorderid = 0;
	var $cardid = 0;
#	var $specialreq = 0;
#	var $specialtxt = "";
	var $updaterequest = 0;
	var $updaterequesttxt = "";
	var $sale = 0;

	function Revision($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"revision","revisionid","created");
		if (!$ok)
			{
			$this->_error("Revision ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);
		if (!$r)
			{
			$this->_error("Revision Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->orderid = $r["orderid"];
		$this->oldorderid = $r["oldorderid"];
		$this->cardid = $r["cardid"];
#		$this->specialreq = $r["specialreq"];
#		$this->specialtxt = $r["specialtxt"];
		$this->updaterequest = $r["updaterequest"];
		$this->updaterequesttxt = $r["updaterequesttxt"];
		$this->sale = $r["sale"];

		return true;
		}

	function Update()
		{
		global $db;

		if (!$this->getOldOrderID())
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setOrderID($this->getOrderID());
		if (!$ok) return false;
		$fields["orderid"] = $this->getOrderID();

		$ok = $this->setOldOrderID($this->getOldOrderID());
		if (!$ok) return false;
		$fields["oldorderid"] = $this->getOldOrderID();

		$ok = $this->setCardID($this->getCardID());
		if (!$ok) return false;
		$fields["cardid"] = $this->getCardID();

/*
		$ok = $this->setSpecialReq($this->getSpecialReq());
		if (!$ok) return false;
		$fields["specialreq"] = $this->getSpecialReq();

		$ok = $this->setSpecialTxt($this->getSpecialTxt());
		if (!$ok) return false;
		$fields["specialtxt"] = $this->getSpecialtxt();
*/

		$ok = $this->setUpdateRequest($this->getUpdateRequest());
		if (!$ok) return false;
		$fields["updaterequest"] = $this->getUpdateRequest();

		$ok = $this->setUpdateRequestTxt($this->getUpdateRequestTxt());
		if (!$ok) return false;
		$fields["updaterequesttxt"] = $this->getUpdateRequestTxt();

		$ok = $this->setSale($this->getSale());
		if (!$ok) return false;
		$fields["sale"] = $this->getSale();

		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("Revision " . $this->lastError());
			return false;
			}

		return true;
		}

	function setOrderID($id)
		{
		$ok = $this->_checkId($id,ZERO_OK);
		if (!$ok)
			{
			$this->_error("Revision OrderID " . $this->lastError());
			return false;
			}
		$this->orderid = $id;
		return true;
		}

	function getOrderID()
		{
		return $this->orderid;
		}

	function setOldOrderID($id)
		{
		$ok = $this->_checkId($id);
		if (!$ok)
			{
			$this->_error("Revision OldOrderID " . $this->lastError());
			return false;
			}
		$this->oldorderid = $id;
		return true;
		}

	function getOldOrderID()
		{
		return $this->oldorderid;
		}

	function setCardID($id)
		{
		$ok = $this->_checkId($id,ZERO_OK);
		if (!$ok)
			{
			$this->_error("Revision CardID " . $this->lastError());
			return false;
			}
		$this->cardid = $id;
		return true;
		}

	function getCardID()
		{
		return $this->cardid;
		}

/*
	function setSpecialReq($s)
		{
		$ok = $this->_checkBool($s);
		if (!$ok)
			{
			$this->_error("Revision SpecialReq " . $this->lastError());
			return false;
			}
		$this->specialreq = $s;
		return true;
		}

	function getSpecialReq()
		{
		return $this->specialreq;
		}

	function setSpecialTxt($txt)
		{
		$ok = $this->_checkStr($txt,CONST_RESTXT_MINLEN,
			CONST_RESTXT_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Revision SpecialTxt " . $this->lastError());
			return false;
			}
		$this->specialtxt = $txt;
		return true;
		}

	function getSpecialTxt()
		{
		return $this->specialtxt;
		}
*/

	function setUpdateRequest($u)
		{
		$ok = $this->_checkBool($u);
		if (!$ok)
			{
			$this->_error("Revision UpdateRequest " . $this->lastError());
			return false;
			}
		$this->updaterequest = $u;
		return true;
		}

	function getUpdateRequest()
		{
		return $this->updaterequest;
		}

	function setUpdateRequestTxt($txt)
		{
		$ok = $this->_checkStr($txt,CONST_RESTXT_MINLEN,
			CONST_RESTXT_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Revision UpdateRequestTxt " . $this->lastError());
			return false;
			}
		$this->updaterequesttxt = $txt;
		return true;
		}

	function getUpdateRequestTxt()
		{
		return $this->updaterequesttxt;
		}


	function setSale($s)
		{
		$ok = $this->_checkFloat($s,0,999999);
		if (!$ok)
			{
			$this->_error("Revision Sale " . $this->lastError());
			return false;
			}
		$this->sale = $s;
		return true;
		}

	function getSale()
		{
		return $this->sale;
		}

	function getIDByOrderID($oid)
		{
		return $this->listSQL("orderid = '$oid'");
		}

	function getParentOrderID($oid)
		{
		$rvids = $this->getIDByOrderID($oid);
		if (!count($rvids)) return 0;

		$rv = new Revision($rvids[0]);
		if (!$rv->wasOK()) return 0;

#		echo "parent=" . $rv->getOldOrderID();

		return $rv->getOldOrderID();
		}

	}

?>
