<?

# $Id: prices.inc.php 769 2005-11-24 17:55:55Z raf $

require_once("../inc/classcommon.inc.php");
require_once("../inc/order.inc.php");

class Prices extends ClassCommon
	{
	var $table = "price";
	var $season = 0;
	var $pricearr = array();
	var $websiteid = 0;

	function Prices($season=0)
		{
		global $db;

		if ($season == 0)
			{
			$season = $this->getCurrentSeason();
			if (!$season)
				{
				$this->_error("Cannot getCurrentSeason()");
				return false;
				}
			}

		$ok = $this->_checkInt($season,1);
		if (!$ok)
			{
			$this->_error("Price Season: " . $this->lastError());
			return false;
			}

		$this->season = $season;

		$q = "SELECT * FROM " . $this->table .
			" WHERE season = " . $season .
			" AND websiteid = " . $this->websiteid .
			" ORDER BY name";
		$got = $db->query($q);

		if (!$got->numRows())
			{
			$this->_error("No prices found (WebsiteID=" .
				$this->websiteid . ", Season=" .
				$this->season . ")");
			return false;
			}

		while ($r = $got->fetchArray())
			{
#			echo "setPrice(", $r["name"], ",", $r["value"], ",",
#				$r["visible"], ") website=$this->websiteid<br>";
			$ok = $this->setPrice($r["name"],$r["value"],
				$r["visible"]);
			if (!$ok)
				{
				$this->_error("Price " . $r["name"] .
					" invalid: " . $this->lastError());
				return false;
				}
			}

		return true;
		}

	function setWebsiteID($websiteid)
		{
		$ok = $this->_checkID($websiteid,ZERO_OK);
		if (!$ok) return false;

		if (!$websiteid) return true;

		$ilep = $this->countPricesForWebsite(0);
		$ilen = $this->countPricesForWebsite($websiteid);

		if ($ilep != $ilen)
			{      
			$this->_error("Prices for website ID#$websiteid inconsistent ($ilep != $ilen). Cannot continue.");
			return false;

			/* alternative behaviour
			$q = "DELETE FROM price WHERE websiteid = $websiteid AND
				season = " . $this->season;
			
			return true;
			*/
			}
		else
			{	
			$this->websiteid = $websiteid;
			return true;
			}
		}

	function clonePricesForNewWebsiteID($websiteid)
		{
		global $db;

		$currs = $this->getCurrentSeason();

		$q = "SELECT name,season,value,visible FROM " . $this->table . "
			WHERE websiteid = 0";

		$got = $db->query($q);

		while ($r = $got->fetchArray())
			{
			$q = "DELETE FROM price WHERE
				name = '" . $r["name"] . "' AND
				season = " . $r["season"] . " AND
				websiteid = $websiteid";

#			echo "q=$q<br>";
			$db->query($q); 

			$q = "INSERT INTO price SET name = '" . $r["name"] . "',
				season = " . $r["season"] . ",
				websiteid = $websiteid,
				value = " . $r["value"] . ",
				visible = '" . $r["visible"] . "'";

#			echo "q=$q<br>";
			$db->query($q); 
			}

		return true;
		}

	function getPrices()
		{
		$ok = $this->Prices();
		if (!$ok) return false;
		
		return $this->pricearr;
		}

	function countPricesForWebsite($websiteid)
		{
		global $db;

		$q = "SELECT COUNT(*) FROM " . $this->table .
			" WHERE season = " . $this->season .
			" AND websiteid = $websiteid";
#		echo "q=$q<br>";
		$got = $db->query($q);

		return $got->f(0);
		}

	function setPrice($name,$val,$desc="")
		{
		$ok = $this->_checkPrice($val);
		if (!$ok) return false;

		$this->pricearr[$name][0] = $val;
		if (strlen($desc))
			$this->pricearr[$name][1] = $desc;
		return true;
		}

	function updatePrices()
		{
		global $db;

		foreach ($this->pricearr as $n => $v)
			{
			$q = "UPDATE " . $this->table . " SET ";
			$q .= "visible = '" . $v[1] . "', value = '" . $v[0] .
				"' WHERE season = '" . $this->season .
				"' AND name = '$n' AND websiteid = $this->websiteid";
#			echo "q=$q<br>";
			$db->query($q);
			}

		return true;
		}

	# propagates a certain price across all websiteids
	
	function syncPrice($pricename)
		{
		global $db;

		$q = "SELECT season,value FROM " . $this->table . "
			WHERE websiteid = 0 AND
			name = '$pricename'";

#		echo "q=$q<br>";
		$got = $db->query($q);		
 
		while ($r = $got->fetchArray())
			{
			$q = "UPDATE " . $this->table . " SET
				value = " . $r["value"] . " WHERE
				websiteid != 0 AND
				season = " . $r["season"] . " AND
				name = '$pricename'";
#			echo "q=$q<br>"; 
			$db->query($q);
			}

		return true;
		}

	function getCurrentSeason()
		{
		global $db;

		$q = "SELECT current FROM priceseason LIMIT 0,1";
		$got = $db->query($q);

		if (!$got->numRows())
			{
			$this->_error("Season not found");
			return false;
			}

		return $got->f(0);
		}

	function setCurrentSeason($season)
		{

		$ok = $this->_checkInt($season,1);
		if (!$ok)
			{
			$this->_error("Setting Price Season: " . $this->lastError());
			return false;
			}

		$db->query("UPDATE priceseason SET current = '$season'");
		return true;
		}

	function Calculate()
		{
		$PRDEBUG = false;

		$a = func_get_args();
		
	# try to emulate overloading
    
		switch (func_num_args())
			{
			case 1:
				return $this->_calculate_order_obj($a[0],$PRDEBUG);
			case 9:
				return $this->_calculate_old($a[0],$a[1],
					$a[2],$a[3],$a[4],$a[5],$a[6],$a[7],$a[8],$a[9],$PRDEBUG);
			default:

				diehard(__CLASS__ . "::" . __FUNCTION__ .
					" unknown overloading call: " .
					func_num_args() . " arg(s) unsupported");
			}
		}

	function _calculate_order_obj($or,$PRDEBUG)
		{
	# called with an Order object as an argument

		if (!is_object($or))
			diehard("Calculate() called with 'or' not being an object");
		if (strtolower(get_class($or)) != "order")
			diehard("Calculate() called with object " . get_class($or) . " object: unsupported");

		if ($or->getOrderType() == ORDER_TYPE_COMMON)
			{
			return $this->_calculate_old(
				$or->getPkgID(),
				$or->getRushID(),
				$or->getExpLvlID(),
				$or->getSnail(),
				$or->getJobhunter(),
				$or->getLetter1(),
				$or->getCoverLetter(),
				$or->getConsult(),
				$or->getHTMLService(),
				$or->getExtendedDl(),
        $or->getLinkedInID(),
				$PRDEBUG,
        $or->getPhoneInterview());
			}

		$pr = $this->getPrices();

		if ($or->getOrderType() == ORDER_TYPE_FED)
			{
			$price = 0;
			//$price = $pr["WEB_FED_ORDER"][0];
			if ($PRDEBUG) echo "baseprice=$price<br>";
			$price = $this->_addprice($PRDEBUG,$price,$or,"getFedResID",$pr,"WEB_FED_ORDER");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getRushID",$pr,"WEB_RUSH1_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getExpLvlID",$pr,"WEB_EXP1_PACKAGE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getKSAService",$pr,"WEB_KSA_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getLetter1",$pr,"WEB_LETTER1_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getJobHunter",$pr,"WEB_JOBHUNTER_PACKAGE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getSnail",$pr,"WEB_SNAIL_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getCoverLetter",$pr,"WEB_COVER_LETTER");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getConsult",$pr,"WEB_CONSULT_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getHTMLService",$pr,"WEB_HTML_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getExtendedDl",$pr,"WEB_EXTDL_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getPhoneInterview",$pr,"WEB_PHONE_INTERVIEW");

			return $price;
			}

		if ($or->getOrderType() == ORDER_TYPE_EXEC)
			{
			$price = 0;
			//$price = $pr["WEB_EXEC_ORDER"][0];
			if ($PRDEBUG) echo "baseprice=$price<br>";
			$price = $this->_addprice($PRDEBUG,$price,$or,"getExecResID",$pr,"WEB_EXEC_ORDER");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getRushID",$pr,"WEB_RUSH1_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getExpLvlID",$pr,"WEB_EXP1_PACKAGE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getLetter1",$pr,"WEB_LETTER1_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getJobHunter",$pr,"WEB_JOBHUNTER_PACKAGE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getSnail",$pr,"WEB_SNAIL_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getCoverLetter",$pr,"WEB_COVER_LETTER");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getConsult",$pr,"WEB_CONSULT_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getHTMLService",$pr,"WEB_HTML_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getExtendedDl",$pr,"WEB_EXTDL_SERVICE"); 
			$price = $this->_addprice($PRDEBUG,$price,$or,"getPhoneInterview",$pr,"WEB_PHONE_INTERVIEW");

			return $price;
			}

		if ($or->getOrderType() == ORDER_TYPE_COVERLETTER)
			{
			$price = $pr["WEB_CL_ORDER"][0];
			if ($PRDEBUG) echo "baseprice=$price<br>";
			$price = $this->_addprice($PRDEBUG,$price,$or,"getRushID",$pr,"WEB_RUSH1_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getLetter1",$pr,"WEB_LETTER1_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getJobHunter",$pr,"WEB_JOBHUNTER_PACKAGE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getSnail",$pr,"WEB_SNAIL_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getExtendedDl",$pr,"WEB_EXTDL_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getPhoneInterview",$pr,"WEB_PHONE_INTERVIEW");

			return $price;
			}
		
		if ($or->getOrderType() == ORDER_TYPE_PROF)
			{  
			$price = 0;                
			//$price = $pr["WEB_EXEC_ORDER"][0];
			if ($PRDEBUG) echo "baseprice=$price<br>";
			$price = $this->_addprice($PRDEBUG,$price,$or,"getExecResID",$pr,"WEB_EXEC_ORDER");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getRushID",$pr,"WEB_RUSH1_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getExpLvlID",$pr,"WEB_EXP1_PACKAGE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getLetter1",$pr,"WEB_LETTER1_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getJobHunter",$pr,"WEB_JOBHUNTER_PACKAGE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getSnail",$pr,"WEB_SNAIL_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getCoverLetter",$pr,"WEB_COVER_LETTER");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getConsult",$pr,"WEB_CONSULT_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getHTMLService",$pr,"WEB_HTML_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getExtendedDl",$pr,"WEB_EXTDL_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getPhoneInterview",$pr,"WEB_PHONE_INTERVIEW");
      $price = $this->_addprice($PRDEBUG,$price,$or,"getLinkedInID",$pr,"WEB_LINKEDIN_SERVICE");
      $price = $this->_addprice($PRDEBUG,$price,$or,"getPhoneInterview",$pr,"WEB_PHONE_INTERVIEW");
      $price = $this->_addprice($PRDEBUG,$price,$or,"getInterviewPrep",$pr,"WEB_INT_PREP_PRC");

			return $price;
			}
			
			
		if ($or->getOrderType() == ORDER_TYPE_CV)
			{
			$price = $pr["WEB_CV_ORDER"][0];
			if ($PRDEBUG) echo "baseprice=$price<br>";
			$price = $this->_addprice($PRDEBUG,$price,$or,"getRushID",$pr,"WEB_RUSH1_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getLetter1",$pr,"WEB_LETTER1_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getCoverLetter",$pr,"WEB_COVER_LETTER");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getExtendedDl",$pr,"WEB_EXTDL_SERVICE");
			$price = $this->_addprice($PRDEBUG,$price,$or,"getPhoneInterview",$pr,"WEB_PHONE_INTERVIEW");

			return $price;
			}

		if ($or->getOrderType() == ORDER_TYPE_SAMPLE)
		{ 
			$price = $pr["WEB_SAMPLE"][0];

			return $price;
		}

		diehard(__CLASS__ . "::" . __FUNCTION__ . " - Not implemented for ot=" .
			$or->descOrderType());
		return -1;
		}

	# old behaviour, 9 parameters

	// change mitesh on 17/09/2011
	function _calculate_old($pkg,$rush,$explvl,$snail,$jobh,$l1,$coverl,$cons,$htmls,$extdl,$linkdin,$PRDEBUG,$phoninterview='')
		{
		if ($PRDEBUG) echo "Calculate for affiliate ID#xxx
			pkg=$pkg rush=$rush snail=$snail jobh=$jobh
			l1=$l1 coverl=$coverl consult=$cons htmls=$htmls extdl=$extdl linkdin=$linkdin phoninterview=$phoninterview";

		$pr = $this->getPrices();

		$prpkg = $pr["WEB_STD_PACKAGE"][0];
		if ($pkg == ADDSVC_REVISION_PKGID) $prpkg = 0;
		if ($PRDEBUG) echo "prpkg=$prpkg<br>";

		/*
    $prrush = $pr["WEB_RUSH1_SERVICE"][0];
		if ($PRDEBUG) echo "prrush=$prrush<br>";
		*/
		
		if ($rush == 0) {
			$prrush = 0;
			if ($PRDEBUG) echo "prrush=$prrush<br>";
		} else {
			$prrush = $pr["WEB_RUSH" . $rush . "_SERVICE"][0];
			if ($PRDEBUG) echo "prrush=$prrush<br>";
		}
		
		if ($explvl == 0) {
			$prexplvl = 0;
			if ($PRDEBUG) echo "prexplvl=$prexplvl<br>";
		} else {
			$prexplvl = $pr["WEB_EXP" . $explvl . "_PACKAGE"][0];
			if ($PRDEBUG) echo "prexplvl=$prexplvl<br>";
		}
		        
		if($cons == "1")
		{
      $prcs = $pr["WEB_CONSULT_SERVICE"][0];
    }
    else if($cons == "2")
		{
      $prcs = $pr["WEB_CONSULT_SERVICE_PRO"][0];
    }
		
		$prsnail = $pr["WEB_SNAIL_SERVICE"][0];
		if ($PRDEBUG) echo "prsnail=$prsnail<br>";
		$prjobh = $pr["WEB_JOBHUNTER_PACKAGE"][0];
		if ($PRDEBUG) echo "prjobh=$prjobh<br>";
		$prl1 = $pr["WEB_LETTER1_SERVICE"][0];
		if ($PRDEBUG) echo "prl1=$prl1<br>";
		$prcl = $pr["WEB_COVER_LETTER"][0];
		if ($PRDEBUG) echo "prcl=$prcl<br>";
		//$prcs = $pr["WEB_CONSULT_SERVICE"][0];
		if ($PRDEBUG) echo "prcs=$prcs<br>";
		$prhs = $pr["WEB_HTML_SERVICE"][0];
		if ($PRDEBUG) echo "prhs=$prhs<br>";
		$pred = $pr["WEB_EXTDL_SERVICE"][0];
		if ($PRDEBUG) echo "prhs=$prhs<br>";
		$prcph = $pr["WEB_PHONE_INTERVIEW"][0];
		if ($PRDEBUG) echo "prcph=$prcph<br>";
    $prlinkdin = $pr["WEB_LINKEDIN_SERVICE"][0];
		if ($PRDEBUG) echo "prlinkdin=$prlinkdin<br>";

		$price = 0;

		$price = $price + ($pkg ? $prpkg : 0);
		if ($PRDEBUG) echo "pr1=$price<br>";
		$price = $price + ($rush ? $prrush : 0);
		if ($PRDEBUG) echo "pr2=$price<br>";
		$price = $price + ($explvl ? $prexplvl : 0);
		if ($PRDEBUG) echo "pr3=$price<br>";
		$price = $price + ($snail ? $prsnail : 0);
		if ($PRDEBUG) echo "pr4=$price<br>";
		$price = $price + ($jobh ? $prjobh : 0);
		if ($PRDEBUG) echo "pr5=$price<br>";
		$price = $price + ($l1 ? $prl1 : 0);
		if ($PRDEBUG) echo "pr6=$price<br>";
		$price = $price + ($coverl ? $prcl : 0);
		if ($PRDEBUG) echo "pr7=$price<br>";
		$price = $price + ($cons ? $prcs : 0);
		if ($PRDEBUG) echo "pr8=$price<br>";
		$price = $price + ($htmls ? $prhs : 0);
		if ($PRDEBUG) echo "pr9=$price<br>";
		$price = $price + ($extdl ? $pred : 0);
		if ($PRDEBUG) echo "pr10=$price<br>";
		$price = $price + ($phoninterview ? $prcph : 0);
		if ($PRDEBUG) echo "pr11=$price<br>";
    $price = $price + ($linkdin ? $prlinkdin : 0);
		if ($PRDEBUG) echo "pr12=$price<br>";

		return $price;

		}

	function CalculateAddSvcs($snail,$jobh,$l1,$coverl,$cons,$htmls,$updatereq,$extdl,$linkedin='',$int_prep='',$additionalcoach='')
		{
/*
		echo "CalculateAddSvcs snail=$snail jh=$jobh
			l1=$l1 cl=$coverl hs=$htmls up=$updatereq
			extdl=$extdl";
*/
		$pr = $this->getPrices();

		$prsnail = $pr["WEB_SNAIL_SERVICE"][0];
#		echo "prsnail=$prsnail<br>";
		$prjobh = $pr["WEB_JOBHUNTER_PACKAGE"][0];
#		echo "prjobh=$prjobh<br>";
		$prl1 = $pr["WEB_LETTER1_SERVICE"][0];
#		echo "prl1=$prl1<br>";
		$prcl = $pr["WEB_COVER_LETTER"][0];
#		echo "prcl=$prcl<br>";
		$prcons = $pr["WEB_CONSULT_SERVICE"][0];
#		echo "prcons=$prcons<br>";
		$prhs = $pr["WEB_HTML_SERVICE"][0];
#		echo "prhs=$prhs<br>";
		$prup = $pr["WEB_CLIENT_UPDATE_REQUEST"][0];
#		echo "prup=$prup<br>";
		$pred = $pr["WEB_EXTDL_SERVICE"][0];
#		echo "prup=$prup<br>";
		$prlinkedin = $pr["WEB_LINKEDIN_SERVICE"][0];
#		echo "prup=$prup<br>";    
    $printprep = $pr["WEB_INT_PREP_PRC"][0];    
    		$pradditionalcoach = $pr["WEB_ADDITIONAL_COACHING"][0];

		$price = 0;

		$price = $price + ($snail ? $prsnail : 0);
#		echo "pr1=$price<br>";
		$price = $price + ($jobh ? $prjobh : 0);
#		echo "pr2=$price<br>";
		$price = $price + ($l1 ? $prl1 : 0);
#		echo "pr3=$price<br>";
		$price = $price + ($coverl ? $prcl : 0);
#		echo "pr4=$price<br>";
		$price = $price + ($cons ? $prcons : 0);
#		echo "pr5=$price<br>";
		$price = $price + ($htmls ? $prhs : 0);
#		echo "pr6=$price<br>";
		$price = $price + ($updatereq ? $prup : 0);
#		echo "pr7=$price<br>";
		$price = $price + ($extdl ? $pred : 0);
#		echo "pr7=$price<br>";
		$price = $price + ($linkedin ? $prlinkedin : 0);
#		echo "pr8=$price<br>";
		$price = $price + ($int_prep ? $printprep : 0);  
		$price = $price + ($additionalcoach ? $pradditionalcoach*$additionalcoach : 0);              
    

		return $price;
		}

	function _addprice($PRDEBUG,$price,$or,$method,$pr,$name)
		{
		$price0 = $price;
		
		if ($method == "getKSAService") {
			
			$k = $or->$method();
			
			if ($k > 0)
				$add = $pr[$name][0] * $k;
			else
				$add = 0;
		} elseif ($method == "getExpLvlID") {
			
			$e = $or->$method();
			
			if ($e > 0)
				$add = $pr["WEB_EXP" . $e . "_PACKAGE"][0];
			else
				$add = 0;
		} elseif ($method == "getRushID") {
			
			$e = $or->$method();
			
			if ($e > 0)
				$add = $pr["WEB_RUSH" . $e . "_SERVICE"][0];
			else
				$add = 0;
		}  elseif ($method == "getConsult") {
			
			$e = $or->$method();
			//echo $e;print_R($pr);exit;
			if ($e == 1)
				$add = $pr["WEB_CONSULT_SERVICE"][0];
			else if ($e == 2)
				$add = $pr["WEB_CONSULT_SERVICE_PRO"][0];
      else
				$add = 0;		
		} else {
			$add = $or->$method() ? $pr[$name][0] : 0;
		}
		
		
		
		$price = $price + $add;

		if ($PRDEBUG)
			echo "price $method=" . $or->$method() . " (" . $pr[$name][0] .
				") :: $price0 + $add = $price<br>";
		return $price;
		}

	}
# THIS IS DEBUG

/*
require_once("../inc/autoexec.inc.php");

$p = new Prices();
$p->Calculate(1,2);

var_dump($p->clonePricesForNewWebsiteID(2));
var_dump($p->setWebsiteID(1));
echo "<br>error: ", $p->lastError(), "<br>";
var_dump($p->getPrices());
var_dump($p->updatePrices());
*/

?>
