<?



# $Id: preordermsg.inc.php 659 2005-07-18 18:14:06Z raf $



require_once("../inc/simpleclasscommon.inc.php");



class PreOrderMsg extends SimpleClassCommon

	{

	var $writerid = 0;

	var $mail = "";

	var $message = "";

	var $ordered = 0;

	var $orderid = 0;



	function PreOrderMsg($id=0)

		{

		$ok = parent::SimpleClassCommon($id,"preordermsg",

			"preordermsgid","created");

		if (!$ok)

			{

			$this->_error("PreOrderMsg ". $this->lastError());

			return false;

			}



		return true;

		}



	function fetchData($id)

		{

		global $db;



		$id = addslashes($id);



		$r = $this->_internalFetchData($id,

			"UNIX_TIMESTAMP(ordered) AS orderedUX");



		if (!$r)

			{

			$this->_error("PreOrderMsg Fetch ". $this->lastError());

			return false;

			}



		$this->id = $id;

		$this->writerid = $r["writerid"];

		$this->mail = $r["mail"];

		$this->message = $r["message"];

		$this->ordered = $r["orderedUX"];

		$this->orderid = $r["orderid"];



		return true;

		}



	function Update()

		{

		global $db;



		if ($this->getMail() == "")

			{

			$this->_error("New object, no data set");

			return false;

			}



		$fields = array();

		$unixtime = array();



		$ok = $this->setWriterID($this->getWriterID());

		if (!$ok) return false;

		$fields["writerid"] = $this->getWriterID();



		$ok = $this->setMail($this->getMail());

		if (!$ok) return false;

		$fields["mail"] = $this->getMail();



		$ok = $this->setMessage($this->getMessage());

		if (!$ok) return false;

		$fields["message"] = $this->getMessage();



		$unixtime["ordered"] = $this->getOrdered();



		$ok = $this->_internalUpdate($fields,$unixtime);



		if (!$ok)

			{

			$this->_error("PreOrderMsg " . $this->lastError());

			return false;

			}



		return true;

		}



	function setWriterID($id)

		{

		$ok = $this->_checkID($id,ZERO_OK);

		if (!$ok)

			{

			$this->_error("PreOrderMsg Writer ID " . $this->lastError());

			return false;

			}

		$this->writerid = $id;

		return true;

		}



	function getWriterID()

		{

		return $this->writerid;

		}



	function setMail($m)

		{

		$m = strtolower($m);

		$ok = $this->_checkMail($m);

		if (!$ok)

			{

			$this->_error("PreOrderMsg Mail " . $this->lastError());

			return false;

			}

		$this->mail = $m;

		return true;

		}



	function getMail()

		{

		return $this->mail;

		}



	function setMessage($txt)

		{

		$txt = addslashes($txt);

		$ok = $this->_checkStr($txt,CONST_MSG_MINLEN,

			CONST_MSG_MAXLEN,NOT_NULL);

		if (!$ok)

			{

			$this->_error("PreOrderMsg Comment " . $this->lastError());

			return false;

			}

		$this->message = $txt;

		return true;

		}



	function getMessage()

		{

		return stripslashes($this->message);

		}



	function setOrdered($ux)

		{

		$ok = $this->_checkUxTime($ux);

		if (!$ok)

			{

			$this->_error("PreOrderMsg Ordered Unixtime " .

				$this->lastError());

			return false;

			}

		$this->ordered = $ux;

		return true;

		}



	function getOrdered()

		{

		return $this->ordered;

		}



	function setOrderID($id)

		{

		if ($id)

			{

			$ok = $this->_checkID($id,ZERO_OK);

			if (!$ok)

				{

				$this->_error("PreOrderMsg OrderID " .

					$this->lastError());

				return false;

				}

			}

		$this->orderid = $id;

		return true;

		}



	function getOrderID()

		{

		return $this->orderid;

		}



/*

	function listUnread($wid=MSG_ANYWRITER,$msgt=MSG_TYPE_ANY,$sort="created")

		{

		$wriselect = ($wid == MSG_ANYWRITER ? "" :

			"writerid = $wid AND");



		$typeselect = "";



		if ($msgt != MSG_TYPE_ANY)

			{

			if (!is_array($msgt)) $msgt = array($msgt);

			$typeselect = "messagetype IN (" . join(",",$msgt) .

				") AND";

			}



		$select = "$wriselect $typeselect replydate =

			FROM_UNIXTIME(0)";



#		echo "select=$select";



		return $this->listSQL($select,"",$sort);

		}

*/



	function listClientPOMs($mail)

		{

		return $this->listSQL("mail = '$mail' AND orderid = 0","",

			"created");

		}



	function markClientPOMsOnOrder($oid,$poms)

		{

		global $db;



		$q = "UPDATE " . $this->table . "

			SET	ordered = NOW(),

				orderid = $oid

			WHERE " . $this->idcol . "

			IN (" . join(",",$poms) . ")";



		$db->query($q);

#		echo "q=$q<br>";



		return true;

		}



	function countPOMsPeriod($uxstart,$uxend)

		{

		global $db;



		$q = "SELECT COUNT(*) FROM " . $this->table . "

			WHERE created >= FROM_UNIXTIME($uxstart)

			AND created < FROM_UNIXTIME($uxend)";

		$got = $db->query($q);



		return $got->f(0);

		}



	function countOrderPOMsPeriod($uxstart,$uxend)

		{

		global $db;



		$pomids = $this->listSQL("orderid != 0

			AND created >= FROM_UNIXTIME($uxstart)

			AND created < FROM_UNIXTIME($uxend)");



		$pomidc = count($pomids);



		foreach ($pomids as $pomid)

			{

			# check if order has altpayment and if so if it's paid



			$pom = new PreOrderMsg($pomid);

			if (!$pom->wasOK())

				diehard("POM ID#$pomid error: " .

					$pom->lastError());



			$oid = $pom->getOrderID();

			$or = new Order($oid);

			

			if (!$or->wasOK())

				diehard("Order ID#$oid error: " .

					$or->lastError());



			if (!$or->hasAltPayment()) continue;

			

			$ap = new AltPayment();

			$apid = $ap->getIDByOrderID($oid);

			if (!$apid) diehard("AltPayment not found but hasAltPayment for Order ID# $oid"); # should never happen



			$ap = new AltPayment($apid);



			if (!$ap->wasOK())

				diehard("Order ID#$oid AltPayment ID#$apid error: " .

					$ap->lastError());



#			echo "<br>getReceived=", $ap->getReceived();



			if (!$ap->getReceived())

				{

				$pomidc = $pomidc - 1;

#				echo "<br>POM ID$pomid unset";

				}

			}



		return $pomidc;

		}



	function deletetePOMsFromDate($uxdate)

		{

		global $db;



		$q = "DELETE FROM " . $this->table . "

			WHERE created <= FROM_UNIXTIME($uxdate)";

		$db->query($q);



		return true;

		}



	}



?>