<?

# $Id: package.inc.php 145 2004-01-29 20:05:00Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class Package extends SimpleClassCommon
	{
	var $name = "";
	var $price = 0;

	function Package($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"package","packageid");
		if (!$ok)
			{
			$this->_error("Package ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);
		if (!$r)
			{
			$this->_error("Package Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->name = $r["name"];
		$this->price = $r["price"];

		return true;
		}

	function Update()
		{
		global $db;

		if ($this->getName() == "")
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setName($this->getName());
		if (!$ok) return false;
		$fields["name"] = $this->getName();

		$ok = $this->setPrice($this->getPrice());
		if (!$ok) return false;
		$fields["price"] = $this->getPrice();

		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("Package " . $this->lastError());
			return false;
			}

		return true;
		}

	function setName($n)
		{
		$ok = $this->_checkStr($n,CONST_PKG_NAME_MINLEN,
			CONST_PKG_NAME_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("Package Name " . $this->lastError());
			return false;
			}
		$this->name = $n;
		return true;
		}

	function getName()
		{
		return $this->name;
		}

	function setPrice($p)
		{
		$ok = $this->_checkFloat($f,0.01,9999.99);
		if (!$ok)
			{
			$this->_error("Package Price " . $this->lastError());
			return false;
			}
		$this->price = $p;
		return true;
		}

	function getPrice()
		{
		return $this->p;
		}

	function listAll()
		{
		global $db;

		$q = "SELECT * FROM " . $this->table .
			" ORDER BY " . $this->idcol;

		$got = $db->query($q);

		$ids = array();

		while ($r = $got->fetchArray())
			{
			$ids[$r[$this->idcol]] = $r["name"]; # . " $" . $r["price"];
			}

		return $ids;
		}
	}

?>
