<?



require_once("../inc/simpleclasscommon.inc.php");
require_once("../inc/revision.inc.php");

class Order_Download_Renewal extends Order	{

	var $orderid = 0; //The order id if we are given one
	
	
	/**
	 * Constructor
	 *
	 * Builds the object and sets defaults
	 *
	 * var $id Set if you want a single order renewal, otherwise 0
	 */
	function Order_Download_Renewal($id = 0)	{

/*
		$ok = parent::Order($id);
		if (!$ok) {
			$this->_error("Order ". $this->lastError());
			return false;
		}
*/

		$this->orderid = $id;
		return true;
	} //Constructor
	
		

	/**
	 * List orders to renew.
	 *
	 * Takes optional parameters of the year and month. If they aren't
	 * given, then defaults to 1 year before last month
	 *
	 */
	function listOrdersToRenew($year = '', $month = '')
		{
		global $db;

		$start_date = '';
		$end_date = '';
		if ($year == '' or $month == ''){
			//Default to 13 months ago.
			$start_date = date('Y-m-01 00:00:00', strtotime("-13 month"));
			$end_date = date('Y-m-d 23:59:59', strtotime("+1 month", strtotime($start_date)) - 1); //+1 month minus one second
		} else {
			//Use the given values
			$start_date = date('Y-m-d 00:00:00', strtotime("$year-$month-01 00:00:00"));
			$end_date = date('Y-m-d 23:59:59', strtotime("+1 month", strtotime($start_date)) - 1); //+1 month minus one second
		}
		
		/* Orders that are either:
		  1) Originally within the given date range and have NEVER been renewed
		  OR
		  2) Orders that were LAST renewed during that period, but not since
		  
		  Also, must always have extdl set to 1 and a credit card on hand.
		*/
		
		global $RENEWAL_COMMENT_POSTER;
		//Never been renewed
		$q = "SELECT orderdata.orderid
			FROM orderdata
			INNER JOIN card ON card.cardid = orderdata.cardid
			LEFT JOIN comment ON
				(comment.orderid = orderdata.orderid
				 AND comment.poster = '" . $RENEWAL_COMMENT_POSTER . "')
			LEFT JOIN hideit ON (hideit.orderid = orderdata.orderid AND FIND_IN_SET('neworderlist',hidewhat) > 0)
			WHERE comment.commentid IS NULL AND hideit.orderid IS NULL
				AND orderdata.created BETWEEN '" . $start_date . "' AND '" . $end_date . "'
				AND orderdata.extdl = 1";
		
		$q .= " UNION ";
		
		//Renewed during that period, but not since
		$q .= "SELECT orderdata.orderid
			FROM orderdata
			INNER JOIN card ON card.cardid = orderdata.cardid
			INNER JOIN comment ON
				(comment.orderid = orderdata.orderid
				 AND comment.poster = '" . $RENEWAL_COMMENT_POSTER . "'
				 AND comment.datecomment BETWEEN '" . $start_date . "' AND '" . $end_date . "')
			LEFT JOIN comment AS comment_renewals ON
				(comment.orderid = orderdata.orderid
				 AND comment.poster = '" . $RENEWAL_COMMENT_POSTER . "'
				 AND comment.datecomment > '" . $end_date . "')
			LEFT JOIN hideit ON (hideit.orderid = orderdata.orderid AND FIND_IN_SET('neworderlist',hidewhat) > 0)
			WHERE comment_renewals.commentid IS NULL AND hideit.orderid IS NULL
				AND orderdata.extdl = 1";

		$q .= " ORDER BY orderid";

		//echo "\n<!--DEBUG: Order_Download_Renewal::listOrdersToRenew() q=$q -->\n";
		
		$got = $db->query($q);
		//Remove any possibility of duplicates
		$orders = array();
		while ($orderid = $got->f(0))
			{
			$orders[$orderid] = $orderid;
			}

		return $orders;
	} //listOrdersToRenew()



	/**
	 * For an order, get the latest date of either the order or the most recent extended download renewal.
	 *
	 * Return FALSE if neither can be determined, though that shouldn't happen
	 */
	function getLatestUpdateDate($orderid) {
		global $db;
		$latest_date = FALSE;
		
		global $RENEWAL_COMMENT_POSTER;
		//Never been renewed
		$q = "SELECT orderdata.orderid, orderdata.created, MAX(comment.datecomment) AS datecomment
			FROM orderdata
			LEFT JOIN comment ON
				(comment.orderid = orderdata.orderid
				 AND comment.poster = '" . $RENEWAL_COMMENT_POSTER . "')
			WHERE orderdata.orderid = " . addslashes($orderid) . "
			GROUP BY orderdata.orderid, orderdata.created";

		//echo "\n<!--DEBUG: Order_Download_Renewal::getLatestUpdateDate() q=$q -->\n";
		
		$got = $db->query($q);
		//Remove any possibility of duplicates
		$orders = array();
		while ($orderfields = $got->fetchAssoc() ) {
			if (! is_null($orderfields["datecomment"]) ) {
				//It's been renewed
				$latest_date = $orderfields["datecomment"];
				//echo "\n<!--DEBUG: Order_Download_Renewal::getLatestUpdateDate() Using datecomment=$latest_date -->\n";
			} else {
				//Never been renewed
				$latest_date = $orderfields["created"];
				//echo "\n<!--DEBUG: Order_Download_Renewal::getLatestUpdateDate() Using created=$latest_date -->\n";
			}
		}
		
		return $latest_date;
	} //getLatestUpdateDate



} //class Renewals

?>
