<?



# $Id: message.inc.php 517 2004-04-15 20:45:07Z raf $



require_once("../inc/simpleclasscommon.inc.php");



class Message extends SimpleClassCommon

	{

	var $messagetype = 0;

	var $orderid = 0;

	var $clid = 0;

	var $writerid = 0;

	var $subject = "";

	var $comment = "";

	var $reply = "";

	var $replydate = 0;

	var $wasread = 0;



	function Message($id=0)

		{

		$ok = parent::SimpleClassCommon($id,"message","messageid","created");

		if (!$ok)

			{

			$this->_error("Message ". $this->lastError());

			return false;

			}



		return true;

		}



	function fetchData($id)

		{

		global $db;



		$id = addslashes($id);



		$r = $this->_internalFetchData($id,

			"UNIX_TIMESTAMP(replydate) AS replydateUX,

			 UNIX_TIMESTAMP(wasread) AS wasreadUX");



		if (!$r)

			{

			$this->_error("Message Fetch ". $this->lastError());

			return false;

			}



		$this->id = $id;

		$this->messagetype = $r["messagetype"];

		$this->orderid = $r["orderid"];

		$this->clid = $r["clid"];

		$this->writerid = $r["writerid"];

		$this->subject = $r["subject"];

		$this->comment = $r["comment"];

		$this->reply = $r["reply"];

		$this->replydate = $r["replydateUX"];

		$this->wasread = $r["wasreadUX"];



		return true;

		}



	function Update()

		{

		global $db;



		if ($this->getSubject() == "")

			{

			$this->_error("New object, no data set");

			return false;

			}



		$fields = array();

		$unixtime = array();



		$ok = $this->setMessageType($this->getMessageType());

		if (!$ok) return false;

		$fields["messagetype"] = $this->getMessageType();



		$ok = $this->setOrderID($this->getOrderID());

		if (!$ok) return false;

		$fields["orderid"] = $this->getOrderID();



		$ok = $this->setClid($this->getClid());

		if (!$ok) return false;

		$fields["clid"] = $this->getClid();



		$ok = $this->setWriterID($this->getWriterID());

		if (!$ok) return false;

		$fields["writerid"] = $this->getWriterID();



		$ok = $this->setSubject($this->getSubject());

		if (!$ok) return false;

		$fields["subject"] = $this->getSubject();



		$ok = $this->setComment($this->getComment());

		if (!$ok) return false;

		$fields["comment"] = $this->getComment();



		$ok = $this->setReply($this->getReply());

		if (!$ok) return false;

		$fields["reply"] = $this->getReply();



		$unixtime["replydate"] = $this->getReplyDate();

		$unixtime["wasread"] = $this->getWasRead();



		$ok = $this->_internalUpdate($fields,$unixtime);



		if (!$ok)

			{

			$this->_error("Message " . $this->lastError());

			return false;

			}



		return true;

		}



	function setMessageType($t)

		{

		$ok = $this->_checkInt($t,1,6);

		if (!$ok)

			{

			$this->_error("Message Type " . $this->lastError());

			return false;

			}

		$this->messagetype = $t;

		return true;

		}



	function getMessageType()

		{

		return $this->messagetype;

		}



	function setOrderID($id)

		{

		if ($id)

			{

			$ok = $this->_checkID($id);

			if (!$ok)

				{

				$this->_error("Message OrderID " . $this->lastError());

				return false;

				}

			}

		$this->orderid = $id;

		return true;

		}



	function getOrderID()

		{

		return $this->orderid;

		}



	function setClid($id)

		{

		if ($id)

			{

			$ok = $this->_checkID($id);

			if (!$ok)

				{

				$this->_error("Message Clid " . $this->lastError());

				return false;

				}

			}

		$this->clid = $id;

		return true;

		}



	function getClid()

		{

		return $this->clid;

		}



	function setWriterID($id)

		{

		if ($id)

			{

			$ok = $this->_checkID($id,ZERO_OK);

			if (!$ok)

				{

				$this->_error("Message WriterID " . $this->lastError());

				return false;

				}

			}

		$this->writerid = $id;

		return true;

		}



	function getWriterID()

		{

		return $this->writerid;

		}



	function setSubject($txt)

		{

		$txt = addslashes($txt);

		$ok = $this->_checkStr($txt,CONST_MSG_SUBJ_MINLEN,

			CONST_MSG_SUBJ_MAXLEN,NOT_NULL);

		if (!$ok)

			{

			$this->_error("Message Subject " . $this->lastError());

			return false;

			}

		$this->subject = $txt;

		return true;

		}



	function getSubject()

		{

		return stripslashes($this->subject);

		}



	function setComment($txt)

		{

		$txt = addslashes($txt);

		$ok = $this->_checkStr($txt,CONST_MSG_MINLEN,

			CONST_MSG_MAXLEN,NOT_NULL);

		if (!$ok)

			{

			$this->_error("Message Comment " . $this->lastError());

			return false;

			}

		$this->comment = $txt;

		return true;

		}



	function getComment()

		{

		return stripslashes($this->comment);

		}



	function setReply($txt)

		{

		$txt = addslashes($txt);

		$ok = $this->_checkStr($txt,CONST_MSG_MINLEN,

			CONST_MSG_MAXLEN,NULL_OK);

		if (!$ok)

			{

			$this->_error("Message Reply " . $this->lastError());

			return false;

			}

		$this->reply = $txt;

		return true;

		}



	function getReply()

		{

		return stripslashes($this->reply);

		}



	function setReplyDate($ux)

		{

		$ok = $this->_checkUxTime($ux);

		if (!$ok)

			{

			$this->_error("Message ReplyDate Unixtime " . $this->lastError());

			return false;

			}

		$this->replydate = $ux;

		return true;

		}



	function getReplyDate()

		{

		return $this->replydate;

		}



	function setWasRead($ux)

		{

		$ok = $this->_checkUxTime($ux);

		if (!$ok)

			{

			$this->_error("Message WasRead Unixtime " . $this->lastError());

			return false;

			}

		$this->wasread = $ux;

		return true;

		}



	function getWasRead()

		{

		return $this->wasread;

		}





	function getIDByClid($clid)

		{

		return $this->listSQL("clid = '$clid'");

		}



	function getIDByOrderID($oid)

		{

		return $this->listSQL("orderid = '$oid'");

		}



	function explainMessageType()

		{

		switch ($this->messagetype)

			{

			case MSG_TYPE_WRITERDIRECT:

				return MSG_TYPE_WRITERDIRECT_DESC;

			case MSG_TYPE_NOWRITER:

				return MSG_TYPE_NOWRITER_DESC;

			case MSG_TYPE_CHANGES:

				return MSG_TYPE_CHANGES_DESC;

			case MSG_TYPE_VOICEMAIL:

				return MSG_TYPE_VOICEMAIL_DESC;

			case MSG_TYPE_SPECIALREQ:

				return MSG_TYPE_SPECIALREQ_DESC;

			case MSG_TYPE_SPECIALREQNOWRITER:

				return MSG_TYPE_SPECIALREQNOWRITER_DESC;

			default:

				return "Unknown (" .

					$this->messagetype . ")";

			}

		}



	function msgColor()

		{

		switch ($this->messagetype)

			{

			case MSG_TYPE_WRITERDIRECT:

				return "brown";

			case MSG_TYPE_CHANGES:

				return "blue";

			case MSG_TYPE_VOICEMAIL:

				return "green";

			case MSG_TYPE_SPECIALREQ:

				return "red";

			case MSG_TYPE_SPECIALREQNOWRITER:

				return "red";

			default:

				return "black";

			}

		}



	function listUnread($wid=MSG_ANYWRITER,$msgt=MSG_TYPE_ANY,$sort="created")

		{

		$wriselect = ($wid == MSG_ANYWRITER ? "" :

			"writerid = $wid AND");



		$typeselect = "";



		if ($msgt != MSG_TYPE_ANY)

			{

			if (!is_array($msgt)) $msgt = array($msgt);

			$typeselect = "messagetype IN (" . join(",",$msgt) .

				") AND";

			}



		$select = "$wriselect $typeselect replydate =

			FROM_UNIXTIME(0)";



//		echo "select=$select";



		return $this->listSQL($select,"",$sort);

		}



	}



?>