<?

# $Id: htmlfile.inc.php 697 2005-09-19 09:12:38Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class HTMLFile extends SimpleClassCommon
	{
	var $orderid = 0;
	var $clid = 0;
	var $diskfilename = "";
	var $diskfilenameextensionin = "rtf"; //Default
	var $diskfilenameextensionout = "html"; //Default

	function HTMLFile($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"htmlfile","htmlfileid",
			"created");
		if (!$ok)
			{
			$this->_error("HTMLFile ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);
		if (!$r)
			{
			$this->_error("HTMLFile Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->orderid = $r["orderid"];
		$this->clid = $r["clid"];
		$this->diskfilename = $r["diskfilename"];
		
		//Get the extension from the filename
		if (strrchr($this->diskfilename, ".")) {
			$this->diskfilenameextensionin = substr(strrchr($this->diskfilename, "."), 1); //Get just the extension
			//CLC 6/2/08 Set the output extension to the same as the input extension by default
			$this->diskfilenameextensionout = $this->diskfilenameextensionin;
		}
		

		return true;
		}

	function getIDByOrderID($oid)
		{
		$ret = $this->listSQL("orderid = '$oid'","LIMIT 1","created");
		if (count($ret)) return array_pop($ret); else return 0;
		}

	function getIDByClid($clid)
		{
		$ret = $this->listSQL("clid = '$clid'","LIMIT 1","created");
		if (count($ret)) return array_pop($ret); else return 0;
		}

	function Update()
		{
		global $db;

		if ($this->getOrderID() == 0)
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setOrderID($this->getOrderID());
		if (!$ok) return false;
		$fields["orderid"] = $this->getOrderID();

		$ok = $this->setClid($this->getClid());
		if (!$ok) return false;
		$fields["clid"] = $this->getClid();

		$ok = $this->setDiskfilename($this->getDiskfilename());
		if (!$ok) return false;
		$fields["diskfilename"] = $this->getDiskfilename();

		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("HTMLFile " . $this->lastError());
			return false;
			}

		return true;
		}

	function setOrderID($oid)
		{
		$ok = $this->_checkID($oid);
		if (!$ok)
			{
			$this->_error("HTMLFile OrderID " . $this->lastError());
			return false;
			}
		$this->orderid = $oid;
		return true;
		}

	function getOrderID()
		{
		return $this->orderid;
		}

	function setClid($clid)
		{
		$ok = $this->_checkID($clid);
		if (!$ok)
			{
			$this->_error("HTMLFile Client ID " . $this->lastError());
			return false;
			}
		$this->clid = $clid;
		return true;
		}

	function getClid()
		{
		return $this->clid;
		}

	function setDiskfilename($f)
		{
		$ok = $this->_checkStr($f,CONST_FILE_NAME_MINLEN,
			CONST_FILE_NAME_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("HTMLFile Disk Filename " . $this->lastError());
			return false;
			}
		$this->diskfilename = $f;
		return true;
		}

	function getDiskfilename()
		{
		return $this->diskfilename;
		}

	//CLC 4/4/2008 Set up a holder for the filename extension so I can take uploads of DOC, RTF or other extensions
	//Use an Input and an Output version so I can do conversions if needed
	function setDiskfilenameExtensionIn($f)
		{
		$ok = $this->_checkStr($f,CONST_FILE_NAME_EXT_MINLEN,
			CONST_FILE_NAME_EXT_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("HTMLFile Disk Filename Extension (In) " . $this->lastError());
			return false;
			}
		$this->diskfilenameextensionin = $f;
		
		//DEBUG START: For now, if you upload an rtf file, then the posted file will be html. If you upload a DOC file, then the output becomes DOC as well
		/*
		if (eregi("doc", $f)) {
			$this->setDiskfilenameExtensionOut("doc");
		} elseif (eregi("rtf", $f)) {
			//Default behavior
			$this->setDiskfilenameExtensionOut("html");
		}
		*/
		//END DEBUG
		$this->setDiskfilenameExtensionOut($this->diskfilenameextensionin);
		
		return true;
		}

	function getDiskfilenameExtensionIn()
		{
		return $this->diskfilenameextensionout;
		}

	function setDiskfilenameExtensionOut($f)
		{
		$ok = $this->_checkStr($f,CONST_FILE_NAME_EXT_MINLEN,
			CONST_FILE_NAME_EXT_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("HTMLFile Disk Filename Extension (Out) " . $this->lastError());
			return false;
			}
		$this->diskfilenameextensionout = $f;
		return true;
		}

	function getDiskfilenameExtensionOut()
		{
		return $this->diskfilenameextensionout;
		}

	//CLC 4/4/2008 Make filename extension a parameter
	function makeFilename($str)
		{
		$str = ereg_replace("[^A-Za-z0-9\.-]","_",$str);

		$fn0 = HTMLFILESDIR . "/$str";
		$fn = $fn0 . "." . $this->getDiskfilenameExtensionOut(); //".html";
		$i = 0;

		//If another version exists with this name, try to find a unique name
		while ($i++ < 100)
			{
			if (!file_exists($fn)) break;
			$fn = $fn0 . "-$i." . $this->getDiskfilenameExtensionOut();
			}

		if ($i == 100) return false;
		return $fn;
		}


	function getURL()
		{
		return HTMLFILESURL . "/" . basename($this->getDiskFilename());
		}


	function postFile($file)
		{
		@unlink($this->getDiskFilename());

		//CLC 4/4/2008 Only if I want to make an html file out an RTF file should I do the conversion. Otherwise, just copy it.
		//CLC 6/2/2008 Force it to only do the copy
		//if (eregi("rtf", $this->getDiskfilenameExtensionIn()) && eregi("htm", $this->getDiskfilenameExtensionOut())) {
		//	//Make an html out of the rtf file
		//	$exe = UNRTFEXE . " --nopict --html '" . $file . "' >" .
		//		$this->getDiskFilename();
		//} else {
			//Just copy the file to the new location and be done with it
			$exe = "cp $file " . $this->getDiskFilename();
			
		//}
#		echo "exe=$exe";

		$got = exec($exe,$erra);

#		echo "got=$got<br>";

		if (eregi("error",$got))
			{
			@unlink($this->getDiskFilename());
			$this->_error($got);
			return false;
			}
	
		return true;
		}

	}

/*
## DEBUG CODE

require_once("../inc/autoexec.inc.php");

$ht = new HTMLFile(1);

$ok = $ht->postFile(COMPLETEDFILESDIR . '/resume-c5c41e1ce531dc15b54509c05f2af07b31857');

var_dump($ok);
*/

?>
