<?

# $Id: classcommon.inc.php 704 2005-10-15 22:24:41Z raf $

class ClassCommon
	{
	var $error = "";

	function _error($msg)
		{
		$this->error = $msg;
		}

	function lastError()
		{
		return $this->error;
		}

	function noError()
		{
		$this->error = "";
		}

	function wasOK()
		{
		return (strlen($this->lastError()) ? false : true);
		}

	function _checkID($id,$allowzero=NO_ZERO)
		{
		if (!$id && ($allowzero == ZERO_OK))
			return true;

		$ok = $this->_checkInt($id,1);
		if (!$ok)
			{
			$this->_error("ID " . $this->lastError());
			return false;
			}
		return true;
		}

	function _checkMail($mail)
		{
		if (!strlen($mail))
			{
			$this->_error("Address missing");
			return false;
			}

		$ok = $this->_checkStr($mail,5,CONST_MAIL_MAXLEN);

		if (!$ok)
			{
			$this->_error("Address " . $this->lastError());
			return false;
			}

		if (substr_count($mail,"@") != 1)
			{
			$this->_error("Invalid address (@)");
			return false;
			}

		return true;
		}

	function _checkBool($bool)
		{
		if (((string) $bool != "0") && ((string) $bool != "1"))
			{
			$this->_error("Boolean '$bool' invalid");
			return false;
			}

		return true;
		}

	function _checkStr($str,$min,$max,$noempty=NOT_NULL)
		{
		if (!strlen($str))
			{
			if ($noempty == NULL_OK) return true;
			$this->_error("cannot be empty");
			return false;
			}

		$l = strlen($str);

		if ($l < $min)
			{
			$this->_error("too short (min. $min)");
			return false;
			}

		if ($l > $max)
			{
			$this->_error("too long (max $max)");
			return false;
			}

		return true;
		}

	function _checkTlf($t,$notnull=NOT_NULL,$min=CONST_TLF_MINLEN)
		{
		$ok = $this->_checkStr($t,$min,
			CONST_TLF_MAXLEN,$notnull);
		if (!$ok) return false;

/*
		$t2 = ereg_replace("[^0-9\.\(\)\+ -]"," ",$t);
		if ($t != $t2)
			{
			$this->_error("invalid characters used");
			return false;
			}
*/

		return true;
		}

	function _checkIP($ip)
		{
/*
		if (!strlen($ip))
			{
			if ($noempty == NULL_OK) return true;
			$this->_error("cannot be empty");
			return false;
			}
*/

		$ok = $this->_checkStr($ip,7,15,NOT_NULL);
		if (!$ok)
			{
			$this->_error("IP '$ip' " . $this->lastError());
			return false;
			}

		$ip2 = ereg_replace("[^0-9\.]",".",$ip);
		if ($ip2 != $ip)
			{
			$this->_error("IP '$ip' invalid");
			return false;
			}

		if (substr_count($ip,".."))
			{
			$this->_error("IP '$ip' invalid");
			return false;
			}

		$ip2 = explode(".",$ip);

		foreach ($ip2 as $a)
			{
			if ($a > 255)
				{
				$this->_error("IP '$ip' invalid");
				return false;
				}
			}

		if ($ip2[0] > 223)
			{
			$this->_error("IP '$ip' invalid");
			return false;
			}

		return true;
		}

	function _checkInt($int,$min,$max=0)
		{
		if (!strlen($int))
			{
			$this->_error("'$int': empty");
			return false;
			}
		if (!is_numeric($int))
			{
			$this->_error("'$int': not numeric");
			return false;
			}
		if (ceil($int) != $int)
			{
			$this->_error("'$int': float not allowed");
			return false;
			}
		if ($int < 0)
			{
			$this->_error("'$int': negative not allowed");
			return false;
			}
		if ($int < $min)
			{
			$this->_error("'$int': too low (min. $min)");
			return false;
			}

		if ($max)
			{
			if ($int > $max)
				{
				$this->_error("'$int': too high (max $max)");
				return false;
				}
			}

		return true;
		}

	function _checkFloat($f,$min,$max=0,$ile=2)
		{
		if (!strlen($f))
			{
			$this->_error("'$f': empty");
			return false;
			}
		if (!is_numeric($f))
			{
			$this->_error("'$f': not numeric");
			return false;
			}
		if ($f < 0 && $min > 0)
			{
			$this->_error("'$f': negative not allowed");
			return false;
			}
/*
		if (!ereg("^[0-9]{1," . $ile . "}\.[0-9]",$f))
			{
			$this->_error("'$f': not a float");
			return false;
			}
*/
		if ($f < $min)
			{
			$this->_error("'$f': too low (min. $f)");
			return false;
			}
		if ($max)
			{
			if ($f > $max)
				{
				$this->_error("'$f': too high (max $f)");
				return false;
				}
			}

		return true;
		}

	function _checkUxTime($t)
		{
		if ($t < 0)
			{
			$this->_error("Timeval negative");
			return false;
			}

/*
		if ($t > $max)
			{
			$this->_error("ID too high (max $max)");
			return false;
			}
*/

		return true;
		}

	function _checkPrice($p)
		{
		if (!is_numeric($p))
			{
			$this->_error("Not numeric");
			return false;
			}

		if ($p < 0)
			{
			$this->_error("Negative");
			return false;
			}

		return true;
		}

	function _checkCCNum($n)
		{
		if (ereg_replace("[^0-9]","",$n) != $n)
			{
			$this->_error("Invalid characters");
			return false;
			}

		if (ereg("^[012789]",$n))
			{
			$this->_error("Invalid number");
			return false;
			}

		return $this->_checkStr($n,CONST_CC_NUM_MINLEN,
			CONST_CC_NUM_MAXLEN,NOT_NULL);
		}

	function _checkDate4Y2M2D($d) // YYYY-MM-DD
		{
		$ok = $this->_checkStr($d,10,10);
		if (!$ok) return false;

		if (ereg_replace("[^0-9-]","",$d) != $d)
			{
			$this->_error("Invalid characters");
			return false;
			}

		$x = explode("-",$d);

		if (count($x) != 3)
			{
			$this->_error("Invalid format");
			return false;
			}

		if ($x[0] < "1970")
			{
			$this->_error("Year too far away");
			return false;
			}

		if ($x[0] > "2038")
			{
			$this->_error("UNIX won't exist then");
			return false;
			}

		if ($x[1] < "01")
			{
			$this->_error("Bad month");
			return false;
			}

		if ($x[1] > "12")
			{
			$this->_error("Invalid month");
			return false;
			}

		if ($x[2] < "01")
			{
			$this->_error("Bad day");
			return false;
			}

		if ($x[2] > "31")
			{
			$this->_error("Invalid day");
			return false;
			}

		return true;
		}

	}
