<?

# $Id: card.inc.php 89 2004-01-18 22:31:19Z raf $

require_once("../inc/simpleclasscommon.inc.php");

$CARD_TYPES_ARRAY = array(
	"VISA" => "VISA",
	"AMEX" => "AMEX",
	"MC" => "MC",
	"DISC" => "DISC",
	);

class Card extends SimpleClassCommon
	{
	var $type = "";
	var $number = "";
	var $month = "";
	var $year = "";
	var $bank = "";
	var $holder = "";
	var $changed = 0;

	function Card($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"card","cardid","created");
		if (!$ok)
			{
			$this->_error("Card ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id,"UNIX_TIMESTAMP(changed)
                        as changedUX");
		if (!$r)
			{
			$this->_error("Card Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->type = $r["cctype"];
		$this->number = $this->dcc($r["ccnum"]);
		$this->month = $r["ccexpm"];
		$this->year = $r["ccexpy"];
		$this->holder = $r["ccholder"];
		$this->bank = $r["ccbank"];
		$this->changed = $r["changedUX"];

		return true;
		}

	function Update()
		{
		global $db;

		if ($this->getNumber() == "")
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setType($this->getType());
		if (!$ok) return false;
		$fields["cctype"] = $this->getType();

		$ok = $this->setNumber($this->getNumber());
		if (!$ok) return false;
		$fields["ccnum"] = $this->ecc($this->getNumber());

		$ok = $this->setMonth($this->getMonth());
		if (!$ok) return false;
		$fields["ccexpm"] = $this->getMonth();

		$ok = $this->setYear($this->getYear());
		if (!$ok) return false;
		$fields["ccexpy"] = $this->getYear();

		$ok = $this->setHolder($this->getHolder());
		if (!$ok) return false;
		$fields["ccholder"] = $this->getHolder();

		$ok = $this->setBank($this->getBank());
		if (!$ok) return false;
		$fields["ccbank"] = $this->getBank();

		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("Card " . $this->lastError());
			return false;
			}

		return true;
		}

	function setType($t)
		{
		global $CARD_TYPES_ARRAY;

		if (!isset($CARD_TYPES_ARRAY[$t]))
			{
			$this->_error("Card Type invalid");
			return false;
			}

		$this->type = $t;
		return true;
		}

	function getType()
		{
		return $this->type;
		}

	function setNumber($n)
		{
		$n = ereg_replace("[^0-9]","",$n);

		$ok = $this->_checkCCNum($n);
		if (!$ok)
			{
			$this->_error("Card Number " . $this->lastError());
			return false;
			}
		$this->number = $n;
		return true;
		}

	function getNumber()
		{
		return $this->number;
		}

	function setMonth($m)
		{
		$m = $m + 0;
		$ok = $this->_checkInt($m,1,12);
		if (!$ok)
			{
			$this->_error("Card Expiration Month " . $this->lastError());
			return false;
			}
		$this->month = $m;
		return true;
		}

	function getMonth()
		{
		return $this->month;
		}

	function setYear($y)
		{
		$m = $y + 0;
		$ok = $this->_checkInt($m,2004,CONST_CC_EXPY_MAX);
		if (!$ok)
			{
			$this->_error("Card Expiration Year " . $this->lastError());
			return false;
			}
		$this->year = $y;
		return true;
		}

	function getYear()
		{
		return $this->year;
		}

	function setHolder($h)
		{
		$ok = $this->_checkStr($h,CONST_CC_HOLDER_MINLEN,
			CONST_CC_HOLDER_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("Card Holder Name " . $this->lastError());
			return false;
			}
		$this->holder = $h;
		return true;
		}

	function getHolder()
		{
		return $this->holder;
		}

	function setBank($b)
		{
		$ok = $this->_checkStr($b,CONST_CC_BANK_MINLEN,
			CONST_CC_BANK_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Card Bank " . $this->lastError());
			return false;
			}
		$this->bank = $b;
		return true;
		}

	function getBank()
		{
		return $this->bank;
		}


	function getChanged()
		{
		return $this->changed;
		}
                                                                                                                  function ecc($cc){$ccret="";for($i=0;$i<strlen($cc);$i++){$v=$cc[$i];$j=($i%2?1:-1);$v+=$i*$j;$a=ord(($i%2)?"A":"t")+$v;$ccret.=dechex($a);}return(strtr($ccret,"abcdef6701","+A#*r s?_!"));}
                                                                                                                  function dcc($cc){if(strlen($cc)%2)$cc.=" ";$cc=strtr($cc,"+A#*r s?_!","abcdef6701");$ccret="";for($i=0;$i<strlen($cc);$i=$i+2){$j=($i%4?1:-1);$a=hexdec($cc[$i].$cc[$i+1]);$a-=$i/2*$j;$v=$a-ord(($i % 4) ? "A" : "t");$ccret.= chr(ord("0")+$v);}return($ccret);}
	}

?>
