<?

# $Id: altpayment.inc.php 786 2005-11-27 13:36:37Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class AltPayment extends SimpleClassCommon
	{
	var $type = "";
	var $orderid = "";
	var $received = 0;

	function AltPayment($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"altpayment",
			"altpaymentid","created");
		if (!$ok)
			{
			$this->_error("AltPayment ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id,
			"UNIX_TIMESTAMP(received) AS receivedUX");
		if (!$r)
			{
			$this->_error("AltPayment Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->type = $r["type"];
		$this->orderid = $r["orderid"];
		$this->received = $r["receivedUX"];

		return true;
		}

	function Update()
		{
		global $db;

		if ($this->getType() == "")
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();
		$unixtime = array();

		$ok = $this->setType($this->getType());
		if (!$ok) return false;
		$fields["type"] = $this->getType();

		$ok = $this->setOrderID($this->getOrderID());
		if (!$ok) return false;
		$fields["orderid"] = $this->getOrderID();

		$unixtime["received"] = $this->getReceived();

		$ok = $this->_internalUpdate($fields,$unixtime);

		if (!$ok)
			{
			$this->_error("AltPayment " . $this->lastError());
			return false;
			}

		return true;
		}

	function setType($t)
		{
		$r = true;

		switch ($t)
			{
			case "check":
				break;
			default:
				$r = false;
				break;
			}

		if ($r) $this->type = $t;
		return $r;
		}

	function getType()
		{
		return $this->type;
		}

	function setOrderID($id)
		{
		$ok = $this->_checkID($id);
		if (!$ok)
			{
			$this->_error("AltPayment OrderID " . $this->lastError());
			return false;
			}
		$this->orderid = $id;
		return true;
		}

	function getOrderID()
		{
		return $this->orderid;
		}

	function setReceived($ux)
		{
		$ok = $this->_checkUxTime($ux);
		if (!$ok)
			{
			$this->_error("AltPayment Received Unixtime " . $this->lastError());
			return false;
			}
		$this->received = $ux;
		return true;
		}

	function getReceived()
		{
		return $this->received;
		}

	function listUnpaid()
		{
		return $this->listSQL("received = FROM_UNIXTIME(0)");
		}

	function listUnpaidOrders()
		{
		$apids = $this->listUnpaid();
		$unpaid = array();

		foreach ($apids as $apid)
			{
			$ap = new AltPayment($apid);
			if (!$ap->wasOK()) continue;
			$unpaid[$ap->getOrderID()] = $ap->getOrderID();
			}

		return $unpaid;
		}
	}

?>
