<?

# $Id: afforder.inc.php 434 2004-03-28 22:19:19Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class AffOrder extends SimpleClassCommon
	{
	var $affiliateid = 0;
	var $orderid = 0;
	var $rateperorder = 0;
	var $affsale = 0;
	var $iscookie = 0;
	var $validorder = 0;
	var $cookie_created_date = '0000-00-00';

	function AffOrder($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"afforder","afforderid","created");
		if (!$ok)
			{
			$this->_error("AffOrder ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);
		if (!$r)
			{
			$this->_error("AffOrder Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->affiliateid = $r["affiliateid"];
		$this->orderid = $r["orderid"];
		$this->rateperorder = $r["rateperorder"];
		$this->affsale = $r["affsale"];
		$this->iscookie = $r["iscookie"];
		$this->validorder = $r["validorder"];
		$this->cookie_created_date = $r["cookie_created_date"];

		return true;
		}

	function Update()
		{
		global $db;

		if ($this->getAffiliateID() == 0)
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setAffiliateID($this->getAffiliateID());
		if (!$ok) return false;
		$fields["affiliateid"] = $this->getAffiliateID();

		$ok = $this->setOrderID($this->getOrderID());
		if (!$ok) return false;
		$fields["orderid"] = $this->getOrderID();

		$ok = $this->setRatePerOrder($this->getRatePerOrder());
		if (!$ok) return false;
		$fields["rateperorder"] = $this->getRatePerOrder();

		$ok = $this->setAffSale($this->getAffSale());
		if (!$ok) return false;
		$fields["affsale"] = $this->getAffSale();

		$ok = $this->setIsCookie($this->getIsCookie());
		if (!$ok) return false;
		$fields["iscookie"] = $this->getIsCookie();

		$ok = $this->setValidOrder($this->getValidOrder());
		if (!$ok) return false;
		$fields["validorder"] = $this->getValidOrder();
		
		$ok = $this->setCookieDate($this->getCookieDate());
		if (!$ok) return false;
		$fields["cookie_created_date"] = $this->getCookieDate();
		
		
		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("AffOrder " . $this->lastError());
			return false;
			}

		return true;
		}

	function setAffiliateID($id)
		{
		if ($id)
			{
			$ok = $this->_checkID($id);
			if (!$ok)
				{
				$this->_error("AffOrder AffiliateID " .
					$this->lastError());
				return false;
				}
			}
		$this->affiliateid = $id;
		return true;
		}

	function getAffiliateID()
		{
		return $this->affiliateid;
		}

	function setOrderID($id)
		{
		if ($id)
			{
			$ok = $this->_checkID($id);
			if (!$ok)
				{
				$this->_error("AffOrder OrderID " .
					$this->lastError());
				return false;
				}
			}
		$this->orderid = $id;
		return true;
		}

	function getOrderID()
		{
		return $this->orderid;
		}

	function setRatePerOrder($r)
		{
		$ok = $this->_checkPrice($r);
		if (!$ok)
			{
			$this->_error("AffOrder RatePerOrder " . $this->lastError());
			return false;
			}
		$this->rateperorder = $r;
		return true;
		}

	function getRatePerOrder()
		{
		return $this->rateperorder;
		}

	function setAffSale($s)
		{
		$ok = $this->_checkFloat($s,0,999999);
		if (!$ok)
			{
			$this->_error("AffOrder AffSale " . $this->lastError());
			return false;
			}
		$this->affsale = $s;
		return true;
		}

	function getAffSale()
		{
		return $this->affsale;
		}

	function setIsCookie($ic)
		{
		$this->iscookie = ($ic ? 1 : 0);
		return true;
		}

	function getIsCookie()
		{
		return $this->iscookie;
		}
		
	function setCookieDate($cookie_date)
		{
		$this->cookie_created_date = $cookie_date;
		return true;
		}

	function getCookieDate()
		{
		return $this->cookie_created_date;
		}	

	function setValidOrder($vo)
		{
		$this->validorder = ($vo ? 1 : 0);
		return true;
		}

	function getValidOrder()
		{
		return $this->validorder;
		}

	function getIDByAffiliateIDSpan($afid,$sdat=0,$edat=0,$dest=0)
		{
		if (!$edat) $edat = time();

		if ($dest != "0"){
			$destination = " AND destination='".$dest."'";
		} else {
			$destination = "";
		}

		return $this->listSQL("affiliateid = '$afid' 
			".$destination." 
			AND created >= FROM_UNIXTIME($sdat)
			AND created <= FROM_UNIXTIME($edat)");
		}

	}

?>
