<?

# $Id: affbanner.inc.php 546 2004-04-24 16:02:51Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class AffBanner extends SimpleClassCommon
	{
	var $desc = "";
	var $diskfilename = "";
#	var $contenttype = "";
	var $redirecturl = "";
	var $display = 0;
	var $prio = 0;
	var $clicked = 0;

	function AffBanner($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"affbanner","affbannerid",
			"created");
		if (!$ok)
			{
			$this->_error("AffBanner ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);
		if (!$r)
			{
			$this->_error("AffBanner Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->desc = $r["info"];
		$this->diskfilename = $r["diskfilename"];
#		$this->contenttype = $r["contenttype"];
		$this->redirecturl = $r["redirecturl"];
		$this->display = $r["display"];
		$this->prio = $r["prio"];
		$this->clicked = $r["clicked"];

		return true;
		}

	function Update()
		{
		global $db;

		if (!strlen($this->getDiskfilename()) || !$this->getPrio())
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setDesc($this->getDesc());
		if (!$ok) return false;
		$fields["info"] = $this->getDesc();

		$ok = $this->setDiskfilename($this->getDiskfilename());
		if (!$ok) return false;
		$fields["diskfilename"] = $this->getDiskfilename();

/*
		$ok = $this->setContenttype($this->getContenttype());
		if (!$ok) return false;
		$fields["diskfilename"] = $this->getContenttype();
*/

		$ok = $this->setRedirectURL($this->getRedirectURL());
		if (!$ok) return false;
		$fields["redirecturl"] = $this->getRedirectURL();

		$ok = $this->setDisplay($this->getDisplay());
		if (!$ok) return false;
		$fields["display"] = $this->getDisplay();

		$ok = $this->setPrio($this->getPrio());
		if (!$ok) return false;
		$fields["prio"] = $this->getPrio();

		# NOTE: clicked is read-only

		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("AffBanner " . $this->lastError());
			return false;
			}

		return true;
		}

	function setDesc($d)
		{
		$ok = $this->_checkStr($d,CONST_AFFBANNER_DESC_MINLEN,
			CONST_AFFBANNER_DESC_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("AffBanner Desc " . $this->lastError());
			return false;
			}
		$this->desc = $d;
		return true;
		}

	function getDesc()
		{
		return $this->desc;
		}

	function setDiskfilename($f)
		{
		$ok = $this->_checkStr($f,CONST_FILE_NAME_MINLEN,
			CONST_FILE_NAME_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("AffBanner Disk Filename " . $this->lastError());
			return false;
			}
		$this->diskfilename = $f;
		return true;
		}

	function getDiskfilename()
		{
		return $this->diskfilename;
		}

	function setContenttype($f)
		{
		$ok = $this->_checkStr($f,10,200); # arbitrary
		if (!$ok)
			{
			$this->_error("AffBanner Content Type " . $this->lastError());
			return false;
			}
		$this->contenttype = $f;
		return true;
		}

	function getContenttype()
		{
		return $this->contenttype;
		}

	function setRedirectURL($r)
		{
		$ok = $this->_checkStr($r,CONST_AFFBANNER_REDIRURL_MINLEN,
			CONST_AFFBANNER_REDIRURL_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("AffBanner RedirectURL " . $this->lastError());
			return false;
			}
		$this->redirecturl = $r;
		return true;
		}

	function getRedirectURL()
		{
		return $this->redirecturl;
		}

	function setDisplay($d)
		{
		$ok = $this->_checkBool($d);
		if (!$ok)
			{
			$this->_error("AffBanner Display " . $this->lastError());
			return false;
			}
		$this->display = $d;
		return true;
		}

	function getDisplay()
		{
		return $this->display;
		}

	function setPrio($p)
		{
		$ok = $this->_checkInt($p,1,255);
		if (!$ok)
			{
			$this->_error("AffBanner Prio " . $this->lastError());
			return false;
			}
		$this->prio = $p;
		return true;
		}

	function getPrio()
		{
		return $this->prio;
		}

	function getClicked()
		{
		return $this->clicked;
		}

	function bumpClicked()
		{
		global $db;

		if (!$this->id) 
			{
			$this->_error("AffBanner bumpClicked forbidden on vanilla object");
			return false;
			}

		$q = "UPDATE affbanner SET clicked = clicked + 1
			WHERE affbannerid = " . $this->id;
		$db->query($q);
		return true;
		}

	function displayBanners($afterimg="",$underimg="")
		{
		$abids = $this->listSQL("display = 1","","prio,created");

		$r = "";

		if (!count($abids)) return $r;

		foreach ($abids as $abid)
			{
			$ab = new AffBanner($abid);
			if (!$ab->wasOK()) continue;

			$r .= $ab->getLinkedImg($afterimg,$underimg);
			}

		return $r;
		}


	function getImgURL()
		{
		return AFFBANNERIMGURL . "/" .
			basename($this->getDiskFilename());
		}

	function getLinkedImg($afterimg="",$underimg="")
		{
/*
		return "<a href=\"" .
			sprintf(AFFBANNERCLICKLINK,$this->getID()) . "\"><img
			src=\"" . $this->getImgURL() .
			"\" $afterimg></img></a><br>";
*/
		return "<img src=\"" . $this->getImgURL() .
			"\" $afterimg></img></a><br>$underimg";
		}

	}

?>
