<?

# xId: _Obj_SQLTable.php,v 1.3 2003/10/22 15:39:23 norsrc Exp x

# $Id: _Obj_SQLTable.php 5 2004-01-04 13:36:02Z raf $

define("SQLTAB_COLORTYPE_VERTICAL","0");
define("SQLTAB_COLORTYPE_HORIZONTAL","1");
define("SQLTAB_COL_HIDE","%");
define("SQLTAB_COL_THHIDE","%%");
define("SQLTAB_COL_EXTRA","%");

## SQL Table presentation class 0.99d-pre (c) 2002 rafal wiosna
## 	last code update: 2003-03-26 22:46
##
## NOTES:
##
##	Preface:
##
##	This class uses my SQL class, thus global $db statement;
##
##	Constructor:
##
##		The only mandatory parameter is obviously the $table name.
##		If you won't add anything else the class will fetch the
##		table definition by itself and will describe the columns
##		using the names from SQL [but won't show the column
##		descriptions unless you enable it].
##
##		You can put the following elements in the $fields array:
##
##	"Screen" => "SQL" - will label SQL column "SQL" as "Screen"
##	SQLTAB_COL_HIDE => "SQL" - will hide SQL column "SQL" in the column
##		header but WILL still display it (handy if you want divide a
##		row into two) [see *1]
##	SQLTAB_COL_THHIDE => "SQL" - will hide SQL column "SQL" from column
##		description row only
##	"Column" => SQLTAB_COL_EXTRA - will make an extra column "Column"
##		and all the hooks will work on it
##	"_Column" => SQLTAB_COL_EXTRA - if the extra column name starts with
##		an underscore it will be hidden in the column list header,
##		means it's only <th></th>, no data so your browser will
##		render an empty header [see *2]
##
##	If you ommit a column it will be completly ignored, hidden and not
##	available to hooks. If you want to hide the column but make it
##	available to hooks [and maybe it's a primary key you don't want to
##	show...] use SQLTAB_COL_HIDE and setColHook() pointing to return "";
##	type function.
##
##	Hooks:
##
##	All hooks should return a single value which will be used for
##	rendering. In a nutshell: hooks change the rendering.
##
##		$t->setRowHooks("fun") -- will call fun($c,$r,$i,$p)
##			on every row after the rendering is done;
##				$c = the whole row rendered in HTML
##				$r = row array from SQL [mysql_fetch_row()]
##				$i = row # on the screen [starts at 0]
##				$p = primary key value for this row
##		$t->setColHook("fld","fun") -- will call fun($c,$cl,$p)
##			in every row for field named "fld" after the
##			rendering is done for this particular cell;
##				$c = the HTML rendered cell
##				$cl = the CSS class of this row
##				$p = primary key value for this row
##		$t->setFieldValHook("fld","fun") -- will call fun($v,$p)
##			on every row for the field named "fld" prior to
##			the rendering;
##				$v = the raw SQL value for this cell
##				$p = primary key value for this row
##		$t->setSelectFieldHook("fld","fun") -- will call fun($sq)
##			on SELECT agument for the field "fld" [*3], this
##			is a indirect rendering hook;
##				$sq = SQL field name
##
##	Hook note: for SQLTAB_COL_EXTRA type columns the class will use the
##		column description, not the SQL field name obviously...
##
##	Methods:
##
##	$t->setTabDesc($desc) -- sets table description (table's 1st row)
##	$t->setNoRowsMsg($msg) -- sets the message displayed when the
##		table has no available rows [COUNT(*) is 0]
##	$t->setShowRowStart($row) -- sets the x in LIMIT x,y[*4]
##	$t->setShowRowsAtOnce($rows) -- sets the y in LIMIT x,y[*4]
##	$t->setColorCycle($c) -- sets the color cycle period; by default
##		class will use only the "0" elelment; see CSS part!
##	$t->setColorType($t) -- sets the color cycle type, by default
##		it's SQLTAB_COLORTYPE_VERTICAL but you can set
##		SQLTAB_COLORTYPE_HORIZONTAL using this method
##	$t->setShowDesc($s) -- controls the <th> visibility, by defaults
##		columns are not shown, use $t->setShowDesc(true) [$s is
##		boolean!]
##	$t->setSelectCondition($cond) -- adds "WHERE $cond" to the SELECT
##		clause, $cond can be "x = y AND z like '%yes%'" etc
##	$t->setPrimaryKey($field) -- sets the primary key for hook values,
##		usually it's an AUTO_INCREMENT type field
##	$t->setSortBy($field) -- sets sorting; if not used the class won't
##		add GROUP BY statement; you can use "Field DESC" variant
##	$t->setSortable($arr,$url) -- will mark columns as sortable [$arr
##		is an array of sortable field names, $url is an URL for
##		sort links on columns] [*5]
##	$t->setRowMark($r) -- will mark row with primary key equal to $r
##		in a diffrent color [must use setPrimaryKey(); see CSS]
##	$t->dumpNavBar($url[,$txt,$maxshow]) -- returns navigation bar, $url
##		is sprintf statement for links, see [*6], $txt is sprintf
##		statement for the navigation text [see *6], defaults to:
##			"Page %s of %s, %s"
##		$maxshow is yet unimplemented; make sure dumpNavBar() goes
##		after setSelectCondition UNLESS you really want for example
##		TOTAL rows with no condition navbar shown, usually it's
##		always an error not a feature 8^)
##	$t->dumpTable() -- returns the rendered table;
##	$f->setJoins($j) -- adds JOIN statements to query;
##
##	CSS classes:
##
##	.sqltab-table -- the table CSS
##	.sqltab-th -- column header
##	.sqltab-thsort -- sortable column header
##	.sqltab-nav -- navigation bar text
##	.sqltab-navpage -- navigation page link
##	.sqltab-navcurr -- navigation page link of current page
##	.sqltab-elem-0 -- cell color cycle element 0 or cell CSS when no
##		no color cycle is used
##	.sqltab-elem-1 -- cell color cycle element 1 [if color cycle is on]
##	.sqltab-elem-2 -- cell color cycle element 2 [if color cycle is on]
##		...
##	.sqltab-elem-n -- cell color cycle element n
##		[n'es are 0,1,2,..,setColorCycle($c) value MINUS 1]
##	.sqltab-elem-X -- cell color for setRowMark()'ed row [whole row uses
##		it]
##	.sqltab-err -- error or no rows message
##
##	Appendix:
##
##	[*1] handy for subrows, like:
##
##		...
##	SQLTAB_COL_THHIDE => "Msg",
##		...
##	$t->setColHook("Msg","msg");
##		...
##	function msg($v,$class,$pri)
##		{
##		$v = ereg_replace("^<td","<td colspan=\"5\"",$v);
##		return "</tr>\n <tr>$v</td>";
##		}
##
##	[*2] handy for making "suffixes" for rows, like "view" link at the
##		right side of a table with transparent background, example:
##
##	$t->setColHook("_action","view");
##		...
##	function view($v,$class,$pri) { return "<td><a
##		href=\"view.php?id=$pri\">view</a></td>"; }
##
##	As you can see "_action" is a SQLTAB_COL_EXTRA column...
##
##	[*3] example:
##
##	$t->setSelectFieldHook("Created","crt");
##		...
##	function crt($v) { return "UNIX_TIMESTAMP($v) AS $v"; }
##
##	[*4] by default the class won't add any LIMIT x,y statement to the
##		SELECT clause; if you use only the setShowRowsAtOnce($y)
##		method the class will add "LIMIT 0,$y" to SELECT clause and
##		that's probably not what you want; if you use only
##		setShowRowStart($x) method it will add "LIMIT
##		$x,10"; it's best to use both methods together since you
##		will have complete control on $x and $y in LIMIT statement
##
##	[*5] the class does sprintf("<a href=\"%s%s\"",$url,$sort) where
##		$url is the URL passed via field names array in
##		setSortable() method and $sort is sort type from setSortBy()
##		method, example:
##
##	$t->setSortBy($s);	// $s is script GET argument [make sure it's
##				// magic_quoted!]
##	$t->setSortable(array("RowID"),"$PHP_SELF?n=$n&s=");
##		// $n is the argument for setShowRowStart();
##
##	[*6] example:
##
##	echo $t->dumpNavBar("$PHP_SELF?n=%s&s=$s","P%s/%s, %s");
##		1st %s is current page number
##		2nd %s is page count
##		3rd %s are page links
##		$s is a sort type, the one from setSortBy() method
##
##	it will produce for example:
##
##		P2/6, _1 _2 _3 _4 _5 _6	[_x is a link]
##
##	Final note: you can just do
##
##	$t = new SQLTab("Table");
##	echo $t->dumpTable();
##
##	It will work but with default rendering settings [shows all the
##	rows, all the colums, no headers, no forced sorting, no title, no
##	nav bar]. Remember, CSS is mandatory but of course you don't have to
##	define it 8^)
##
##	NOTE: NavBar will only show BELOW the table.

class SQLTable
	{
	var $table;
	var $desc;
	var $fields;
	var $fielddesc;
	var $fieldvalhook;
	var $colhook;
	var $rowstotal;
	var $rowsatonce;
	var $rowstart;
	var $rowhook;
	var $colortype;
	var $colorcycle;
	var $norowsmsg;
	var $showdesc;
	var $selfieldhook;
	var $selwhere;
	var $sortable;
	var $sortby;
	var $sorturl;
	var $primarykey;
	var $markrow;
	var $err;
	var $join;
		
	function SQLTable($table,$fields=array())
//	NOTE: fields can be null

		{
		global $db;
		
		$this->markrow = -1;
		$this->fields = array();
		$this->fieldvalhook = array();
		$this->selfieldhook = array();
		$this->selwhere = "";
		$this->colhook = array();
		$this->colortype = $colortype;
		$this->table = $table;
		$this->desc = $table;
		$this->norowsmsg = "Empty";
		$this->rowstart = 0;
		$this->rowsatonce = 0;
		$this->err = "";
		$this->colorcycle = 0;
		$this->colortype = SQLTAB_COLORTYPE_VERTICAL;
		$this->showdesc = false;
		$this->rowhook = "";
		$this->sortable = array();
		$this->sortby = "";
		$this->sorturl = "";
		$this->primarykey = "";
		$this->joins = "";

		$qq = $db->query("SHOW TABLES LIKE '$table'");
		if (!$qq->numRows())
			{
			$this->err = "UNKNOWN TABLE '$table'";
			return;
			}

		if (!count($fields))
			{
			$qq = $db->query("SHOW FIELDS FROM $table");
			if (!$qq->numRows())
				{
				$this->err = "NO ROWS IN TABLE '$table'";
				return;
				}			

			while ($r = $qq->fetchArray())
				{
				$this->fields[] = $r["Field"];
				$this->fielddesc[] = $r["Field"];
				}
			}			
		else
			{
			reset($fields);
			for ($i = 0; $i < count($fields); $i++)
				{
				$k = key($fields);
				$this->fields[] = $fields[$k];
				$this->fielddesc[] = $k;
				next($fields);
				}
			}

		$qq = $db->query("SELECT COUNT(*) AS Count FROM $table");
		if (!$qq->numRows())
			{
			$this->err = "CANNOT COUNT() TABLE '$table'";
			return;
			}

		$this->rowstotal = $qq->f("Count");
		}

	function setTabDesc($desc) { $this->desc = $desc; }
	function setNoRowsMsg($msg) { $this->norowsmsg = $desc; }
	function setShowRowStart($row) { $this->rowstart = $row; }
	function setShowRowsAtOnce($rows) { $this->rowsatonce = $rows; }
	function setColorCycle($c) { $this->colorcycle = $c; }
	function setColorType($t) { $this->colortype = $t; }
	function setShowDesc($s) { $this->showdesc = $s; }
	function setRowHook($func) { $this->rowhook = $func; }
	function setRowMark($r) { $this->markrow = $r; }
	function setFieldValHook($field,$func)
		{ $this->fieldvalhook[$field] = $func; }
	function setColHook($col,$func) { $this->colhook[$col] = $func; }
	function setSelectFieldHook($field,$func)
		{ $this->selfieldhook[$field] = $func; }
	function setPrimaryKey($field) { $this->primarykey = $field; }
	function setSortBy($field) { $this->sortby = $field; }

	function setJoins($joins)
		{
		$this->joins = $joins;
		}

	function setSelectCondition($cond)
		{
		global $db;

		# because the condition will change the rowcount we re-do it
		$qq = $db->query("SELECT COUNT(*) AS Count FROM $this->table
			$this->joins WHERE $cond");
		if (!$qq->numRows())
			{
			$this->err = "CANNOT COUNT() TABLE '$table'";
			return;
			}

		$this->rowstotal = $qq->f("Count");
		$this->selwhere = $cond;
		}
	function setSortable($arr,$url)
		{
		$this->sorturl = $url;
		foreach ($arr as $v)
			{
			$this->sortable[$v] = 1;
			}
		}
		
	function dumpNavBar($url,$txt="Page %s of %s, %s",$maxshow=0)
		{
		$o = "";
		if ($this->rowstotal)
			{
			$page = floor($this->rowstart / $this->rowsatonce) + 1;
			$pages = ceil($this->rowstotal / $this->rowsatonce);

			$a = "";
			
			for ($i = 0; $i < $pages; $i++)
				{
				$hit = "sqltab-navpage";
				if ($i == ($page-1)) $hit = "sqltab-navcurr";
				$u = @sprintf($url,$i * $this->rowsatonce);
				$u = ereg_replace("%%","%",$u);
				$a .= "<a href=\"$u\">";
				$a .= "<span class=\"$hit\">" . ($i+1) .
					"</span></a> ";
				}

			$o .= sprintf($txt,$page,$pages,$a);
			}

		return "<span class=\"sqltab-nav\">$o</span>\n";
		}

	function dumpTable()
		{
		global $db;

		if ($this->err)
			{
			return "<table class=\"sqltab-table\">
				<tr><td class=\"sqltab-err\">" .
				$this->err . "</td></tr>\n</table>\n";
			}

		$q = "SELECT ";
		
		for ($i = 0; $i < count($this->fields); $i++)
			{
			if ($this->fields[$i] != SQLTAB_COL_EXTRA)
				{
				$f = $this->fields[$i];
				$s = $this->selfieldhook[$this->fields[$i]];
				if (strlen($s))
					$q .= call_user_func($s,$f) . ",";
				else
					$q .= "$f,";
				}
			}
		
		$q = substr($q,0,-1);
		
		$q .= " FROM " . $this->table;

		if (strlen($this->joins)) $q .= " " . $this->joins;

		if (strlen($this->selwhere)) $q .= " WHERE " . $this->selwhere;
		
		if (strlen($this->sortby)) $q .= " ORDER BY " . $this->sortby;
		
		if ($this->rowsatonce) $q .= " LIMIT " .
			$this->rowstart . "," . $this->rowsatonce;

//		echo "q=$q<br>";
		
		$qq = $db->query($q);
//		$this->rowstotal = $qq->numRows();
				
		$o = "<table class=\"sqltab-table\">\n";

		if ($this->showdesc)
			{
			$o .= "<tr>";
			for ($i = 0; $i < count($this->fields); $i++)
				{
				if (
					($this->fielddesc[$i] != SQLTAB_COL_HIDE)
					&&
					($this->fielddesc[$i] != SQLTAB_COL_THHIDE)
				   )
					{
					$oo = "<th class=\"sqltab-th\">";
					$h = $this->fielddesc[$i];
					$s = $this->fields[$i];

					if (strlen($this->sortable[$s]))
						{
						$h = sprintf("<a
		href=\"%s%s\"><span class=\"sqltab-thsort\">$h</span></a>",
		$this->sorturl,urlencode($s . ($this->sortby == $s ?
					" DESC" : "")));
						}
					$oo .= "$h</th>\n";
					}
				else $oo = "";
				if (substr($this->fielddesc[$i],0,1) == "_")
					$oo = "";
				
				$o .= $oo;
					
				}
			$o .= "</tr>\n";
			}
		
		$j = 0;

		while ($r = $qq->fetchArray())
			{
			$pri = (strlen($this->primarykey) ?
				$r[$this->primarykey] : 0);
			$oo = "";
			
			$e = 0;
			
			if ($this->colorcycle &&
				$this->colortype == SQLTAB_COLORTYPE_VERTICAL)
				$e = $j % $this->colorcycle;

			for ($i = 0; $i < count($this->fields); $i++)
				{
				if ($this->colorcycle &&
					$this->colortype == SQLTAB_COLORTYPE_HORIZONTAL)
					$e = $i % $this->colorcycle;

				if ($pri == $this->markrow) $e = "X";
				
				$ooo = "<td class=\"sqltab-elem-$e\">";

				$f = $this->fields[$i];
				if ($f == SQLTAB_COL_EXTRA) $f =
					$this->fielddesc[$i];

				$v = $r[$f];
				$fh = $this->fieldvalhook[$f];
				if (strlen($fh)) $v = call_user_func($fh,$v,
					$pri);

				$ooo .= htmlspecialchars($v) . "</td>";

				$ch = $this->colhook[$f];
				if (strlen($ch))
					$ooo = call_user_func($ch,$ooo,
						"sqltab-elem-$e",$pri);
				if ($this->fielddesc[$i] != SQLTAB_COL_HIDE)
					$oo .= $ooo;
				}

			if ($this->rowhook)
				{
				$o .= call_user_func($this->rowhook,$oo,
					$r,$j,$pri);
				}
			else
				{
				$o .= "<tr>$oo</tr>\n";
				}
			$j++;
			}

		if (!$qq->numRows())
			{
			$o .= "<tr><td class=\"sqltab-err\">" .
				$this->norowsmsg . "</td></tr>\n";
			}

		return $o . "</table>";
		}
	}
?>
