<?

# xId: _Obj_Form.php,v 1.23 2003/12/18 15:08:45 norsrc Exp x

# $Id: _Obj_Form.php 676 2005-07-26 04:02:26Z raf $

define("FTYPE_FORM","0");
define("FTYPE_INFO","1");
define("FTYPE_ERR","2");
define("FTYPE_INPUT","3");
define("FTYPE_SUBMIT","4");
define("FTYPE_HIDDEN","5");
define("FTYPE_DIRECT","6");
define("FTYPE_BREAK","7");
define("FTYPE_FILE","8");

define("SELECT_NONE",0);
define("SELECT_ABLE",1);
define("SELECT_BINDS",2);

define("INP_TABLE_DEF","cellspacing=\"0\"");

class Form
	{
	var $csp = 2;	// default colspan
	var $out;	// array of output
	var $fields;	// array of fields
	var $last = 1;	// last field pointer
	var $errn = 0;	// error number
	var $errr = 0;	// error message row
	var $fieldmore = "div";
	var $submitmore = "div";
	var $forcecheck = false;
	var $dontcloseform = false;
	var $tablecss = "inp-table";

	var $formmeth = "";
	var $formurl = "";
	var $formenctype = "";
	var $formname = "";

	function Form($meth,$url,$enctype="",$formname="form0")
		{
		$this->formmeth = $meth;
		$this->formurl = $url;
		$this->formenctype = $enctype;
		$this->formname = $formname;

		$this->fields = array();

		$this->makeTable();
		}

	function makeTable()
		{
		$this->fields[0]["desc"] = "<form name=\"" .
			$this->formname . "\" action=\"" .
			$this->formurl . "\" method=\"" .
			$this->formmeth . "\"";
		if (isset($this->formenctype) && strlen($this->formenctype))
			$this->fields[0]["desc"] .= " enctype=\"" .
				$this->formenctype . "\"";
		$this->fields[0]["desc"] .= "><table class=\"" .
			$this->tablecss . "\" " .
			(INP_TABLE_DEF) . ">";
		$this->fields[0]["ftype"] = FTYPE_FORM;
		}

	function setTableCSS($tcss)
		{
		$this->tablecss = $tcss;
		$this->makeTable();
		}

	function setFormName($fn) { $this->formname = $fn; }
	function forceCheck() { $this->forcecheck = true; }
	function dontCloseForm() { $this->dontcloseform = true; }
	function setFieldMoreSpanDiv($div) { $this->fieldmore = $div; }
	function setSubmitMoreSpanDiv($div) { $this->fieldmore = $div; }
	function dontShowThisField()
		{
		$this->fields[($this->last)-1]["show"] = false;
		}

	function addErrInfoRow($txt)
		{
		$f = $this->last++;

		$this->fields[$f]["ftype"] = FTYPE_ERR;
		$this->fields[$f]["desc"] = $txt;
		}

	function addInfoRow($txt)
		{
		$f = $this->last++;

		$this->fields[$f]["ftype"] = FTYPE_INFO;
		$this->fields[$f]["desc"] = $txt;
		}

	function addDirectRender($txt)
		{
		$f = $this->last++;

		$this->fields[$f]["ftype"] = FTYPE_DIRECT;
		$this->fields[$f]["desc"] = $txt;
		}

	function addSubmit($txt="Submit",$more="")
		{
		$f = $this->last++;

		$this->fields[$f]["ftype"] = FTYPE_SUBMIT;
		$this->fields[$f]["desc"] = $txt;
		$this->fields[$f]["more"] = $more;
		}

	function addButton($txt="BUTTON",$onclick="javascript:alert('??');",
			$more="")
		{
		$f = $this->last++;

		$this->fields[$f]["ftype"] = FTYPE_SUBMIT;
		$this->fields[$f]["desc"] = $txt;
		$this->fields[$f]["more"] = $more;
		$this->fields[$f]["onclick"] = $onclick;
		}

	function addBreak()
		{
		$f = $this->last++;

		$this->fields[$f]["ftype"] = FTYPE_BREAK;
		}

	function addField($var,$type,$desc,$more="")
		{
		global $$var;
		$f = $this->last++;

		$this->fields[$f]["show"] = true;
		$this->fields[$f]["var"] = $var;
		$this->fields[$f]["desc"] = $desc;
		$this->fields[$f]["more"] = $more;
		$this->fields[$f]["value"] = $$var;
		$this->fields[$f]["type"] = $type;
		$this->fields[$f]["htmltype"] = $this->getFieldType($type,$var);
		$this->fields[$f]["err"] = "";
		$this->fields[$f]["notr_lead"] = 0;
		$this->fields[$f]["notr_end"] = 0;
		$this->fields[$f]["ftype"] = FTYPE_INPUT;
		$this->fields[$f]["select"] = SELECT_NONE;
		$this->fields[$f]["selectarr"] = array();
		$this->fields[$f]["diabled"] = false;
		$this->fields[$f]["onchange"] = false;
		$this->fields[$f]["onclick"] = false;

		$a = $this->getTypeArgs($type);

/*
		// this takes care of preloading checkbox
		if (ereg("^checkbox",$type))
			{
			if (!strlen($$var) && !ereg("defno",$a[3]))
				$$var = $a[1];
				}
				$this->fields[$f]["value"] = $a[1];

			}
*/

		}

	function addHidden($var,$txt)
		{
		$f = $this->last++;

		$this->fields[$f]["var"] = $var;
		$this->fields[$f]["desc"] = $txt;
		$this->fields[$f]["ftype"] = FTYPE_HIDDEN;
		}
	function addFile($var,$desc,$more="")

		{

		$f = $this->last++;


		$this->fields[$f]["show"] = true;

		$this->fields[$f]["var"] = $var;

		$this->fields[$f]["desc"] = $desc;

		$this->fields[$f]["more"] = $more;

		$this->fields[$f]["ftype"] = FTYPE_FILE;

		$this->fields[$f]["err"] = "";


		}


	function addSelect($selectarr,$select_type=SELECT_ABLE)
		{
		$f = $this->last-1;
		$this->fields[$f]["select"] = $select_type;
		$this->fields[$f]["selectarr"] = $selectarr;
		$this->fields[$f]["htmltype"] = "hidden";
		}

	function makeDisabled()
		{
		$f = $this->last-1;
		$this->fields[$f]["disabled"] = true;
		}

	function setOnChange($onch)
		{
		$f = $this->last-1;
		$this->fields[$f]["onchange"] = $onch;
		}

	function setValue($var,$value)
		{
//		echo "setValue($var,$value)<br>";
		for ($i = 0; $i < count($this->fields); $i++)
			{
			if (isset($this->fields[$i]["var"]) &&
				($this->fields[$i]["var"] == $var))
				{
				$this->fields[$i]["value"] = $value;
				}
			}
		}

	function getValue($var)
		{
		$r = "";
//		echo "getValue($var)<br>";
		for ($i = 0; $i < count($this->fields); $i++)
			{
			if (!isset($this->fields[$i]["var"])) 
				$this->fields[$i]["var"] = "";
//			echo $this->fields[$i]["var"] . " == $var<br>";
			if ($this->fields[$i]["var"] == $var)
				{
				$r = $this->fields[$i]["value"];
//				echo "r=$r<br>";
				
				if (ereg("^checkbox",$this->fields[$i]["type"]))
					{
					$a = $this->getTypeArgs($this->fields[$i]["type"]);
					global $$var;
					$b = $$var;
//					echo "var=$var vvar='$b' strlen(vvar)=" . strlen($b) . "<br>";
					if (!strlen($$var)) // not checked
						$r = $a[2];
					}
				}
			}
		return $r;
		}

	function makeError($var,$msg)
		{
		$this->errn++;

		for ($i = 0; $i < count($this->fields); $i++)
			{
			if (isset($this->fields[$i]["var"]) &&
				$this->fields[$i]["var"] == $var)
				{
				$this->fields[$i]["err"] = $msg;
				}
			}
		}

	function bumpErrors()
		{
		$this->errn++;
		}

	function checked($i,$value)
		{
		$a = $this->getTypeArgs($this->fields[$i]["type"]);
//		echo "i=$i value=$value a1=$a[1]<br>";
		if ($value == $a[1]) return "checked ";
		return "";
		}
/*

Supported field types:

string,x,y,o,m	- text filed, min x chars [can be 0!], max y chars
		o = notnull -- do not accept no input
		o = nullok -- accept empty
		m = input's maxlength [optional]
azstring,x,y,o,m - text filed, only [A-Za-z] allowed, min x chars [can be 0!], max y chars
		o = notnull -- do not accept no input
		o = nullok -- accept empty
		m = input's maxlength [optional]
az09string,x,y,o,m - text filed, only [A-Za-z0-9] allowed, min x chars [can be 0!], max y chars
		0-9 cannot be 1st!
		o = notnull -- do not accept no input
		o = nullok -- accept empty
		m = input's maxlength [optional]
vhname,x,y,o,m	- virtual host [WWW] name, min x chars [can be 0!], max y chars
		o = notnull -- do not accept no input
		o = nullok -- accept empty
		m = input's maxlength [optional]
password,x,y,a,o - password field, min x chars [can be 0!], max y chars
		a is available character set, defaults to "0-9A-Za-z_-"
		o = nullok -- accept empty
mail,x,o	- text field, min 5 characters, max x characters
		o = resolve -- check domain's A or MX avaliability
		o = nullok -- accept empty
checkbox,s,u	- checkbox field, s = value for checked, u = value for
		unchecked (for SQL and security), NOTE: to have checkbox
		for no just reverse s and u!
num,x,y,o	- numeric field, min x chars, max y chars
		o = notnull -- do not accept no input
		o = nullok -- do not check for numeric if no input
		o = negok -- accept negative values
		o = float -- accept floats
textarea,c,r,l,o
		- textarea, c - columns, r - rows, l - max len
		o = notnull -- do not accept no input
static		- static field -- just shows up, it's up to userfunction to
		check if the field's not changed
		
NOTE: options can be grouped, for example "notnull+noslash"
NOTE2: hidden fields are handled by a separate addHidden() method

NOTE3: file upload fields are handled by the deperate addFile() method

*/

	function getFieldType($type)
		{
		if (ereg("^num",$type))
			{
			$r = "text";
			$a = $this->getTypeArgs($type);
			if (strlen($a[2])) $r = "text\" size=\"$a[2]\"
				maxlength=\"$a[2]";
			return $r;
			}
		if (ereg("^string",$type))
			{
			$r = "text";
			$a = $this->getTypeArgs($type);
			$m = $a[2];
			if (isset($a[4])) $m = $a[4];
			if (strlen($a[2])) $r = "text\" size=\"$m\"
				maxlength=\"$a[2]";
			return $r;
			}
		if (ereg("^azstring",$type))
			{
			$r = "text";
			$a = $this->getTypeArgs($type);
			$m = $a[2];
			if (isset($a[4])) $m = $a[4];
			if (strlen($a[2])) $r = "text\" size=\"$m\"
				maxlength=\"$a[2]";
			return $r;
			}
		if (ereg("^az09string",$type))
			{
			$r = "text";
			$a = $this->getTypeArgs($type);
			$m = $a[2];
			if (isset($a[4])) $m = $a[4];
			if (strlen($a[2])) $r = "text\" size=\"$m\"
				maxlength=\"$a[2]";
			return $r;
			}
		if (ereg("^vhname",$type))
			{
			$r = "text";
			$a = $this->getTypeArgs($type);
			$m = $a[2];
			if (isset($a[4])) $m = $a[4];
			if (strlen($a[2])) $r = "text\" size=\"$m\"
				maxlength=\"$a[2]";
			return $r;
			}
		if (ereg("^password",$type))
			{
			$r = "password";
			$a = $this->getTypeArgs($type);
			if (strlen($a[2])) $r = "password\" size=\"$a[2]\"
				maxlength=\"$a[2]";
			return $r;
			}
		if (ereg("^mail",$type))
			{
			$r = "text";
			$a = $this->getTypeArgs($type);
			if (strlen($a[1])) $r = "text\" size=\"$a[1]\"
				maxlength=\"$a[1]";
			return $r;
			}
		if (ereg("^url",$type))
			{
			$r = "text";
			$a = $this->getTypeArgs($type);
			if (strlen($a[1])) $r = "text\" size=\"$a[1]\"
				maxlength=\"$a[1]";
			return $r;
			}
		if (ereg("^checkbox",$type)) return "checkbox";
		if (ereg("^textarea",$type)) return "textarea";
		if (ereg("^static",$type)) return "text";
		return "text";
		}

	function getTypeArgs($t)
		{
		return split(",",$t);
		}

	function checkField($extracheckfunction="")
		{
		if ($_SERVER["REQUEST_METHOD"] == "GET" && !$this->forcecheck) return;

		$f = $this->last - 1;
		if (ereg("^static",$this->fields[$f]["type"])) return;

		$v = $this->fields[$f]["value"];

		if (isset($this->fields[$f]["select"]))
			{
			if ($this->fields[$f]["select"] == SELECT_BINDS)
				{
				$alien = true;
				foreach ($this->fields[$f]["selectarr"] as
					$key => $val)
					{
					if ($v == $val) $alien = false;
					}
				if ($alien) 
					{
					$this->fields[$f]["err"] =
						"Niedopuszczalna warto\B6\E6";
					$this->errn++;
					return;
					}
				}
			}

		$lasterr = $this->errn;
		$this->checkfield_internal();
		if ($lasterr != $this->errn) return;
		if (!strlen($extracheckfunction)) return;

		$paramarr = array();
		for ($i = 0; $i < count($this->fields); $i++)
			{
			if (isset($this->fields[$i]["var"]) &&
				isset($this->fields[$i]["value"]))
				$paramarr[$this->fields[$i]["var"]] =
					$this->fields[$i]["value"];
			}

		$ret = call_user_func($extracheckfunction,$v,$paramarr);
		if (strlen($ret))
			{
			$this->fields[$f]["err"] = $ret;
			$this->errn++;
			}
		return;
		}

	function checkfield_internal()
		{
		$f = $this->last - 1;	// previous field since we increment
		$v = $this->fields[$f]["value"];
		$t = $this->fields[$f]["type"];

		$tmp = $this->getTypeArgs($t);
		$a1 = (isset($tmp[1]) ? $tmp[1] : "");
		$a2 = (isset($tmp[2]) ? $tmp[2] : "");
		$a3 = (isset($tmp[3]) ? $tmp[3] : "");
		$a4 = (isset($tmp[4]) ? $tmp[4] : "");

//		echo "f=$f v=$v t=$t tmp=$tmp a1=$a1 a2=$a2 a3=$a3<br>";

		if (ereg("^static",$t)) return;

		if (ereg("^string",$t))
			{
			if (ereg("nullok",$a3) && !strlen($v))
				return;

			if (ereg("notnull",$a3) && !strlen($v))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Cannot be empty";
				return;
				}
			if (strlen($v) < $a1)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Too short
					(min $a1 chars)";
				return;
				}
			if (strlen($v) > $a2)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Too long
					(max $a2 chars)!";
				return;
				}
			return;
			}

		if (ereg("^azstring",$t))
			{
			if (ereg("nullok",$a3) && !strlen($v))
				return;

			if (ereg("notnull",$a3) && !strlen($v))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "This field cannot be empty";
				return;
				}
			if (strlen($v) < $a1)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Too short
					(min $a1 chars)";
				return;
				}
			if (strlen($v) > $a2)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Too long
					(max $a2 chars)";
				return;
				}
			$v2 = ereg_replace("[^a-zA-Z]","*",$v);
			if (substr_count($v2,"*"))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Invalid characters used";
				return;
				}
			return;
			}

		if (ereg("^az09string",$t))
			{
			if (ereg("nullok",$a3) && !strlen($v))
				return;

			if (ereg("notnull",$a3) && !strlen($v))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Pole nie mo\BFe
					by\E6 puste";
				return;
				}
			if (strlen($v) < $a1)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Pole za kr\F3tkie
					(co najmniej $a1 zn.)";
				return;
				}
			if (strlen($v) > $a2)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Pole za d\B3ugie
					(do $a2 znak\F3w)!";
				return;
				}
			$v2 = ereg_replace("[^a-zA-Z0-9]","*",$v);
			if (substr_count($v2,"*"))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Nieprawid\B3owa nazwa";
				return;
				}
			$v2 = ereg_replace("^[^a-zA-Z]","*",$v);
			if (substr_count($v2,"*"))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Nie mo\BFna zaczyna\E6 liczb\B1";
				return;
				}
			return;
			}

		if (ereg("^vhname",$t))
			{
			if (ereg("nullok",$a3) && !strlen($v))
				return;

			if (ereg("notnull",$a3) && !strlen($v))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Pole nie mo\BFe
					by\E6 puste";
				return;
				}
			if (strlen($v) < $a1)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Pole za kr\F3tkie
					(co najmniej $a1 zn.)";
				return;
				}
			if (strlen($v) > $a2)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Pole za d\B3ugie
					(do $a2 znak\F3w)!";
				return;
				}
			$v2 = str_replace(".-",".",$v);
			if (substr_count($v2,".."))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Nieprawid\B3owa nazwa (1)";
				return;
				}
			if (ereg("^\.",$v))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Nieprawid\B3owa nazwa (2)";
				return;
				}
			if (ereg("\.$",$v))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Nieprawid\B3owa nazwa (3)";
				return;
				}
			$v2 = ereg_replace("[^a-zA-Z0-9\.-]","*",$v);
			if (substr_count($v2,"*"))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Nieprawid\B3owa nazwa (4)";
				return;
				}
			return;
			}

		if (ereg("^num",$t))
			{
			if (ereg("nullok",$a3) && !strlen($v)) return;
			if (ereg("notnull",$a3) && !strlen($v))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Cannot be empty";
				return;
				}
			if (strlen($v) < $a1)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Too short
					(min $a1 chars)!";
				return;
				}
			if (strlen($v) > $a2)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Too long
					(max $a2 chars)!";
				return;
				}
			if (!is_numeric($v))
				{
				if (ereg("nullok",$a3) && !strlen($v))
					return;
				$this->errn++;
				$this->fields[$f]["err"] = "Must conaint a
					number";
				return;
				}
			if (ceil($v) != $v && (!ereg("float",$a3)))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Floats not allowed";
				return;
				}
			if ($v < 0)
				{
				if (ereg("negok",$a3)) return;
				$this->errn++;
				$this->fields[$f]["err"] = "Only positive values";
				return;
				}
			return;
			}

		if (ereg("^mail",$t))
			{
			if (ereg("nullok",$a2) && !strlen($v)) return;

			if (!strlen($v))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Enter e-mail
					address here";
				return;
				}
			if ((strlen($v) < 5))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Address too short";
				return;
				}
			if (strlen($v) > $a1)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Address too long
					(max $a1 chars)";
				return;
				}
			if (ereg_replace("[^@0-9A-Za-z_\.=-]","",$v) != $v)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Invalid character(s)";
				return;
				}

		        $matched = array();
			$v = strtolower($v);
			preg_match("/[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+\.([a-z0-9-]+\.)*[a-z]{2,4}/",$v,$matched);

			if (!count($matched))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Invalid e-mail
					address (1)";
				return;
				}

			if ($matched[0] != $v)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Invalid e-mail
					address (2)";
				return;
				}

			if (ereg("resolve",$a2))
				{
				list($local,$domain) = split("@",$v);

				$dmx = checkdnsrr($domain,"MX");
				$da = checkdnsrr($domain,"A");

//				echo "d=$domain dmx=$dmx da=$da<br>";

				if (!$dmx && !$da)
					{
					$this->errn++;
					$this->fields[$f]["err"] =
						"Invalid domain";
					return;
					}
				}
			return;
			}

		if (ereg("^password",$t))
			{
			if (ereg("nullok",$a4) && !strlen($v))
				return;

			if (!strlen($a3)) $a3 = "0-9A-Za-z_-";

			if (!strlen($v))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Musisz wpisa\E6
					has\B3o!";
				return;
				}
			if (strlen($v) < $a1)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Has\B3o za kr\F3tkie
					(co najmniej $a1 zn.)!";
				return;
				}
			if (strlen($v) > $a2)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Has\B3o za d\B3ugie
					(do $a2 znak\F3w)!";
				return;
				}

//			echo "p=$v regexp=[^$a3] r=" .
//			ereg_replace("[^" . $a3 . "]","",$v) . "<br>";

			if (ereg_replace("[^" . $a3 . "]","",$v) != $v)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Has\B3o zawiera<br>
					niedopuszczalne znaki!";
				return;
				}
			return;
			}

		if (ereg("^checkbox",$t))
			{
			if (($v != $a1) && ($v != $a2) && (strlen($v)))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Nieprawid\B3owa
				warto\B6\E6<br>pola - &quot;$v&quot;";
				}
			return;
			}

		if (ereg("^url",$t))
			{
			if (!strlen($v))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Musisz wpisa\E6<br>
					adres strony!";
				return;
				}
			if (strlen($v) < 11)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Adres strony
					jest<br>za kr\F3tki (co najmniej 11 zn.)!";
				return;
				}
			if (strlen($v) > $a1)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Adres strony
					jest<br>za d\B3ugi (do $a1 zn.)!";
				return;
				}

			if (!eregi("http://",$v))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Adres strony
					musi<br>zaczyna\E6 si\EA od http://!";
				return;
				}

			return;
			}

		if (ereg("^textarea",$t))
			{
			if (ereg("notnull",$a4) && !strlen($v))
				{
				$this->errn++;
				$this->fields[$f]["err"] = "This textarea
					cannot be empty";
				return;
				}
			if (strlen($v) > $a3)
				{
				$this->errn++;
				$this->fields[$f]["err"] = "Too many
					characters (max $a3)";
				return;
				}
			return;
			}

		$this->errn++;
		$this->fields[$f]["err"] = "Nieznay typ
			pola<br>&quot;$t&quot;";
		return;
		}

	function numErr()
		{
		return $this->errn;
		}

	function bumpErr()
		{
		$this->errn++;
		}

	function dumpForm()
		{
		$r = "";

		for ($i = 0; $i < count($this->fields); $i++)
			{
			
			$ft = $this->fields[$i]["ftype"];

			if (!isset($this->fields[$i]["htmltype"]))
				$this->fields[$i]["htmltype"] = "";
			if (!isset($this->fields[$i]["show"]))
				$this->fields[$i]["show"] = true;
			if (!isset($this->fields[$i]["type"]))
				$this->fields[$i]["type"] = "";

			$ht = $this->fields[$i]["htmltype"];
			if (!$this->fields[$i]["show"]) $ht = "hidden";

//			echo "ht[$i] = $ht " . $this->fields[$i]["show"] . "<br>";
						
			$r .= "\n";

			$tmp = $this->getTypeArgs($this->fields[$i]["type"]);
			$a1 = (isset($tmp[1]) ? $tmp[1] : "");
			$a2 = (isset($tmp[2]) ? $tmp[2] : "");
			$a3 = (isset($tmp[3]) ? $tmp[3] : "");
			$a4 = (isset($tmp[4]) ? $tmp[4] : "");

			if ($ft == FTYPE_HIDDEN)
				{
				$r .= "<input type=\"hidden\"
					name=\"" . $this->fields[$i]["var"] .
					"\" value=\"" .
					$this->fields[$i]["desc"] .
					"\"></input>";
				}
			if ($ft == FTYPE_FILE)

				{

				$ff = $this->fields[$i];

				$c = ($i % 2);

				if (!$ff["notr_lead"])

					$r .= "<tr>";

				$r .= "<td class=\"inp-left-td$c\">";



				if (strlen($ff["err"]))
					$r .= "<b>";
				$r .= "<div class=\"inp-left-txt$c\">" .
					$ff["desc"] . ":";



				if (strlen($ff["err"]))
					$r .= "<br><span class=\"inp-err-txt\">" .
						$ff["err"] .
						"</span></b>";



				$r .= "</td>\n<td class=\"inp-right-td$c\">";


				$div = $this->fieldmore;
				$r .= "<$div class=\"inp-right-txt$c\">";


				$r .= "<input type=\"file\" ";


				if (!isset($ff["disabled"]))
					{
					$r .= "class=\"inp-file\" ";
					$r .= "name=\"" . $ff["var"] . "\"";

					if (isset($ff["onchange"]))
						{
						if ($ff["onchange"])
							$r .= " onchange=\"" .
							$ff["onchange"] . "\" ";
						}
					}
					

				if (isset($ff["disabled"]))

					$r .= $ff["value"] . "</span>";

					$r .= " />";


				$r .= "</$div>";



				if (strlen($ff["more"]))
					{
					$r .= "<$div class=\"inp-right-more\">" .
					$this->fields[$i]["more"] . "</$div>";
					}

				$r .= "</td>";


				if (!$this->fields[$i]["notr_end"]) $r .= "</tr>";
				}

			if ($ft == FTYPE_FORM)
				{
				$r .= $this->fields[$i]["desc"];
				}

			if ($ft == FTYPE_INFO)
				{
				$r .= "<tr><td class=\"inp-info-td\"
					colspan=\"" . $this->csp . "\"><div
					class=\"inp-info-txt\">" .
					$this->fields[$i]["desc"] .
					"</div>";
				$r .= "</td></tr>";
				}

			if ($ft == FTYPE_DIRECT)
				{
				$r .= $this->fields[$i]["desc"];
				}

			if ($ft == FTYPE_BREAK)
				{
				$r .= "<tr><td class=\"inp-break-td\"
					colspan=\"" . $this->csp . "\"><div
					class=\"inp-break-txt\">&nbsp;</div></td></tr>";
				}

			if ($ft == FTYPE_ERR && $this->errn)
				{
				$r .= "<tr><td class=\"inp-erow-td\"
					colspan=\"" . $this->csp . "\"><div
					class=\"inp-erow-txt\">" .
					sprintf($this->fields[$i]["desc"],
						$this->errn) .
					"</div></td></tr>";
				}

			if ($ft == FTYPE_SUBMIT)
				{
				$buttons =
					explode("|",$this->fields[$i]["desc"]);
				if (isset($this->fields[$i]["onclick"]))
					$onclicks =
						explode("|",$this->fields[$i]["onclick"]);
				else
					$onclicks = array();

				$stype = (isset($this->fields[$i]["onclick"])
					? "button" : "submit");
				$c = ($i % 2);
				$bgc = ($stype == "submit" ?
					"inp-submit-td" : "inp-left-td$c");

				$div = $this->submitmore;
				$r .= "<tr><td class=\"$bgc\" align=\"center\"
					colspan=\"" . $this->csp . "\">";

				for ($j = 0; $j < count($buttons); $j++)
					{
					$r .= "<input class=\"but-$stype\"
						type=\"$stype";

					if (isset($onclicks[$j]))
					$r .= "\" onclick=\"" .
						$onclicks[$j];

					$r .= "\" value=\"" . $buttons[$j] .
						"\"></input>&nbsp;";
					}

				$r .= "<$div
					class=\"inp-$stype-txt\">" .
					$this->fields[$i]["more"] .
					"</$div></td></tr>";
				}

			if ($ft == FTYPE_INPUT)
				{
				$ff = $this->fields[$i];
				$c = ($i % 2);

				if (!$ff["notr_lead"])
					$r .= "<tr>";

				$r .= "<td class=\"inp-left-td$c\"";

//				if ($csp1) $r .= " colspan=\"$csp1\"";

				$r .= ">";

				if (strlen($ff["err"]))
					$r .= "<b>";

				$r .= "<div class=\"inp-left-txt$c\">" .
					$ff["desc"] . ":";

				if (strlen($ff["err"]))
					$r .= "<br><span class=\"inp-err-txt\">" .
						$ff["err"] .
						"</span></b>";

				$r .= "</td>\n<td class=\"inp-right-td$c\"";

//				if ($csp2) $r .= " colspan=\"$csp2\"";

				$r .= ">";

//				echo "[$i]name=" . $ff["var"];
//				echo " value=" . $ff["value"] . "<br>";

				$div = $this->fieldmore;
				if (ereg("^checkbox",$ht)) $div ="span";

				$r .= "<$div class=\"inp-right-txt$c\">";

				if (ereg("^textarea",$ht))
					$r .= "<textarea cols=\"$a1\"
						rows=\"$a2\" ";
				else if (isset($ff["disabled"]))
					$r .= "<span class=\"inp-right-disabled\">";
				else if (ereg("^checkbox",$ht))
					{
					$r .= "<input type=\"$ht\"
						class=\"but-ckbox\" ";
					$r .= $this->checked($i,$ff["value"]);
					}
				else	
					$r .= "<input type=\"$ht\" ";

				if (!isset($ff["disabled"]))
					{
					$r .= "class=\"inp-input\" ";
					$r .= "name=\"" . $ff["var"] .
						"\"";

					if (isset($ff["onchange"]))
						{
						if ($ff["onchange"])
							$r .= " onchange=\"" .
							$ff["onchange"] . "\" ";
						}
					}
					
				if (isset($ff["disabled"]))
					$r .= $ff["value"] . "</span>";
				else if (!ereg("^textarea",$ht))
					$r .= " value=\"" .
						htmlspecialchars($ff["value"]) .
						"\"></input>";
				else
					$r .= ">" . htmlspecialchars($ff["value"]) .
						"</textarea>";

				if (count($ff["selectarr"]) && $ff["select"])
					{
					$fn = $this->formname;
					$sl = $fn . "_" . $ff["var"] . "_sel";
					$fu = "select_" . $ff["var"];
					$r .= "<script language=\"javascript\">\n";
					$r .= "function $fu() { ";
					$r .= "document.$fn." . $ff["var"] . ".value = ";
					$r .= "document.$fn.$sl.options[";
					$r .= "document.$fn.$sl.selectedIndex].value;";
					$r .= " }\n</script>";
					if ($ht != "hidden")
						$r .= "&nbsp;&lt;-&nbsp;";
					$r .= "<select class=\"inp-select\" name=\"$sl\"
						onchange=\"javascript:$fu();\">";
#					$r .= "<option value=\"\">** CHOOSE **</option>";
					foreach ($ff["selectarr"]
						as $key => $val)
						{
						$r .= "<option ";
						if ($ff["value"] == $key) $r .= "selected ";
						$r .= "value=\"$key\">$val</option>";
						}
					$r .= "</select>";
					}

/*
				$r .= "&nbsp;&nbsp;<a href=\"javascript:helpwindow('" .
					"../common/help.php?s=" .
					basename($_SERVER["PHP_SELF"]) .
					"&f=" . $ff["var"] . "')\">" .
					HELP_IMG . "</a>";
*/

				$r .= "</$div>";

				if (strlen($ff["more"]))
					{
					$r .= "<$div class=\"inp-right-more\">" .
					$this->fields[$i]["more"] . "</$div>";
					}

				$r .= "</td>";

				if (!$this->fields[$i]["notr_end"]) $r .= "</tr>";
				}
			}

		return $r . "\n</table>" . ($this->dontcloseform ? "" :
			"</form>") . "\n";
		}
	}
?>
