<?

# $Id: payment.php 807 2005-12-01 19:39:06Z raf $

require_once("../inc/autoexec.inc.php");
require_once("../inc/forms.inc.php");

$clid = (isset($_GET["clid"]) ? $_GET["clid"] : 0);
$clid = (isset($_POST["clid"]) ? $_POST["clid"] : $clid);
$oid = (isset($_GET["oid"]) ? $_GET["oid"] : 0);
$oid = (isset($_POST["oid"]) ? $_POST["oid"] : $oid);
$i4 = (isset($_GET["i4"]) ? $_GET["i4"] : 0);
$i4 = (isset($_POST["i4"]) ? $_POST["i4"] : $i4);
$i7 = (isset($_GET["i7"]) ? $_GET["i7"] : 0);
$i7 = (isset($_POST["i7"]) ? $_POST["i7"] : $i7);
$newcard = true;

$cki4 = "c" . md5("clid = $clid") . crc32("clid = $clid") . "a";
$cki7 = $i7 * 3600;

if ($cki4 != $i4) die("Unauthorized");
if ((time() - 3600) > $cki7)
	{
	header("Location: ../client/login.php?timeout=yes");
	exit;
	}

if (!strlen($clid)) diehard("Client ID# missing");
if (!is_numeric($clid)) diehard("Client ID#$clid not numeric");
if (ceil($clid) != $clid) diehard("Client ID#$clid is float");
if ($clid < 1) diehard("Client ID#$clid undefined");

$cl = new Client($clid);
if (!$cl->wasOK())
	diehard("Client ID#$clid ERROR: " . $cl->lastError());

if (!strlen($oid)) diehard("Order ID# missing");
if (!is_numeric($oid)) diehard("Order ID#$oid not numeric");
if (ceil($oid) != $oid) diehard("Order ID#$oid is float");
if ($oid < 1) diehard("Order ID#$oid undefined");

$or = new Order($oid);
if (!$or->wasOK())
	diehard("Order ID#$oid ERROR: " . $or->lastError());
$sale = $or->getSale();
$salefmt = sprintf("%.02f",$sale);

$ap = new AltPayment();
$apid = $ap->getIDByOrderID($oid);

if (!$apid)
	diehard("Order ID#$oid already has card payment.");

$ap = new AltPayment($apid);
if (!$ap->wasOK())
	diehard("Order ID#$oid AltPayment ID#$apid error: " .
		$ap->lastError());

if ($ap->getReceived())
	diehard("Order ID#$oid payment received on " .
		date(DATEFMT_DATE,$ap->Received()) .
		". Cannot make it CC.");
 
$wsid = $or->getWebsiteID();
$ws = new Website($wsid);
if (!$ws->wasOK())
	diehard("Website ID#$clid ERROR: " . $ws->lastError());

$baselink = $_SERVER["PHP_SELF"] . "?oid=$oid&clid=$clid&i4=$i4&i7=$i7";
$forgetlink = "../client/olist.php?clid=$clid&i4=$i4&i7=$i7";

# prices...

$pr = new Prices();

$prices = $pr->getPrices();
if (!$prices) diehard("getPrices: " . $p->lastError());

# see if we have special prices for this website

$altpr = $pr->setWebsiteID($or->getWebsiteID());
if ($altpr) # true -- has all the prices set; so change them
	{
	$prices = $pr->getPrices();
	if ($prices === false)
		diehard("Cannot get prices for order Website: " .
			$pr->lastError());
	}

foreach ($prices as $n => $v)
	{
	$var = "PRICE_$n";
	$$var = $v[0];
	}

# script goes here

if (isset($_GET["chargefailed"]))
	{
	$f = new Form("POST",$_SERVER["PHP_SELF"]);

	$f->addInfoRow("Additional Services Request Order ID#$oid Charge");

	$f->bumpErrors();
	$f->addErrInfoRow("CHARGE TRANSACTION FAILED<br>" .
		$_GET["chargefailed"]);

	$f->addButton("  Re-enter Credit Card Data  ",
		"javascript:history.go(-1)");
	$f->addButton("  Cancel Payment Type Change  ",
		"javascript:document.location='$forgetlink'");

	normalPageStart();

        echo $f->dumpForm();

	normalPageEnd();
	exit;
	}

# da request type

if ($_SERVER["REQUEST_METHOD"] == "GET")
	{
	$frm_newccn = "";
	$frm_newcct = "VISA";
	$frm_newccy = date("Y",time());
	$frm_newccm = date("m",time());
	$frm_newcch = "";
	$frm_newccb = "";

	$get = true;
	}
else
	{
	$get = false;

	$frm_newccn = getpostvar("frm_newccn");
	$frm_newcct = getpostvar("frm_newcct");
	$frm_newccy = getpostvar("frm_newccy");
	$frm_newccm = getpostvar("frm_newccm");
	$frm_newcch = getpostvar("frm_newcch");
	$frm_newccb = getpostvar("frm_newccb");
	}

# da form

$f = new Form("POST",$_SERVER["PHP_SELF"]);

$f->addInfoRow("Changing Order ID#$oid Payment Method to Credit Card");

$f->addErrInfoRow("Errors in this form: %s");

$f->addHidden("clid",$clid);
$f->addHidden("oid",$oid);
$f->addHidden("i4",$i4);
$f->addHidden("i7",$i7);

$f->addField("frm_newcct","static","Issuer");
$f->addSelect($CARD_TYPES_ARRAY);
$f->checkField("ck_cctype");

function ck_cctype($v)
	{
	global $CARD_TYPES_ARRAY;

	if (!isset($CARD_TYPES_ARRAY[$v]))
		return "Invalid type";

	return "";
	}

$f->addField("frm_newccn","string," . CONST_CC_NUM_MINLEN . "," .
	CONST_CC_NUM_MAXLEN . ",notnull","Card Number");
$f->checkField();

$MONS = array();
for ($i = 1; $i < 13; $i++)
	$MONS[$i] = $i;

$f->addField("frm_newccm","num,1,2","Exp. Month");
$f->addSelect($MONS);
$f->checkField();

$YRS = array();
for ($i = date("Y",time()); $i < (date("Y",time()) + 11); $i++)
	$YRS[$i] = $i;

$f->addField("frm_newccy","num,4,4","Exp. Year");
$f->addSelect($YRS);
$f->checkField();

$f->addField("frm_newcch","string," . CONST_CC_HOLDER_MINLEN . "," .
	CONST_CC_HOLDER_MAXLEN . ",notnull","Card Holder");
$f->checkField();

$f->addField("frm_newccb","string," . CONST_CC_BANK_MINLEN . "," .
	CONST_CC_BANK_MAXLEN . ",nullok","Bank");
$f->checkField();

$f->addInfoRow("Your card is about to be charged \$$salefmt.");

$f->addSubmit("  CHARGE  ");

$btxt = "  Forget it  ";
$bclick = "javascript:document.location = '$forgetlink';";

$f->addButton($btxt,$bclick);

# if there was an error while form post'ed or it's get display it

if (($f->numErr()) || $get)
        {
	normalPageStart();

        echo $f->dumpForm();

	normalPageEnd();
	exit;
        }

$ci = new Card();

$err = true;

while (1)
	{
	$ok = $ci->setNumber($frm_newccn);
	if (!$ok) break;
	$ok = $ci->setType($frm_newcct);
	if (!$ok) break;
	$ok = $ci->setMonth($frm_newccm);
	if (!$ok) break;
	$ok = $ci->setYear($frm_newccy);
	if (!$ok) break;
	$ok = $ci->setHolder($frm_newcch);
	if (!$ok) break;
	$ok = $ci->setBank($frm_newccb);
	if (!$ok) break;
	$ok = $ci->Update();
	if (!$ok) break;

	$err = false;
	break;
	}

if ($err) diehard("New Card ERROR: " . $ci->lastError());

# CCAuth($oid,$cardid,$ccn,$ccexpm,$ccexpy,
#        $first,$last,$ad1,$ad2,$city,$state,$zip,
#        $phone,$country,$mail,$desc,$sale)

list($code,$explain) = CCAuth(
		$or->getID(),
		$ci->getID(),
		$ci->getNumber(),
		$ci->getMonth(),
		$ci->getYear(),
		$cl->getFirst(),
		$cl->getLast(),
		$cl->getAddr1(),
		$cl->getAddr2(),
		$cl->getCity(),
		$cl->getState(),
		$cl->getZip(),
		$cl->getTlf(),
		$cl->getCountry(),
		$cl->getMail(),
		$or->descOrderTypeCCDesc(),
		$sale);

#echo "charge=$code $explain";

if ($code != "AUTH")
	{
	$co = new Comment();
	$ok = $co->setOrderID($oid);
	$ok = $co->setPoster("client");
	$ok = $co->setComment("Client tried to change payment type to CC but new card charge for \$$salefmt failed: $explain");
	$ok = $co->Update();

	$ok = $ci->Delete();
	if (!$ok) diehard("New Card ID#$caid delete error [charge failed]: " .
		$ci->lastError());

	header("Location: $baselink&chargefailed=" .
		urlencode($explain));
	exit;
	}

# actually change the payment type

$err = true;

while (1)
	{
	$ok = $or->setCardID($ci->getID());
	if (!$ok) break;
	$ok = $or->Update();
	if (!$ok) break;

	$err = false;
	break;
	}

if ($err)
	{
	$ci->Delete();
	diehard("Order ID#$oid New Card ID#$caid error: " .
		$or->lastError() .
		". PLEASE CONTACT MANAGER TO CANCEL YOUR YOUR LAST TRANSACTION FOR $" .
		$salefmt);
	}

$co = new Comment();
$ok = $co->setOrderID($oid);
$ok = $co->setPoster(whoson());
$ok = $co->setComment("New Card charge $" . sprintf("%.02f",$sale) .
	" successfull");
$ok = $co->Update();

$ap->Delete(); # delete altpayment

$co = new Comment();
$ok = $co->setOrderID($oid);
$ok = $co->setPoster(whoson());
$ok = $co->setComment("Client changed payment type to Card");
$ok = $co->Update();

header("Location: ../client/olist.php?clid=$clid&i7=$i7&i4=$i4&msg=" .
	urlencode("Order ID#$oid payment type changed to Credit Card."));

?>

