$(document).ready(function() {
      $('button.dropbox').click(dropboxChooser);
}); 


//175067029670-9lcu95gmubres2ekq8re9b7alnjn1bp4.apps.googleusercontent.com
var clientId = "792290645700-oojp7eeqpt3pai374b3kk9pjf7c07cc7.apps.googleusercontent.com";
var appId = "792290645700";

var scope = ['https://www.googleapis.com/auth/drive.readonly'];

var pickerApiLoaded = false;
var oauthToken;


// Use the Google API Loader script to load the google.picker script.
function loadPicker() {
	gapi.load('auth', {'callback': onAuthApiLoad});
	gapi.load('picker', {'callback': onPickerApiLoad});
}

function onAuthApiLoad() {
	window.gapi.auth.authorize(
	{
		'client_id': clientId,
		'scope': scope,
		'immediate': false
	},
	handleAuthResult);
}

function onPickerApiLoad() {
	pickerApiLoaded = true;
	createPicker();
}

function handleAuthResult(authResult) {
	if (authResult && !authResult.error) {
		oauthToken = authResult.access_token;
		createPicker();
	}
}

function handleClientLoad() {
	gapi.load('auth', function () { console.log('API Client Loaded...')});
}

// Create and render a Picker object for searching images.
function createPicker() {
	if (pickerApiLoaded && oauthToken) {
		var view = new google.picker.DocsView();
		view.setIncludeFolders(true);
		view.setMode(google.picker.DocsViewMode.LIST);

		var picker = new google.picker.PickerBuilder()
		.enableFeature(google.picker.Feature.NAV_HIDDEN)
		.setAppId(appId)
		.setOAuthToken(oauthToken)
		.addView(view)
		.setOrigin(window.location.protocol + '//' + window.location.host)
		.setCallback(pickerCallback)
		.build();
		picker.setVisible(true);
	}
}

// A simple callback implementation.
function pickerCallback(data) {
	if (data.action == google.picker.Action.PICKED) {
		var fileId = data.docs[0].id;
		var fileName = data.docs[0].name;
		var mimeTYpe = data.docs[0].mimeType;
		
		$('#drive_fileId').val(fileId);
		$('#drive_fileName').val(fileName);
		$('#drive_oauthToken').val(oauthToken);
		$('#drive_mimeTYpe').val(mimeTYpe);	
		$('#drop_type').val('drive');	
		$('.drive_msg').html('Document uploaded from Drive');
		$('.drive_msg').show();
	}
}
function dropboxChooser() {
	Dropbox.choose({
	    // Required. Called when a user selects an item in the Chooser.
	    success: function(files) {
		  $('#drop_fileUrl').val(files[0].link);
		  $('#drop_type').val('dropbox');
		  $('.drive_msg').html('Document uploaded from Dropbox');
		  $('.drive_msg').show();

	    },
	    linkType: "direct", // or "preview"
	    multiselect: false // or true
	});
}
