<?

# $Id: taf.inc.php 809 2005-12-04 09:33:29Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class TAF extends SimpleClassCommon
	{
	var $orderid = 0;
	var $clid = "";
	var $mail = "";
	var $name = "";

	var $tstart = 0;
	var $tstop = 0;
	var $tsql = "";

	function TAF($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"taf",
			"tafid","created");
		if (!$ok)
			{
			$this->_error("TAF ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);

		if (!$r)
			{
			$this->_error("TAF Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->orderid = $r["orderid"];
		$this->clid = $r["clid"];
		$this->mail = $r["mail"];
		$this->name = $r["name"];

		return true;
		}

	function Update()
		{
		global $db;

		if ($this->getMail() == "")
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();
		$unixtime = array();

		$ok = $this->setOrderID($this->getOrderID());
		if (!$ok) return false;
		$fields["orderid"] = $this->getOrderID();

		$ok = $this->setClid($this->getClid());
		if (!$ok) return false;
		$fields["clid"] = $this->getClid();

		$ok = $this->setMail($this->getMail());
		if (!$ok) return false;
		$fields["mail"] = $this->getMail();
		
		$ok = $this->setName($this->getName());
		if (!$ok) return false;
		$fields["name"] = $this->getName();

		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("TAF " . $this->lastError());
			return false;
			}

		return true;
		}

	function setMail($m)
		{
		$m = strtolower($m);
		$ok = $this->_checkMail($m);
		if (!$ok)
			{
			$this->_error("TAF Mail " . $this->lastError());
			return false;
			}
		$this->mail = $m;
		return true;
		}

	function getMail()
		{
		return $this->mail;
		}

	function setOrderID($id)
		{
		if ($id)
			{
			$ok = $this->_checkID($id,ZERO_OK);
			if (!$ok)
				{
				$this->_error("TAF OrderID " .
					$this->lastError());
				return false;
				}
			}
		$this->orderid = $id;
		return true;
		}

	function getOrderID()
		{
		return $this->orderid;
		}

	function setClid($id)
		{
		$ok = $this->_checkID($id);
		if (!$ok)
			{
			$this->_error("TAF Clid " . $this->lastError());
			return false;
			}
		$this->clid = $id;
		return true;
		}

	function getClid()
		{
		return $this->clid;
		}

	function setName($id)
		{
		/*$ok = $this->_checkID($id);
		if (!$ok)
			{
			$this->_error("TAF Clid " . $this->lastError());
			return false;
			}*/
		$this->name = $id;
		return true;
		}

	function getName()
		{
		return $this->name;
		}

	function listDistinctTAFs()
		{
		return $this->listSQL($this->getPeriodSQL() . 
			" GROUP BY mail","","created DESC");
		}

	function countTAFs()
		{
		global $db;
		$q = "SELECT COUNT(*) FROM " . $this->getTable() . " WHERE " .
			$this->getPeriodSQL();
		$got = $db->query($q);
		return $got->f(0);
		}

	function listTAFsByEmail($m="")
		{
		if (strlen($m) &&!$this->_checkMail($m))
			diehard("listTAFsByEmail: invalid e-mail '$m': " .
			$this->lastError());
		else
			$m = $this->getMail();
			
		return $this->listSQL("mail = '$m' AND " .
			$this->getPeriodSQL());
		}

	function listTAFOrders()
		{
		$or = new Order();
		$cl = new Client();

		$clid = $cl->getIDByMail($this->getMail());
		if (!$clid) return array();

		$oids = $or->getIDByClientID($clid);

		$r = array();

		# weed out revisions and unpaid
		foreach ($oids as $oid)
			{
			$or = new Order($oid);
			if (!$or->wasOK()) continue;
			if ($or->isRevision()) continue;
			if ($or->hasAltPayment())
				{
				$ap = new AltPayment();
				$apid = $ap->getIDByOrderID($oid);
				if (!$apid) continue;
				$ap = new AltPayment($apid);
				if (!$ap->wasOK()) continue;
				if (!$ap->getReceived()) continue;
				}
			$r[] = $oid;
			}
		
		return $r;
		}				

	function countTAFsPeriod($uxstart,$uxend)
		{
		global $db;

		$q = "SELECT COUNT(*) FROM " . $this->table . "
			WHERE " . $this->getPeriodSQL();
#		echo "q=$q<br>";
		$got = $db->query($q);

		return $got->f(0);
		}
	
	function countTAFsorder($email)
		{
		global $db;

		$q = "SELECT COUNT(orderid) FROM orderdata as o LEFT JOIN client as c ON o.clid = c.clid WHERE c.mail='".$email."'";
#		echo "q=$q<br>";
		$got = $db->query($q);

		return $got->f(0);
		}

	function setPeriod($tstart,$tstop)
		{
		$this->tstart = $tstart;
		$this->tstop = $tstop;
		if ($this->tstart == 0 && $this->tstop == 0)
			$this->tsql = "1";
		else
			$this->tsql = ($this->tstart ?
				"created >= FROM_UNIXTIME($tstart) " .
				($this->tstop ? "AND " : "") : "") .
				($this->tstop ? "created < FROM_UNIXTIME($tstop)"
					: "");
#		echo "sql=$this->tsql<br>";
		}

	function getPeriodSQL()
		{
		return $this->tsql;
		}

	}

?>
