<?

# $Id: simpleclasscommon.inc.php 776 2005-11-27 12:51:43Z raf $

require_once("../inc/classcommon.inc.php");

class SimpleClassCommon extends ClassCommon
	{
	var $id = 0;
	var $table = "";
	var $idcol = "";
	var $createdf = "";
	var $created = 0;

	function SimpleClassCommon($id,$table,$idcol,$createdf="")
		{
		$this->table = $table;
		$this->idcol = $idcol;
		$this->createdf = $createdf;

		if ($id)
			{
			$ok = $this->fetchData($id);
			if (!$ok) return false;
			}

		$this->id = $id;
		return true;
		}

	function _internalFetchData($id,$moreselect="")
		{
		$ok = $this->_checkID($id);
		if (!$ok) return false;

		$ok = $this->_internalFetchDataGeneric(array($this->idcol =>
			$id),$moreselect);
		if (!$ok) return false;

		$this->id = $id;
		return $ok;
		}

	function _internalFetchDataGeneric($wherearr,$moreselect="")
		{
		global $db;

		if (!is_array($wherearr))
			{
			$this->_error("Is not an array");
			return false;
			}
		
		if (!count($wherearr))
			{
			$this->_error("Array empty");
			return false;
			}

		$q = "SELECT *";

		if (strlen($moreselect)) $q .= ",$moreselect";

		if (strlen($this->createdf))
			$q .= ",UNIX_TIMESTAMP(" . $this->createdf .
				") AS CreatedUX";

		$q .= " FROM " . $this->table . " WHERE ";
		
		foreach ($wherearr as $k => $v)
			{
			$q .= " " . addslashes($k) . " = '" .
				htmlentities(addslashes($v)) . "' AND";
			}

		$q = substr($q,0,-3);
		//echo "q=$q<br>";
		$g = $db->query($q);
    
		if ($g->numRows() == 0)
			{
			$this->_error("Cannot find this " . $this->idcol);
			return 0; // nie false!
			}
		if ($g->numRows() > 1)
			{
			$this->_error("Duplicate " . $this->idcol .
				" '" . $this->id . "'");
				//echo "q=$q<br>";
			return false;
			}

		$r = $g->fetchArray();

		if (strlen($this->createdf))
			{
			$this->created = $r["CreatedUX"];
			}

		return $r;
		}

	function _internalUpdate($fields,$unixtimefields=array())
		{
		global $db;

		$q = "UPDATE ";
		if (!$this->getID()) # nowy
			$q = "INSERT INTO ";

		$q .= $this->table . " SET ";

		foreach ($fields as $f => $v)
			{
			$q .= " $f = '" . addslashes($v) . "', ";
			}

		foreach ($unixtimefields as $f => $v)
			{
			$q .= " $f = FROM_UNIXTIME($v), ";
			}

		$q = substr($q,0,strlen($q)-2);
		
		if ($this->getID() != 0)
			$q .= " WHERE " . $this->idcol .
				" = '" . $this->getID() . "'";
		else
			{
			if (strlen($this->createdf))
				$q .= "," . $this->createdf .
					" = now()";
				$this->setCreated();
			}

		$db->query($q);
  
#		echo "q=$q<br>";

		$new = 0;

		if ($this->getID() == 0)
			{
			$new = $db->lastInsertID();
			$this->id = $new;
			}

		return 1+$new;
		}

	function getID()
		{
		return $this->id;
		}

	function getIDcol()
		{
		return $this->idcol;
		}

	function getIDtablecol()
		{
		return $this->getTable() . "." . $this->getIDcol();
		}

	function fetchList($warunek="")
		{
		global $db;
		
		if (!$warunek) $warunek = "ORDER BY id";

		$r = array();
		$q = "SELECT " . $this->idcol .
			" FROM " . $this->table . " $warunek";
#		echo "q=$q<br>";
		$g = $db->query($q);
		
		while ($id = $g->f(0))
			{
			$r[] = $id;
			}
		
		return $r;
		}		

	function Delete()
		{
		global $db;

		if ($this->id == 0) return true;

		$ok = $this->_checkID($this->getID());
		if (!$ok)
			{
			$this->_error("Delete: " . $this->lastError());
			return false;
			}

		$q = "DELETE FROM " . $this->table . " WHERE " .
			$this->idcol . " = '" . $this->getID() . "'";
#		echo "q=$q<br>";
		$db->query($q);
		$this->id = 0;
		return true;
		}

	function getTable()
		{
		return $this->table;
		}

	function getCreated()
		{
		return $this->created;
		}

	function setCreated()
		{
		$this->created = time();
		return true;
		}

	function askSQL($q)
		{
		global $db;

		if (!$this->getID()) return false;

		$got = $db->query("SELECT " . $q . " FROM " .
			$this->table . " WHERE " . $this->idcol . " = " .
			$this->getID());
		if (!$got->numRows()) return false;
		return $got->fetchArray();
		}

	function listSQL($q,$more="",$order="")
		{
		global $db;

		$tabid = $this->getIDtablecol();

		$query = "SELECT $tabid FROM " . $this->getTable() .
			" WHERE $q ORDER BY " .
			(strlen($order) ? $order : $tabid) .
			" $more";

#		echo "listSQL=$query<br>";

		$got = $db->query($query);

		$a = array();

		while ($r = $got->fetchArray())
			{
			$a[] = $r[$this->getIDcol()];
			}

		return $a;
		}

	function listEntireTableSQL($fields = "*", $q = "1", $more="", $order="")
		{
		//Return the entire table with the given fields, ordered by the index, if no index is given.
		global $db;

		$tabid = $this->getIDtablecol();

		$query = "SELECT $fields FROM " . $this->getTable() .
			" WHERE $q ORDER BY " .
			(strlen($order) ? $order : $tabid) .
			" $more";

		//echo "listSQL=$query<br>";

		$got = $db->query($query);

		$a = array();

		while ($r = $got->fetchAssoc())
			{
			$a[] = $r;
			}

		return $a;
		}


	function getIDByOrderID($id)
		{
		$r = $this->_internalFetchDataGeneric(
			array("orderid" => $id));
		if ($r) return $r[$this->idcol];
		return 0;
		}

	function listAll()
		{
		return $this->listSQL("1");
		}

	function countAll()
		{
		global $db;

		$q = "SELECT COUNT(*) FROM " . $this->getTable();
		
		$got = $db->query($q);
		return $got->f(0);
		}
	
	}

?>
