<?

# $Id: resinfo.inc.php 749 2005-11-22 19:07:16Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class Resinfo extends SimpleClassCommon
	{
	var $orderid = 0;
	var $ksaq = "";
	var $fedcommcert = "";
	var $objective = "";
	var $education = "";
	var $experience = "";
	var $activities = "";
	var $misc = "";
	var $cvsummary = "";
	var $cvachievements = "";
	var $cvpublications = "";
	var $restype = "c";
	var $cltype = 0;

	function Resinfo($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"resinfo","resinfoid","created");
		if (!$ok)
			{
			$this->_error("Resume Info ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);
		if (!$r)
			{
			$this->_error("Resume Info Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->orderid = $r["orderid"];
		$this->ksaq = $r["ksaq"];
		$this->fedcommcert = $r["fedcommcert"];
		$this->objective = $r["objective"];
		$this->education = $r["education"];
		$this->experience = $r["experience"];
		$this->activities = $r["activities"];
		$this->misc = $r["misc"];
		$this->cvsummary = $r["cvsummary"];
		$this->cvachievements = $r["cvachievements"];
		$this->cvpublications = $r["cvpublications"];
		$this->restype = $r["restype"];
		$this->cltype = $r["cltype"];

		return true;
		}

	function Update()
		{
		global $db;

		if ($this->getOrderID() == -1)
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setOrderID($this->getOrderID());
		if (!$ok) return false;
		$fields["orderid"] = $this->getOrderID();

		$ok = $this->setKSAQ($this->getKSAQ());
		if (!$ok) return false;
		$fields["ksaq"] = $this->getKSAQ();
		
		$ok = $this->setFedCommCert($this->getFedCommCert());
		if (!$ok) return false;
		$fields["fedcommcert"] = $this->getFedCommCert();
		
		$ok = $this->setObjective($this->getObjective());
		if (!$ok) return false;
		$fields["objective"] = $this->getObjective();

		$ok = $this->setEducation($this->getEducation());
		if (!$ok) return false;
		$fields["education"] = $this->getEducation();

		$ok = $this->setExperience($this->getExperience());
		if (!$ok) return false;
		$fields["experience"] = $this->getExperience();

		$ok = $this->setActivities($this->getActivities());
		if (!$ok) return false;
		$fields["activities"] = $this->getActivities();

		$ok = $this->setMisc($this->getMisc());
		if (!$ok) return false;
		$fields["misc"] = $this->getMisc();

		$ok = $this->setCVSummary($this->getCVSummary());
		if (!$ok) return false;
		$fields["cvsummary"] = $this->getCVSummary();

		$ok = $this->setCVAchievements($this->getCVAchievements());
		if (!$ok) return false;
		$fields["cvachievements"] = $this->getCVAchievements();

		$ok = $this->setCVPublications($this->getCVPublications());
		if (!$ok) return false;
		$fields["cvpublications"] = $this->getCVPublications();

		$ok = $this->setRestype($this->getRestype());
		if (!$ok) return false;
		$fields["restype"] = $this->getRestype();

		$ok = $this->setCLtype($this->getCLtype());
		if (!$ok) return false;
		$fields["cltype"] = $this->getCLtype();

		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("Resume Info " . $this->lastError());
			return false;
			}

		return true;
		}

	function setOrderID($id)
		{
		$ok = $this->_checkId($id);
		if (!$ok)
			{
			$this->_error("Resume Info OrderID " . $this->lastError());
			return false;
			}
		$this->orderid = $id;
		return true;
		}

	function getOrderID()
		{
		return $this->orderid;
		}

	function setKSAQ($txt)
		{
		$txt = addslashes($txt);
		$ok = $this->_checkStr($txt,CONST_RESTXT_MINLEN,
			CONST_RESTXT_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Resume Info KSA Questions Text " . $this->lastError());
			return false;
			}
		$this->ksaq = $txt;
		return true;
		}

	function getKSAQ()
		{
		return stripslashes($this->ksaq);
		}

	function setObjective($txt)
		{
		$txt = addslashes($txt);
		$ok = $this->_checkStr($txt,CONST_RESTXT_MINLEN,
			CONST_RESTXT_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Resume Info Objective Text " . $this->lastError());
			return false;
			}
		$this->objective = $txt;
		return true;
		}

	function getObjective()
		{
		return stripslashes($this->objective);
		}

	function setEducation($txt)
		{
		$txt = addslashes($txt);
		$ok = $this->_checkStr($txt,CONST_RESTXT_MINLEN,
			CONST_RESTXT_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Resume Info Education Text " . $this->lastError());
			return false;
			}
		$this->education = $txt;
		return true;
		}

	function getEducation()
		{
		return stripslashes($this->education);
		}

	function setExperience($txt)
		{
		$txt = addslashes($txt);
		$ok = $this->_checkStr($txt,CONST_RESTXT_MINLEN,
			CONST_RESTXT_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Resume Info Experience Text " . $this->lastError());
			return false;
			}
		$this->experience = $txt;
		return true;
		}

	function getExperience()
		{
		return stripslashes($this->experience);
		}

	function setFedCommCert($txt)
		{
		$txt = addslashes($txt);
		$ok = $this->_checkStr($txt,CONST_RESTXT_MINLEN,
			CONST_RESTXT_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Resume Info Commendations/Certificates Text " . $this->lastError());
			return false;
			}
		$this->fedcommcert = $txt;
		return true;
		}

	function getFedCommCert()
		{
		return stripslashes($this->fedcommcert);
		}


	function setActivities($txt)
		{
		$txt = addslashes($txt);
		$ok = $this->_checkStr($txt,CONST_RESTXT_MINLEN,
			CONST_RESTXT_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Resume Info Activities Text " . $this->lastError());
			return false;
			}
		$this->activities = $txt;
		return true;
		}

	function getActivities()
		{
		return stripslashes($this->activities);
		}

	function setMisc($txt)
		{
		$txt = addslashes($txt);
		$ok = $this->_checkStr($txt,CONST_RESTXT_MINLEN,
			CONST_RESTXT_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Resume Info Misc Text " . $this->lastError());
			return false;
			}
		$this->misc = $txt;
		return true;
		}

	function getMisc()
		{
		return stripslashes($this->misc);
		}

	function setCVSummary($txt)
		{
		$txt = addslashes($txt);
		$ok = $this->_checkStr($txt,CONST_RESTXT_MINLEN,
			CONST_RESTXT_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Resume Info Summary Text " . $this->lastError());
			return false;
			}
		$this->cvsummary = $txt;
		return true;
		}

	function getCVSummary()
		{
		return stripslashes($this->cvsummary);
		}

	function setCVAchievements($txt)
		{
		$txt = addslashes($txt);
		$ok = $this->_checkStr($txt,CONST_RESTXT_MINLEN,
			CONST_RESTXT_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Resume Info Achievements Text " . $this->lastError());
			return false;
			}
		$this->cvachievements = $txt;
		return true;
		}

	function getCVAchievements()
		{
		return stripslashes($this->cvachievements);
		}

	function setCVPublications($txt)
		{
		$txt = addslashes($txt);
		$ok = $this->_checkStr($txt,CONST_RESTXT_MINLEN,
			CONST_RESTXT_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Resume Info Publications Text " . $this->lastError());
			return false;
			}
		$this->cvpublications = $txt;
		return true;
		}

	function getCVPublications()
		{
		return stripslashes($this->cvpublications);
		}

	function setRestype($t)
		{
		switch ($t)
			{
			case "f":
			case "c":
			case "n":
				break;
			default:
				$this->_error("Resume type unknown ('$t')");
				return false;
			}
		$this->restype = $t;
		return true;
		}

	function getRestype()
		{
		return $this->restype;
		}

	function setCLtype($t)
		{
		global $CLONLY_TYPE;

		if (!array_key_exists($t,$CLONLY_TYPE))
			{
			$this->_error("CLonly type unknown ('$t')");
			return false;
			}

		$this->cltype = $t;
		return true;
		}

	function getCLtype()
		{
		return $this->cltype;
		}

	function descCLtype()
		{
		global $CLONLY_TYPE;
		
		$clt = $this->getCLtype();
		
		if (!isset($CLONLY_TYPE[$clt])) return "(UNKNOWN CL TYPE)";
		
		return $CLONLY_TYPE[$clt][0];
		}

	function descCLtypeLong()
		{
		global $CLONLY_TYPE;
		
		$clt = $this->getCLtype();
		
		if (!isset($CLONLY_TYPE[$clt])) return "(UNKNOWN CL TYPE)";
		
		return $CLONLY_TYPE[$clt][1];
		}
	}
?>
