<?

# $Id: resfile.inc.php 130 2004-01-25 22:00:47Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class ResFile extends SimpleClassCommon
	{
	var $orderid = 0;
	var $filename = "";
	var $diskfilename = "";
	var $deleted = 0;
	var $uploaded = 0;

	function ResFile($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"resfile","fileid");
		if (!$ok)
			{
			$this->_error("ResusmeFile ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);
		if (!$r)
			{
			$this->_error("ResusmeFile Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->orderid = $r["orderid"];
		$this->filename = $r["filename"];
		$this->diskfilename = $r["diskfilename"];
		$this->deleted = $r["deleted"];
		$this->uploaded = $r["uploaded"];

		return true;
		}

	function getIDByOrderID($oid)
		{
		$r = $this->_internalFetchDataGeneric(
			array("orderid" => $oid));
		if ($r) return $r[$this->idcol];
		return 0;
		}

	function Update()
		{
		global $db;

		if ($this->getOrderID() == 0)
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setOrderID($this->getOrderID());
		if (!$ok) return false;
		$fields["orderid"] = $this->getOrderID();

		$ok = $this->setFilename($this->getFilename());
		if (!$ok) return false;
		$fields["filename"] = $this->getFilename();

		$ok = $this->setDiskfilename($this->getDiskfilename());
		if (!$ok) return false;
		$fields["diskfilename"] = $this->getDiskfilename();

		$ok = $this->setDeleted($this->getDeleted());
		if (!$ok) return false;
		$fields["deleted"] = $this->getDeleted();

		if (!$this->getID())
			{
			$this->setUploaded();
			$fields["uploaded"] = $this->getUploaded();
			}

		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("ResusmeFile " . $this->lastError());
			return false;
			}

		return true;
		}

	function setOrderID($oid)
		{
		$ok = $this->_checkID($oid);
		if (!$ok)
			{
			$this->_error("ResusmeFile OrderID " . $this->lastError());
			return false;
			}
		$this->orderid = $oid;
		return true;
		}

	function getOrderID()
		{
		return $this->orderid;
		}

	function setFilename($f)
		{
		
		
		$ok = $this->_checkStr($f,CONST_FILE_NAME_MINLEN,
			CONST_FILE_NAME_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("ResusmeFile Filename " . $this->lastError());
			return false;
			}
		$this->filename = $f;
		return true;
		}

	function getFilename()
		{
		return $this->filename;
		}

	function setDiskfilename($f)
		{
		$ok = $this->_checkStr($f,CONST_FILE_NAME_MINLEN,
			CONST_FILE_NAME_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("ResusmeFile Disk Filename " . $this->lastError());
			return false;
			}
		$this->diskfilename = $f;
		return true;
		}

	function getDiskfilename()
		{
		return $this->diskfilename;
		}

	function setDeleted($d)
		{
		$ok = $this->_checkBool($d);
		if (!$ok)
			{
			$this->_error("ResusmeFile Deleted " . $this->lastError());
			return false;
			}
		$this->deleted = $d;
		return true;
		}

	function getDeleted()
		{
		return $this->deleted;
		}

	function setUploaded()
		{
		$this->uploaded = time();
		return true;
		}

	function getUploaded()
		{
		return $this->uploaded;
		}
	}

?>
