<?

# $Id: explvl.inc.php 160 2007-02-21 dj $

require_once("../inc/simpleclasscommon.inc.php");

class ExpLvl extends SimpleClassCommon
	{
	var $name = "";
	var $price = 0;

	function ExpLvl($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"explvl","explvlid");
		if (!$ok)
			{
			$this->_error("ExpLvl ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);
		if (!$r)
			{
			$this->_error("ExpLvl Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->name = $r["name"];
		$this->price = $r["price"];

		return true;
		}

	function Update()
		{
		global $db;

		if ($this->getName() == "")
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setName($this->getName());
		if (!$ok) return false;
		$fields["name"] = $this->getName();

		$ok = $this->setPrice($this->getPrice());
		if (!$ok) return false;
		$fields["price"] = $this->getPrice();

		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("ExpLvl " . $this->lastError());
			return false;
			}

		return true;
		}

	function setName($n)
		{
		$ok = $this->_checkStr($n,CONST_PKG_NAME_MINLEN,
			CONST_PKG_NAME_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("ExpLvl Name " . $this->lastError());
			return false;
			}
		$this->name = $n;
		return true;
		}

	function getName()
		{
		return $this->name;
		}

	function setPrice($p)
		{
		$ok = $this->_checkFloat($f,0.01,9999.99);
		if (!$ok)
			{
			$this->_error("ExpLvl Price " . $this->lastError());
			return false;
			}
		$this->price = $p;
		return true;
		}

	function getPrice()
		{
		return $this->price;
		}

	function listAll()
		{
		global $db;

		$q = "SELECT * FROM " . $this->table .
			" ORDER BY " . $this->idcol;

		$got = $db->query($q);

		$ids = array(0 => "Standard Resume Package");

		while ($r = $got->fetchArray())
			{
			$ids[$r[$this->idcol]] = $r["name"]; # . " $" . $r["price"];
			}

		return $ids;
		}
	}

?>
