<?

# $Id: coupon.inc.php 85 2004-01-18 21:26:36Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class Coupon extends SimpleClassCommon
	{
	var $phrase = "";
	var $discount = 0;
	var $pendingcharge = 0;

	function Coupon($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"coupon","couponid");
		if (!$ok)
			{
			$this->_error("Coupon ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);
		if (!$r)
			{
			$this->_error("Coupon Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->phrase = $r["phrase"];
		$this->discount = $r["discount"];
		$this->pendingcharge = $r["pendingcharge"];

		return true;
		}

	function getIDByPhrase($p)
		{
		$r = $this->_internalFetchDataGeneric(
			array("phrase" => $p));
		if ($r) return $r[$this->idcol];
		return 0;
		}

	function Update()
		{
		global $db;

		if ($this->getPhrase() == "")
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setPhrase($this->getPhrase());
		if (!$ok) return false;
		$fields["phrase"] = $this->getPhrase();

		$ok = $this->setDiscount($this->getDiscount());
		if (!$ok) return false;
		$fields["discount"] = $this->getDiscount();
		
		$ok = $this->setPendingcharge($this->getPendingcharge());
		if (!$ok) return false;
		$fields["pendingcharge"] = $this->getPendingcharge();

		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("Coupon " . $this->lastError());
			return false;
			}

		return true;
		}

	function setPhrase($p)
		{
		$ok = $this->_checkStr($p,CONST_COUPON_MINLEN,
			CONST_COUPON_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("Coupon Phrase " . $this->lastError());
			return false;
			}
		$this->phrase = $p;
		return true;
		}

	function getPhrase()
		{
		return $this->phrase;
		}

	function setDiscount($d)
		{
		$ok = $this->_checkFloat($d,CONST_COUPON_MINDISC,
			CONST_COUPON_MAXDISC);
		if (!$ok)
			{
			$this->_error("Coupon Discount " . $this->lastError());
			return false;
			}
		$this->discount = $d;
		return true;
		}

	function setPendingcharge($ex)
		{
		$ok = $this->_checkBool($ex);
		/*if (!$ok)
			{
			$this->_error("Order ExtendedDl " . $this->lastError());
			return false;
			}*/
			
		$this->pendingcharge = $ex;
		return true;
		
		}

	function getPendingcharge()
		{
		return $this->pendingcharge;
		}
		
	function getDiscount()
		{
		return $this->discount;
		}

	function getDiscountText($d)
		{
		if ($d == 0) return "invalid coupon code";
		if (substr($d,-2) == "00") $d = substr($d,0,-3);
		if ($d < 0)
			return "$" . -$d . " discount";
		return $d . "% discount";
		}

	function calcDiscount($price,$d)
		{
		if ($d < 0) return ($price+$d); // d is negative!
		$sub = ($price / 100) * $d;
		$price = $price-$sub;
		if ($price < 0) $price = 1;
		return $price;
		}
	}

?>
