<?

# $Id: comment.inc.php 508 2004-04-14 20:13:19Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class Comment extends SimpleClassCommon
	{
	var $writerid = 0;
	var $orderid = 0;
	var $comment = "";
	var $poster = "";

	function Comment($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"comment","commentid","datecomment");
		if (!$ok)
			{
			$this->_error("Comment ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);
		if (!$r)
			{
			$this->_error("Comment Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->writerid = $r["writerid"];
		$this->orderid = $r["orderid"];
		$this->comment = $r["comment"];
		$this->poster = $r["poster"];

		return true;
		}

	function listByWriterID($id)
		{
		return $this->listSQL("writerid = '$id'");
		}

	function listByOrderID($id)
		{
		return $this->listSQL("orderid = '$id'");
		}

	function listByOrderWriterID($oid,$wid)
		{
		return $this->listSQL("orderid = '$oid'
			AND writerid = '$wid'");
		}

	function Update()
		{
		global $db;

		if ($this->getOrderID() == 0)
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setWriterID($this->getWriterID());
		if (!$ok) return false;
		$fields["writerid"] = $this->getWriterID();

		$ok = $this->setOrderID($this->getOrderID());
		if (!$ok) return false;
		$fields["orderid"] = $this->getOrderID();

		$ok = $this->setComment($this->getComment());
		if (!$ok) return false;
		$fields["comment"] = $this->getComment();

		$ok = $this->setPoster($this->getPoster());
		if (!$ok) return false;
		$fields["poster"] = $this->getPoster();
    //print_R($fields);exit;
		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("Comment " . $this->lastError());
			return false;
			}

		return true;
		}

	function setOrderID($id)
		{
		if ($id)
			{
			$ok = $this->_checkID($id);
			if (!$ok)
				{
				$this->_error("Comment OrderID " . $this->lastError());
				return false;
				}
			}
		$this->orderid = $id;
		return true;
		}

	function getOrderID()
		{
		return $this->orderid;
		}

	function setWriterID($id)
		{
		if ($id)
			{
			$ok = $this->_checkID($id);
			if (!$ok)
				{
				$this->_error("Comment WriterID " . $this->lastError());
				return false;
				}
			}
		$this->writerid = $id;
		return true;
		}

	function getWriterID()
		{
		return $this->writerid;
		}

	function setComment($c)
		{
		$c = addslashes($c);
		$ok = $this->_checkStr($c,0,CONST_COMMENT_MAXLEN,NULL_OK);
		
		if (!$ok)
			{
			$this->_error("Comment Text " . $this->lastError());
			return false;
			}			
		$this->comment = $c;
		return true;
		}

	function getComment()
		{
		return stripslashes($this->comment);
		}

	function setPoster($p)
		{
		$ok = $this->_checkStr($p,0,255,NULL_OK);
		if (!$ok)
			{
			$this->_error("Poster " . $this->lastError());
			return false;
			}
		$this->poster = $p;
		return true;
		}

	function getPoster()
		{
		return $this->poster;
		}

	}

?>