<?

# $Id: client.inc.php 778 2005-11-27 12:55:46Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class Client extends SimpleClassCommon
	{
	var $mail = "";
	var $first = "";
	var $last = "";
	var $addr1 = "";
	var $addr2 = "";
	var $city = "";
	var $state = "";
	var $zip = "";
	var $tlf = "";
	var $tlf2 = "";
	var $country = "USA";
	var $changed = 0;
	var $status = 0;

	function Client($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"client","clid","created");
		if (!$ok)
			{
			$this->_error("Client ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id,"UNIX_TIMESTAMP(changed)
			as changedUX");
		if (!$r)
			{
			$this->_error("Client Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->mail = $r["mail"];
		$this->first = $r["first"];
		$this->last = $r["last"];
		$this->addr1 = $r["addr1"];
		$this->addr2 = $r["addr2"];
		$this->city = $r["city"];
		$this->state = $r["state"];
		$this->zip = $r["zip"];
		$this->tlf = $r["tlf"];
		$this->tlf2 = $r["tlf2"];
		$this->country = $r["country"];
		$this->changed = $r["changedUX"];
		$this->status = $r["status"];

		return true;
		}

	function getIDByMail($mail)
		{
		$clids = $this->listSQL("mail = '$mail'");

		if (count($clids) != 1) return 0; # none, many

		return $clids[0];
		}

	function Update()
		{
		global $db;

		if ($this->getMail() == "")
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setMail($this->getMail());
		if (!$ok) return false;
		$fields["mail"] = $this->getMail();

		$ok = $this->setFirst($this->getFirst());
		if (!$ok) return false;
		$fields["first"] = $this->getFirst();

		$ok = $this->setLast($this->getLast());
		if (!$ok) return false;
		$fields["last"] = $this->getLast();

		$ok = $this->setAddr1($this->getAddr1());
		if (!$ok) return false;
		$fields["addr1"] = $this->getAddr1();

		$ok = $this->setAddr2($this->getAddr2());
		if (!$ok) return false;
		$fields["addr2"] = $this->getAddr2();

		$ok = $this->setCity($this->getCity());
		if (!$ok) return false;
		$fields["city"] = $this->getCity();

		$ok = $this->setState($this->getState());
		if (!$ok) return false;
		$fields["state"] = $this->getState();

		$ok = $this->setZip($this->getZip());
		if (!$ok) return false;
		$fields["zip"] = $this->getZip();

		$ok = $this->setTlf($this->getTlf());
		if (!$ok) return false;
		$fields["tlf"] = $this->getTlf();

		$ok = $this->setTlf2($this->getTlf2());
		if (!$ok) return false;
		$fields["tlf2"] = $this->getTlf2();

		$ok = $this->setCountry($this->getCountry());
		if (!$ok) return false;
		$fields["country"] = $this->getCountry();

		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("Client " . $this->lastError());
			return false;
			}

		return true;
		}

	function setMail($m)
		{
		$m = strtolower($m);
		$ok = $this->_checkMail($m);
		if (!$ok)
			{
			$this->_error("Client Mail " . $this->lastError());
			return false;
			}
		$this->mail = $m;
		return true;
		}

	function getMail()
		{
		return $this->mail;
		}

	function setFirst($f)
		{
		$ok = $this->_checkStr($f,CONST_FIRST_MINLEN,
			CONST_FIRST_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("Client First Name " . $this->lastError());
			return false;
			}
		$this->first = $f;
		return true;
		}

	function getFirst()
		{
		return $this->first;
		}

	function setLast($l)
		{
		$ok = $this->_checkStr($l,CONST_LAST_MINLEN,
			CONST_LAST_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("Client Last Name " . $this->lastError());
			return false;
			}
		$this->last = $l;
		return true;
		}

	function getLast()
		{
		return $this->last;
		}

	function setAddr1($a1)
		{
		$ok = $this->_checkStr($a1,CONST_ADDR_MINLEN,
			CONST_ADDR_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("Client Address1 " . $this->lastError());
			return false;
			}
		$this->addr1 = $a1;
		return true;
		}

	function getAddr1()
		{
		return $this->addr1;
		}
	function getStatus()
		{
		return $this->status;
		}

	function setAddr2($a2)
		{
		if (trim(strtolower($a2)) == "none") $a2 = "";
		$ok = $this->_checkStr($a2,CONST_ADDR2_MINLEN,
			CONST_ADDR_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Client Address2 " . $this->lastError());
			return false;
			}
		$this->addr2 = $a2;
		return true;
		}

	function getAddr2()
		{
		return $this->addr2;
		}

	function setCity($c)
		{
		$ok = $this->_checkStr($c,CONST_CITY_MINLEN,
			CONST_CITY_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("Client City " . $this->lastError());
			return false;
			}
		$this->city = $c;
		return true;
		}

	function getCity()
		{
		return $this->city;
		}

	function setState($s)
		{
		$ok = $this->_checkStr($s,CONST_STATE_MINLEN,
			CONST_STATE_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("Client State " . $this->lastError());
			return false;
			}
		$this->state = $s;
		return true;
		}

	function getState()
		{
		return $this->state;
		}

	function setZip($z)
		{
		$ok = $this->_checkStr($z,CONST_ZIP_MINLEN,
			CONST_ZIP_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("Client Zip " . $this->lastError());
			return false;
			}
		$this->zip = $z;
		return true;
		}

	function getZip()
		{
		return $this->zip;
		}

	function setTlf($t)
		{
		$ok = $this->_checkTlf($t);
		if (!$ok)
			{
			$this->_error("Client Phone# " . $this->lastError());
			return false;
			}
		$this->tlf = $t;
		return true;
		}

	function getTlf()
		{
		return $this->tlf;
		}

	function setTlf2($t2)
		{
		if (trim(strtolower($t2)) == "none") $a2 = "";
		$ok = $this->_checkTlf($t2,NULL_OK,CONST_TLF2_MINLEN);
		if (!$ok)
			{
			$this->_error("Client Phone2# " . $this->lastError());
			return false;
			}
		$this->tlf2 = $t2;
		return true;
		}

	function getTlf2()
		{
		return $this->tlf2;
		}

	function setCountry($c)
		{
		$ok = $this->_checkStr($c,CONST_COUNTRY_MINLEN,
			CONST_COUNTRY_MAXLEN,NOT_NULL);
		if (!$ok)
			{
			$this->_error("Client Country " . $this->lastError());
			return false;
			}
		$this->country = $c;
		return true;
		}

	function getCountry()
		{
		return $this->country;
		}

	function getChanged()
		{
		return $this->changed;
		}

	function getPass()
		{
		return substr(md5("PASSWORD FOR " . $this->getMail()),0,8);
		}

	function getTAFck()
		{
		return "Z" . crc32(md5("CLIENTACCESS" . $this->getID()));
		}

	function getTAFlink()
		{
		global $CODEBASE;

		return $CODEBASE . "/client/taf.php?clid=" . $this->getID() .
			"&ck=" . $this->getTAFck();
		}
	}

?>
