<?

# $Id: cardlog.inc.php 363 2004-03-21 11:34:15Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class Cardlog extends SimpleClassCommon
	{
	var $cardid = 0;
	var $result = "";
	var $result2 = "";
	var $transactionid = "";
	var $orderid = "";
	var $amount = 0;
	var $time = 0;

	function Cardlog($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"cardlog","cardlogid","time");
		if (!$ok)
			{
			$this->_error("Cardlog ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);
		if (!$r)
			{
			$this->_error("Cardlog Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->cardid = $r["cardid"];
		$this->result = $r["result"];
		$this->result2 = $r["result2"];
		$this->transactionid = $r["transactionid"];
		$this->orderid = $r["orderid"];
		$this->amount = $r["amount"];

		return true;
		}

	function listByCardID($id)
		{
		return $this->listSQL("cardid = '$id'");
		}

	function Update()
		{
		global $db;

		if ($this->getCardID() == 0)
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setCardID($this->getCardID());
		if (!$ok) return false;
		$fields["cardid"] = $this->getCardID();

		$ok = $this->setResult($this->getResult());
		if (!$ok) return false;
		$fields["result"] = $this->getResult();

		$ok = $this->setResult2($this->getResult2());
		if (!$ok) return false;
		$fields["result2"] = $this->getResult2();

		$ok = $this->setTransactionID($this->getTransactionID());
		if (!$ok) return false;
		$fields["transactionid"] = $this->getTransactionID();

		$ok = $this->setOrderID($this->getOrderID());
		if (!$ok) return false;
		$fields["orderid"] = $this->getOrderID();

		$ok = $this->setAmount($this->getAmount());
		if (!$ok) return false;
		$fields["amount"] = $this->getAmount();

		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("Cardlog " . $this->lastError());
			return false;
			}

		return true;
		}

	function setCardID($id)
		{
		$ok = $this->_checkID($id);
		if (!$ok)
			{
			$this->_error("Cardlog CardID " . $this->lastError());
			return false;
			}
		$this->cardid = $id;
		return true;
		}

	function getCardID()
		{
		return $this->cardid;
		}

	function setResult($r)
		{
		$ok = $this->_checkStr($r,1,255,NOT_NULL);
		if (!$ok)
			{
			$this->_error("Cardlog Result " . $this->lastError());
			return false;
			}
		$this->result = $r;
		return true;
		}

	function getResult()
		{
		return $this->result;
		}

	function setResult2($r)
		{
		$ok = $this->_checkStr($r,0,255,NULL_OK);
		if (!$ok)
			{
			$this->_error("Cardlog Result2 " . $this->lastError());
			return false;
			}
		$this->result2 = $r;
		return true;
		}

	function getResult2()
		{
		return $this->result2;
		}

	function setTransactionID($t)
		{
		$ok = $this->_checkStr($t,0,255,NULL_OK);
		if (!$ok)
			{
			$this->_error("Cardlog TransactionID " . $this->lastError());
			return false;
			}
		$this->transactionid = $t;
		return true;
		}

	function getTransactionID()
		{
		return $this->transactionid;
		}

	function setOrderID($id)
		{
		$ok = $this->_checkID($id,ZERO_OK);
		if (!$ok)
			{
			$this->_error("Orderlog OrderID " . $this->lastError());
			return false;
			}
		$this->orderid = $id;
		return true;
		}

	function getOrderID()
		{
		return $this->orderid;
		}

	function getIDByOrderID($oid)
		{
		return $this->listSQL("orderid = '$oid'");
		}

	function setAmount($a)
		{
		$ok = $this->_checkFloat($a,0,999999);
		if (!$ok)
			{
			$this->_error("Cardlog Amount " . $this->lastError());
			return false;
			}
		$this->amount = $a;
		return true;
		}

	function getAmount()
		{
		return $this->amount;
		}

	}

?>
