<?

# $Id: cardcredit2.inc.php 592 2004-07-27 22:53:03Z raf $

require_once("../inc/lphp.php"); 	 		# yourpay class
require_once("../inc/authnet.php"); 	 	# authorize.net class

function DG_ParserCredit($simple)
	{
	$p = xml_parser_create();
	xml_parse_into_struct($p,$simple,$vals,$index);
	xml_parser_free($p);

#	echo "<pre>"; print_r($vals); echo "</pre>";

	$value = (isset($vals[1]["value"]) ? $vals[1]["value"] : "");
	return array($vals[1]["attributes"],$value);
	}


function CCCredit($oid,$cardid,$transid,$credit)
	{

	$DEBUG = 0;

	if (AUTHNET_ENABLE)
		return AuthNetCCcredit($oid,$cardid,$transid,$credit);

	if (YOURPAY_ENABLE)
		return YPCCcredit($oid,$cardid,$transid,$credit);

	if (CCAUTH_DEBUG)
		{
		$ret = "CREDIT";
		$ret2 = (CCAUTH_DEBUG == 1 ? "Forced debug failure" : "OK");
		$clog = new Cardlog();

		$clog->setCardID($cardid);
		$clog->setResult($ret);
		$clog->setResult2($ret2);
		$clog->setTransactionID($transid);
		$clog->setOrderID($oid);
		$clog->setAmount($credit);
		$clog->Update();

		return array($ret,$ret2);
		}

	$reqheader = 'xml=<!DOCTYPE pp.request PUBLIC "-//IMALL//DTD' .
		' PUREPAYMENTS 1.0//EN" ' .
		'"http://www.purepayments.com/dtd/purepayments.dtd">';

	$start = '<pp.request merchant="' . SUREPAY_MERCHANTID .
		'" password="' . SUREPAY_PASSWORD . '">';

	$creditreq = '<pp.credit transactionid="' . $transid .
		'" amount="' . sprintf("%.02f",$credit) . 'USD"></pp.credit>';

	$request = $reqheader . $start . $creditreq . '</pp.request>';

	if ($DEBUG) echo "<pre>request=", wordwrap(htmlentities($request),70), "</pre>";

	$ch = curl_init ();

	curl_setopt($ch, CURLOPT_URL, SUREPAY_POST);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $request);
#	curl_setopt($ch, CURLOPT_POSTFIELDSIZE, 0);
	curl_setopt($ch, CURLOPT_TIMEOUT, SUREPAY_TIMEOUT);
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_setopt($ch, CURLOPT_SSLVERSION, 3);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

	$result = curl_exec ($ch);

#	# failed
#	$result = '<!DOCTYPE pp.response PUBLIC "-//IMALL//DTD PUREPAYMENTS 1.0//EN" "http://www.purepayments.com/dtd/purepayments.dtd"> <pp.response> <pp.creditresponse merchant="21641" failure="true">XML syntax error: Could not issue credit com.purepayments.biz.PurePaymentsException: Credit amount (100) plus amounts already credited (0) exceeds the amount originally settled (0)</pp.creditresponse> </pp.response>';

#	# went ok
#	$result = '<!DOCTYPE pp.response PUBLIC "-//IMALL//DTD PUREPAYMENTS 1.0//EN" "http://www.purepayments.com/dtd/purepayments.dtd"> <pp.response> <pp.creditresponse merchant="21641" transactionid="CC_NP38851C2F38"/> </pp.response>';

	if ($DEBUG) echo "<pre>got=" . htmlspecialchars($result) . "</pre>";

	$curl_array = curl_getinfo($ch);

	list($attributes,$value) = DG_ParserCredit($result);

	if (!$value) $value = "OK";

	if ($DEBUG)
		{
		foreach ($attributes as $k => $v)
			echo "ATTR $k = '$v'<br>";
		}

	$ret = "CREDIT";

	curl_close ($ch);

	$value = str_replace("XML syntax error: ","",$value);

	$r = array($ret,$value);

	# do not check return code; this is a cruicial function

	$clog = new Cardlog();

	$clog->setCardID($cardid);
	$clog->setResult($ret);
	$clog->setResult2($value);
	$clog->setTransactionID($transid);
	$clog->setOrderID($oid);
	$clog->setAmount($credit);
	$clog->Update();

	return $r;
	}

function AuthNetCCcredit($oid,$cardid,$transid,$credit)
{
	$an = new authnet();

	$ci = new Card($cardid);

	if (!$ci->wasOK())
		return array("INT","Card ID#$cardid Error: " .
			$ci->lastError());

	$fmtd_expy = sprintf("%02d",substr($ci->getYear(),-2));
	$fmtd_expm = sprintf("%02d",$ci->getMonth());

	$fmtd_credit =sprintf("%.02f",$credit);

	$order = array(
		"host" 			=> AUTHNET_HOST,
		"login" 		=> AUTHNET_LOGIN,
		"transkey" 		=> AUTHNET_KEY,
		"version" 		=> AUTHNET_VERNO,
		"testtrans" 	=> AUTHNET_TESTTRANS,
		"delimchar" 	=> AUTHNET_DELIMCHAR,
		"delimdata" 	=> AUTHNET_DELIMDATA,
		"relayresp" 	=> AUTHNET_RELAYRESP,
		"transtype" 	=> "CREDIT",
		"method"		=> "CC",
		);

	$order["oid"] = $transid; #YOURPAY_OIDPREFIX . "$oid-CREDIT-" . time();

	$order["chargetotal"] = $fmtd_credit;

	$order["cardnumber"] = $ci->getNumber();
	$order["cardexpdt"] = $fmtd_expm . $fmtd_expy;

	$ret = $an->curl_process($order);

#	var_dump($ret);

	$r = array("UNKN","UNKNOWN");
	$transid = "CFAILED-" . simuniqueid();

	switch ($ret["appr"])
	{
		case "APPROVED":
			$r = array("CREDIT","OK");
			$transid = $ret["transid"];
			break;
		case "DECLINED":
			$r = array("DCL",$ret["errordesc"]);
			$transid = $ret["transid"];
			break;
		case "ERROR":
			$r = array("FAIL",$ret["errordesc"]);
			break;
		case "FRAUD":
			$r = array("REF",$ret["errordesc"]);
			$transid = $ret["transid"];
			break;
		default:
			$r = array("INT","Internal error: " . $ret["errordesc"]);
			break;
	}

	$clog = new Cardlog();

	$clog->setCardID($cardid);
	$clog->setResult($r[0]);
	$clog->setResult2($r[1]);
	$clog->setTransactionID($transid);
	$clog->setOrderID($oid);
	$clog->setAmount($credit);
	$clog->Update();

	return $r;
}

function YPCCcredit($oid,$cardid,$transid,$credit)
	{
	$yp = new lphp();

	$ci = new Card($cardid);

	if (!$ci->wasOK())
		return array("INT","Card ID#$cardid Error: " .
			$ci->lastError());

	$fmtd_expy = sprintf("%02d",substr($ci->getYear(),-2));
	$fmtd_expm = sprintf("%02d",$ci->getMonth());

	$fmtd_credit =sprintf("%.02f",$credit);

	$order = array(
		"host" => YOURPAY_HOST,
		"port" => YOURPAY_PORT,
		"keyfile" => YOURPAY_PEM,
		"configfile" => YOURPAY_STORENO,
		"terminaltype" => "UNSPECIFIED",
		"ordertype" => "CREDIT",
		);

	$order["debugging"] = "false";
	$order["debugging"] = (CCAUTH_DEBUG ? "true" : "false");

	$order["oid"] = $transid; #YOURPAY_OIDPREFIX . "$oid-CREDIT-" . time();

	$order["chargetotal"] = $fmtd_credit;

	$order["cardnumber"] = $ci->getNumber();
	$order["cardexpmonth"] = $fmtd_expm;
	$order["cardexpyear"] = $fmtd_expy;

	$ret = $yp->curl_process($order);

#	var_dump($ret);

	$r = array("UNKN","UNKNOWN");
	$transid = "CFAILED-" . simuniqueid();

	switch ($ret["r_approved"])
		{
		case "APPROVED":
			$r = array("CREDIT","OK");
			$transid = $order["oid"];
			break;
		case "FRAUD":
			$r = array("REF",$ret["r_error"]);
			$transid = $order["oid"];
			break;
		case "FAILURE":
			$r = array("FAIL","Could not connect");
			break;
		case "DECLINED":
			$r = array("DCL",$ret["r_error"]);
			$transid = $order["oid"];
			break;
/*
			case "ERR":
				$r = array("ERR","Surepay error");
				break;
*/
		default:
			$r = array("INT","Internal error: " . $ret["r_error"]);
#			$r = array("INT","Invalid Card Number");
			break;
		}

	$clog = new Cardlog();

	$clog->setCardID($cardid);
	$clog->setResult($r[0]);
	$clog->setResult2($r[1]);
	$clog->setTransactionID($transid);
	$clog->setOrderID($oid);
	$clog->setAmount($credit);
	$clog->Update();

	return $r;
	}

/*
# THIS IS DEBUG CODE

require_once("../conf/db.config.php");
require_once("../inc/database.inc.php");
require_once("../inc/layout.inc.php");
require_once("../inc/macro.inc.php");
require_once("../inc/mailmsgs.inc.php");

require_once("../inc/nicefunctions.inc.php");

require_once("../inc/client.inc.php");
require_once("../inc/order.inc.php");
require_once("../inc/resinfo.inc.php");
require_once("../inc/card.inc.php");
require_once("../inc/assigment.inc.php");
require_once("../inc/autoassign.inc.php");
require_once("../inc/autoassignlog.inc.php");
require_once("../inc/package.inc.php");
require_once("../inc/rush.inc.php");
require_once("../inc/resfile.inc.php");

require_once("../inc/prices.inc.php");
require_once("../inc/writer.inc.php");

require_once("../inc/cardtrans.inc.php");
require_once("../inc/cardlog.inc.php");

require_once("../inc/comment.inc.php");

require_once("../inc/website.inc.php");

require_once("../inc/coupon.inc.php");
require_once("../conf/resconfig.php");

$db = new Database($RES_DB_DATABASE,$RES_DB_HOST,$RES_DB_USER,$RES_DB_PASS);

print_r(CCCredit(219384,"139","CC_NP38851C2F38","10"));
*/
