<?

# $Id: bannerclick.inc.php 249 2004-02-23 20:03:00Z raf $: affiliate.inc.php,v 1.2 2004/02/22 20:34:36 raf Exp $

require_once("../inc/simpleclasscommon.inc.php");

class BannerClick extends SimpleClassCommon
	{
	var $affiliateid = 0;
	var $clicktype = "";

	function BannerClick($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"bannerclick",
			"bannerclickid","created");
		if (!$ok)
			{
			$this->_error("BannerClick ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);
		if (!$r)
			{
			$this->_error("BannerClick Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->affiliateid = $r["affiliateid"];
		$this->clicktype = $r["clicktype"];

		return true;
		}

	function Update()
		{
		global $db;

		if ($this->getAffiliateID() == 0)
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setAffiliateID($this->getAffiliateID());
		if (!$ok) return false;
		$fields["affiliateid"] = $this->getAffiliateID();

		$ok = $this->setClickType($this->getClickType());
		if (!$ok) return false;
		$fields["clicktype"] = $this->getClickType();

		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("BannerClick " . $this->lastError());
			return false;
			}

		return true;
		}

	function setAffiliateID($id)
		{
		if ($id)
			{
			$ok = $this->_checkID($id);
			if (!$ok)
				{
				$this->_error("BannerClick AffiliateID " . $this->lastError());
				return false;
				}
			}
		$this->affiliateid = $id;
		return true;
		}

	function getAffiliateID()
		{
		return $this->affiliateid;
		}

	function setClickType($c)
		{
		switch ($c)
			{
			case "b":
			case "l":
				break;
			default:
			$this->_error("BannerClick ClickType '$c' unknown");
			return false;
			}

		$this->clicktype = $c;
		return true;
		}

	function getClickType()
		{
		return $this->clicktype;
		}

	function getIDByAffiliateID($afid)
		{
		return $this->listSQL("affiliateid = '$afid'");
		}

	}
?>
