<?

# $Id: autoassignlog.inc.php 186 2004-02-05 20:25:36Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class AutoAssignLog extends SimpleClassCommon
	{
	var $writerid = 0;
	var $logentry = "";
	var $LOGFORREAL = AALOG_ENABLE;

	function AutoAssignLog($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"autoassignlog",
			"autoassignlogid","created");
		if (!$ok)
			{
			$this->_error("Autoassignlog ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);

		if (!$r)
			{
			$this->_error("Autoassignlog Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->writerid = $r["writerid"];
		$this->logentry = $r["logentry"];

		return true;
		}

	function Update()
		{
		global $db;

		if ($this->getLogEntry() == "")
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setWriterID($this->getWriterID());
		if (!$ok) return false;
		$fields["writerid"] = $this->getWriterID();

		$ok = $this->setLogEntry($this->getLogEntry());
		if (!$ok) return false;
		$fields["logentry"] = $this->getLogEntry();

		if ($this->LOGFORREAL)
			$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("Autoassignlog " . $this->lastError());
			return false;
			}

		return true;
		}

	function setWriterID($id)
		{
		if (!$id)
			{
			$this->writerid = 0;
			return true;
			}

		$ok = $this->_checkID($id);
		if (!$ok)
			{
			$this->_error("Assigment Writer ID " . $this->lastError());
			return false;
			}
		$this->writerid = $id;
		return true;
		}

	function getWriterID()
		{
		return $this->writerid;
		}

	function setLogEntry($l)
		{
		$ok = $this->_checkStr(addslashes($l),1,255);
		if (!$ok)
			{
			$this->_error("Autoassignlog LogEntry " .
				$this->lastError());
			return false;
			}
		$this->logentry = addslashes($l);
		return true;
		}

	function getLogEntry()
		{
		return $this->logentry;
		}

	function listEntriesByDate($date,$wid=0)
		{
		$q = "UNIX_TIMESTAMP(created) >= $date AND
			UNIX_TIMESTAMP(created) < " . ($date+86400);
		if ($wid) $q .= " AND writerid=$wid";

		return $this->listSQL($q);
		}
	}

?>
