<?

# $Id: autoassign.inc.php 760 2005-11-23 21:49:10Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class Autoassign extends SimpleClassCommon
	{
	var $writerid = 0;
	var $assigndate = "";
	var $capacity = 0;
	var $assigned = 0;

	function Autoassign($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"autoassign",
			"autoassignid");
		if (!$ok)
			{
			$this->_error("Autoassign ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id,"DATE_FORMAT(assigndate,'" .
			DATEFMT_DATE_YYYYMMDD_MYSQL . "') as
			assigndate2");

		if (!$r)
			{
			$this->_error("Autoassign Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->writerid = $r["writerid"];
		$this->assigndate = $r["assigndate2"];
		$this->capacity = $r["capacity"];
		$this->assigned = $r["assigned"];

		return true;
		}

	function Update()
		{
		global $db;

		if ($this->getWriterID() == 0)
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setWriterID($this->getWriterID());
		if (!$ok) return false;
		$fields["writerid"] = $this->getWriterID();

		$ok = $this->setAssigndate($this->getAssigndate());
		if (!$ok) return false;
		$fields["assigndate"] = $this->getAssigndate();

		$ok = $this->setCapacity($this->getCapacity());
		if (!$ok) return false;
		$fields["capacity"] = $this->getCapacity();

		$ok = $this->setAssigned($this->getAssigned());
		if (!$ok) return false;
		$fields["assigned"] = $this->getAssigned();

		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("Autoassign " . $this->lastError());
			return false;
			}

		return true;
		}

	function setWriterID($id)
		{
		$ok = $this->_checkID($id);
		if (!$ok)
			{
			$this->_error("Autoassign Writer ID " . $this->lastError());
			return false;
			}
		$this->writerid = $id;
		return true;
		}

	function getWriterID()
		{
		return $this->writerid;
		}

	function setAssigndate($d)
		{
		$ok = $this->_checkDate4Y2M2D($d);
		if (!$ok)
			{
			$this->_error("Autoassign Assigndate " . $this->lastError());
			return false;
			}
		$this->assigndate = $d;
		return true;
		}

	function getAssigndate()
		{
		return $this->assigndate;
		}

	function setCapacity($c)
		{
		$ok = $this->_checkInt($c*2,0,200); // *2 because we do halves now
		if (!$ok)
			{
			$this->_error("Autoassign Capacity " . $this->lastError());
			return false;
			}
		$this->capacity = $c;
		return true;
		}

	function getCapacity()
		{
		return $this->capacity;
		}

	function setAssigned($a)
		{
		$ok = $this->_checkInt($a*2,0,200); // *2 because we do halves now
		if (!$ok)
			{
			$this->_error("Autoassign Assigned " . $this->lastError());
			return false;
			}
		$this->assigned = $a;
		return true;
		}

	function getAssigned()
		{
		return $this->assigned;
		}

	function listByWriterIDAndDate($wid,$date)
		{
		return $this->listSQL("writerid = '$wid'
			AND assigndate = '$date'");
		}

	function _getTodayDate()
		{
		$t = time();
		$sod = date("H",$t) * 3600 + date("i",$t) * 60 + date("s",$t);
		$t = $t - $sod;
		return $t;
		}

	function bumpAssigned($wid,$dat,$or)
		{
		global $db;

		$ile = 1;
		if ($or->getOrderType() == ORDER_TYPE_COVERLETTER)
			$ile = 0.5;
		if ($or->getOrderType() == ORDER_TYPE_FED)
			$ile = 2;

		$q = "UPDATE " . $this->table . " SET assigned = assigned + $ile
			WHERE assigndate = '$dat'
			AND writerid = $wid";

		$db->query($q);
		return true;
		}

	function odjebAssigned($wid,$dat,$or)
		{
		global $db;

		$ile = 1;
		if ($or->getOrderType() == ORDER_TYPE_COVERLETTER)
			$ile = 0.5;
		if ($or->getOrderType() == ORDER_TYPE_FED)
			$ile = 2;

		$q = "UPDATE " . $this->table . " SET assigned = assigned - $ile
			WHERE assigndate = '$dat'
			AND writerid = $wid";

		$db->query($q);
		return true;
		}

	function setAssignMode($mode)
		{
		global $db;

		$m = ($mode ? 1 : 0);

		$q = "UPDATE assignmode SET mode = $m";
		$db->query($q);

		return true;
		}

	function getAssignMode()
		{
		global $db;

		$q = "SELECT mode FROM assignmode";
		$got = $db->query($q);

		return $got->f(0);
		}

	function getNextRun()
		{
		global $db;

		$q = "SELECT UNIX_TIMESTAMP(nextrun) AS nextrun
			FROM assignmode";
		$got = $db->query($q);

		return $got->f(0);
		}

	function setNextRun($ux)
		{
		global $db;

		$q = "UPDATE assignmode SET nextrun = FROM_UNIXTIME($ux)";
		$got = $db->query($q);

		return true;
		}

	function getLastEntryForWriter($wid)
		{
		global $db;

		$q = "SELECT MAX(assigndate) FROM " . $this->table .
			" WHERE writerid = '$wid'";

		$got = $db->query($q);

		if (!$got->numRows()) return "";

		return $got->f(0);
		}

	function getAvaliableWriters($dat,$or)
		{
		global $db;
    
    $doescoach = $or->getConsult();
    
		$where  = ($or->getJobHunter() ?
			" writer.doesjh = 1 AND" : "");

		if ($or->getOrderType() == ORDER_TYPE_CV)
			{
			$where  .= " writer.doescv = 1 AND";
			}

#		assign a Fed/KSA order only to the writer who takes this type of an order

		if ($or->getOrderType() == ORDER_TYPE_FED)
		{
			$where  .= " writer.doesksa = 1 AND";
		}

#		assign an Exec order only to the writer who takes this type of an order

		if ($or->getOrderType() == ORDER_TYPE_EXEC)
		{
			$where  .= " writer.doesexec = 1 AND";
		}
		
		if($doescoach > 0 )
		{
			$where  .= " writer.doescoach = 1 AND";
		}

		# this is for the situation when capacity is 3.5 and assigned
		# is 3 and non-CL order comes in which counts for 1 in there

		$addspecial = false;
		$addnum = "";

		if (($or->getOrderType() == ORDER_TYPE_COVERLETTER) || ($or->getOrderType() == ORDER_TYPE_FED)) {
			$addspecial = true;

			if ($or->getOrderType()	== ORDER_TYPE_COVERLETTER)
				$addnum = "+ 0.5";
			if ($or->getOrderType() == ORDER_TYPE_FED)
				$addnum = "+ 2";
		}

		$q = "SELECT " . $this->table . ".* FROM " .
			$this->table .
			" LEFT JOIN writer USING (writerid) " .
			"WHERE $where " . $this->table . ".assigned " .
			($addspecial ? $addnum : "") . "< " .
			$this->table . ".capacity AND " .
			$this->table . ".assigndate = '$dat'
			ORDER BY RAND()"; # . $this->table . ".writerid";

		//echo "q=$q\n";

		$got = $db->query($q);

		$ret = array();

		while ($r = $got->fetchArray())
			{
			$ret[] = array($r["writerid"],$r["capacity"],
				$r["assigned"]);
			}
//print_R($ret);exit;
		return $ret;
		}

	}

/*
# THIS IS DEBUG CODE

require_once("../conf/db.config.php");
require_once("../inc/database.inc.php");
require_once("../inc/layout.inc.php");
require_once("../inc/macro.inc.php");
require_once("../inc/mailmsgs.inc.php");

require_once("../inc/nicefunctions.inc.php");

require_once("../inc/client.inc.php");
require_once("../inc/order.inc.php");
require_once("../inc/resinfo.inc.php");
require_once("../inc/card.inc.php");
require_once("../inc/assigment.inc.php");
require_once("../inc/autoassignlog.inc.php");
require_once("../inc/package.inc.php");
require_once("../inc/rush.inc.php");
require_once("../inc/resfile.inc.php");

require_once("../inc/prices.inc.php");
require_once("../inc/writer.inc.php");

#require_once("../inc/cardtrans.inc.php");
require_once("../inc/cardlog.inc.php");

require_once("../inc/comment.inc.php");

require_once("../inc/website.inc.php");

require_once("../inc/coupon.inc.php");
require_once("../conf/resconfig.php");

$db = new Database($RES_DB_DATABASE,$RES_DB_HOST,$RES_DB_USER,$RES_DB_PASS);


$w = new Autoassign();
print_r($w->getAvaliableWriters('2004-02-13',0));
*/

?>
