<?

# $Id: assigment.inc.php 559 2004-05-11 22:02:59Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class Assignment extends SimpleClassCommon
	{
	var $orderid = 0;
	var $writerid = 0;
	var $deadline = 0;
	var $deadlineh = 0;
	var $completed = 0;
	var $filename = "";
	var $diskfilename = "";
	var $jhfilename = "";
	var $jhdiskfilename = "";
	var $changed = 0;

	function Assignment($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"assignment","assignmentid","created");
		if (!$ok)
			{
			$this->_error("Assigment ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id,
			"UNIX_TIMESTAMP(deadline) AS deadlineUX,
			UNIX_TIMESTAMP(completed) AS completedUX,
			UNIX_TIMESTAMP(changed) AS changedUX");
		if (!$r)
			{
			$this->_error("Assigment Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->orderid = $r["orderid"];
		$this->writerid = $r["writerid"];
		$this->deadline = $r["deadlineUX"];
		$this->deadlineh = $r["deadlineh"];
		if (isset($r["completed"]))
			$this->completed = $r["completedUX"];
		$this->filename = $r["filename"];
		$this->diskfilename = $r["diskfilename"];
		$this->jhfilename = $r["jhfilename"];
		$this->jhdiskfilename = $r["jhdiskfilename"];
		$this->changed = $r["changedUX"];

		return true;
		}

	function Update()
		{
		global $db;

		if ($this->getWriterID() == 0)
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();
		$unixtime = array();

		$ok = $this->setWriterID($this->getWriterID());
		if (!$ok) return false;
		$fields["writerid"] = $this->getWriterID();

		$ok = $this->setOrderID($this->getOrderID());
		if (!$ok) return false;
		$fields["orderid"] = $this->getOrderID();

		$ok = $this->setDeadline($this->getDeadline());
		if (!$ok) return false;
		$unixtime["deadline"] = $this->getDeadline();

		$ok = $this->setDeadlineHour($this->getDeadlineHour());
		if (!$ok) return false;
		$fields["deadlineh"] = $this->getDeadlineHour();

		$ok = $this->setFilename($this->getFilename());
		if (!$ok) return false;
		$fields["filename"] = $this->getFilename();

		$ok = $this->setDiskfilename($this->getDiskfilename());
		if (!$ok) return false;
		$fields["diskfilename"] = $this->getDiskfilename();

		$ok = $this->setJHFilename($this->getJHFilename());
		if (!$ok) return false;
		$fields["jhfilename"] = $this->getJHFilename();

		$ok = $this->setJHDiskfilename($this->getJHDiskfilename());
		if (!$ok) return false;
		$fields["jhdiskfilename"] = $this->getJHDiskfilename();

		if ($this->completed)
			$unixtime["completed"] = $this->getCompleted();

		$ok = $this->_internalUpdate($fields,$unixtime);

		if (!$ok)
			{
			$this->_error("Assigment " . $this->lastError());
			return false;
			}

		return true;
		}

	function setWriterID($id)
		{
		$ok = $this->_checkID($id);
		if (!$ok)
			{
			$this->_error("Assigment Writer ID " . $this->lastError());
			return false;
			}
		$this->writerid = $id;
		return true;
		}

	function getWriterID()
		{
		return $this->writerid;
		}

	function setOrderID($id)
		{
		$ok = $this->_checkID($id);
		if (!$ok)
			{
			$this->_error("Assigment Order ID " . $this->lastError());
			return false;
			}
		$this->orderid = $id;
		return true;
		}

	function getOrderID()
		{
		return $this->orderid;
		}

	function setDeadline($ux)
		{
		$ok = $this->_checkUxTime($ux);
		if (!$ok)
			{
			$this->_error("Assigment Deadline Unixtime " . $this->lastError());
			return false;
			}
		$this->deadline = $ux;
		return true;
		}

	function getDeadline()
		{
		return $this->deadline;
		}

	function setDeadlineHour($h)
		{
		$ok = $this->_checkInt($h,0,23);
		if (!$ok)
			{
			$this->_error("Assigment Deadline Hour " . $this->lastError());
			return false;
			}
		$this->deadlineh = $h;
		return true;
		}

	function getDeadlineHour()
		{
		return $this->deadlineh;
		}

	function getDeadlineText()
		{
		global $DEADLINE_HOUR_ARRAY;

		return date(DATEFMT_DATE,$this->getDeadline()) .
			" " . $DEADLINE_HOUR_ARRAY[$this->getDeadlineHour()];
		}

	function getRealDeadline()
		{
		$rd = $this->getDeadline();
		$rd = $rd + ($this->getDeadlineHour() ?
			$this->getDeadLineHour() * 3600 : 86399);
		return $rd;
		}

	function listUnassignedOrders($how=NORMAL_ORDER)
		{
		global $db;

		$q = "SELECT orderdata.orderid 
			FROM orderdata
			LEFT JOIN assignment USING (orderid)
			WHERE assignment.orderid IS NULL and chk_file != '2'
			ORDER BY " . ($how == PRIORITIZE_RUSHES ?
				"rushid DESC," : "") .
				"orderid"; ## prioritize rushes

		$got = $db->query($q);

		$orders = array();

		while ($orderid = $got->f(0))
			{
			$orders[$orderid] = $orderid;
			}

		return $orders;
		}

	function listCompletedOrders($how=NORMAL_ORDER,$exclude="")
		{
		global $db;

		$q = "SELECT orderdata.orderid 
			FROM orderdata
			LEFT JOIN assignment USING (orderid)
			WHERE assignment.completed IS NOT NULL";
		if (strlen($exclude))
			$q .= " AND orderdata.orderid NOT IN ($exclude)";
		$q .= " ORDER BY " . ($how == PRIORITIZE_RUSHES ?
				"rushid DESC," : "") .
				"orderid"; ## prioritize rushes

		$got = $db->query($q);

		$orders = array();

		while ($orderid = $got->f(0))
			{
			$orders[$orderid] = $orderid;
			}

		return $orders;
		}

	function getCompleted()
		{
		return ($this->completed ? $this->completed : 0);
		}

	function Completed()
		{
		$this->completed = time();
		return $this->Update();
		}

	function setFilename($f)
		{
		$ok = $this->_checkStr($f,CONST_FILE_NAME_MINLEN,
			CONST_FILE_NAME_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Assignment Filename " . $this->lastError());
			return false;
			}
		$this->filename = $f;
		return true;
		}

	function getFilename()
		{
		return $this->filename;
		}

	function setDiskfilename($f)
		{
		$ok = $this->_checkStr($f,CONST_FILE_NAME_MINLEN,
			CONST_FILE_NAME_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Assignment Disk Filename " . $this->lastError());
			return false;
			}
		$this->diskfilename = $f;
		return true;
		}

	function getDiskfilename()
		{
		return $this->diskfilename;
		}

	function getChanged()
		{
		return $this->changed;
		}

	function setJHFilename($f)
		{
		$ok = $this->_checkStr($f,CONST_FILE_NAME_MINLEN,
			CONST_FILE_NAME_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Assignment JH Filename " . $this->lastError());
			return false;
			}
		$this->jhfilename = $f;
		return true;
		}

	function getJHFilename()
		{
		return $this->jhfilename;
		}

	function setJHDiskfilename($f)
		{
		$ok = $this->_checkStr($f,CONST_FILE_NAME_MINLEN,
			CONST_FILE_NAME_MAXLEN,NULL_OK);
		if (!$ok)
			{
			$this->_error("Assignment JH Disk Filename " . $this->lastError());
			return false;
			}
		$this->jhdiskfilename = $f;
		return true;
		}

	function getJHDiskfilename()
		{
		return $this->jhdiskfilename;
		}

	function findFilename($fn)
		{
		return $this->listSQL("diskfilename = '$fn' OR jhdiskfilename = '$fn'");
		}
	}
?>
