<?

# $Id: affiliate.inc.php 464 2004-04-02 19:50:01Z raf $

require_once("../inc/simpleclasscommon.inc.php");

class Affiliate extends SimpleClassCommon
	{
	var $websiteid = 0;
	var $name = "";
	var $mail = "";
	var $tlf = "";
	var $person = "";
	var $payee = "";
	var $addr1 = "";
	var $addr2 = "";
	var $city = "";
	var $state = "";
	var $zip = "";
	var $country = "USA";
	var $ssn = "";
	var $pass = "";
	var $bannerpass = "";
	var $clickredirecturl = "";
	var $rateperorder = 0;
	var $ratepersale = 0;
	var $azoosflg = 0;
	
	var $enforce_requirements = true; //Set False when doing bulk uploads

	function Affiliate($id=0)
		{
		$ok = parent::SimpleClassCommon($id,"affiliate","affiliateid","created");
		if (!$ok)
			{
			$this->_error("Affiliate ". $this->lastError());
			return false;
			}

		return true;
		}

	function fetchData($id)
		{
		global $db;

		$id = addslashes($id);

		$r = $this->_internalFetchData($id);
		if (!$r)
			{
			$this->_error("Affiliate Fetch ". $this->lastError());
			return false;
			}

		$this->id = $id;
		$this->websiteid = $r["websiteid"];
		$this->name = $r["name"];
		$this->mail = $r["mail"];
		$this->tlf = $r["tlf"];
		$this->person = $r["person"];
		$this->payee = $r["payee"];
		$this->addr1 = $r["addr1"];
		$this->addr2 = $r["addr2"];
		$this->city = $r["city"];
		$this->state = $r["state"];
		$this->zip = $r["zip"];
		$this->country = $r["country"];
		$this->ssn = $r["ssn"];
		$this->pass = $r["pass"];
		$this->bannerpass = $r["bannerpass"];
		$this->clickredirecturl = $r["clickredirecturl"];
		$this->rateperorder = $r["rateperorder"];
		$this->ratepersale = $r["ratepersale"];
		$this->azoosflg = $r["azoosflg"];

		return true;
		}

	function Update()
		{
		global $db;

		if ($this->getName() == "")
			{
			$this->_error("New object, no data set");
			return false;
			}

		$fields = array();

		$ok = $this->setWebsiteID($this->getWebsiteID());
		if (!$ok) return false;
		$fields["websiteid"] = $this->getWebsiteID();

		$ok = $this->setName($this->getName());
		if (!$ok) return false;
		$fields["name"] = $this->getName();

		$ok = $this->setMail($this->getMail());
		if (!$ok) return false;
		$fields["mail"] = $this->getMail();

		$ok = $this->setTlf($this->getTlf());
		if (!$ok) return false;
		$fields["tlf"] = $this->getTlf();

		$ok = $this->setPerson($this->getPerson());
		if (!$ok) return false;
		$fields["person"] = $this->getPerson();

		$ok = $this->setPayee($this->getPayee());
		if (!$ok) return false;
		$fields["payee"] = $this->getPayee();

		$ok = $this->setAddr1($this->getAddr1());
		if (!$ok) return false;
		$fields["addr1"] = $this->getAddr1();

		$ok = $this->setAddr2($this->getAddr2());
		if (!$ok) return false;
		$fields["addr2"] = $this->getAddr2();

		$ok = $this->setCity($this->getCity());
		if (!$ok) return false;
		$fields["city"] = $this->getCity();

		$ok = $this->setState($this->getState());
		if (!$ok) return false;
		$fields["state"] = $this->getState();

		$ok = $this->setZip($this->getZip());
		if (!$ok) return false;
		$fields["zip"] = $this->getZip();

		$ok = $this->setCountry($this->getCountry());
		if (!$ok) return false;
		$fields["country"] = $this->getCountry();

		$ok = $this->setSSN($this->getSSN());
		if (!$ok) return false;
		$fields["ssn"] = $this->getSSN();

		$ok = $this->setPass($this->getPass());
		if (!$ok) return false;
		$fields["pass"] = $this->getPass();

		$ok = $this->setBannerPass($this->getBannerPass());
		if (!$ok) return false;
		$fields["bannerpass"] = $this->getBannerPass();

		$ok = $this->setClickRedirectURL($this->getClickRedirectURL());
		if (!$ok) return false;
		$fields["clickredirecturl"] = $this->getClickRedirectURL();

		$ok = $this->setRatePerOrder($this->getRatePerOrder());
		if (!$ok) return false;
		$fields["rateperorder"] = $this->getRatePerOrder();

		$ok = $this->setRatePerSale($this->getRatePerSale());
		if (!$ok) return false;
		$fields["ratepersale"] = $this->getRatePerSale();

		$ok = $this->setAzoosFlg($this->getAzoosFlg());
		if (!$ok) return false;
		$fields["azoosflg"] = $this->getAzoosFlg();

		$ok = $this->_internalUpdate($fields);

		if (!$ok)
			{
			$this->_error("Affiliate " . $this->lastError());
			return false;
			}

		return true;
		}

	function setWebsiteID($id)
		{
		if ($id)
			{
			$ok = $this->_checkID($id);
			if (!$ok)
				{
				$this->_error("Affiliate WebsiteID " . $this->lastError());
				return false;
				}
			}
		$this->websiteid = $id;
		return true;
		}

	function getWebsiteID()
		{
		return $this->websiteid;
		}

	function setName($n)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkStr($n,CONST_WEBSITE_NAME_MINLEN,
				CONST_WEBSITE_NAME_MAXLEN,NOT_NULL);
			if (!$ok)
				{
				$this->_error("Affiliate Name " . $this->lastError());
				return false;
				}
		}
		$this->name = $n;
		return true;
		}

	function getName()
		{
		return $this->name;
		}

	function setMail($m)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkMail($m);
			if (!$ok)
				{
				$this->_error("Affiliate Mail " . $this->lastError());
				return false;
				}
		}
		$this->mail = $m;
		return true;
		}

	function getMail()
		{
		return $this->mail;
		}

	function setPass($p)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkStr($p,CONST_PASS_MINLEN,
				CONST_PASS_MAXLEN,NOT_NULL);
			if (!$ok)
				{
				$this->_error("Affiliate Pass " . $this->lastError());
				return false;
				}
		}
		$this->pass = $p;
		return true;
		}

	function getPass()
		{
		return $this->pass;
		}

	function setBannerPass($p)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkStr($p,CONST_AFF_BPASS_MINLEN,
				CONST_AFF_BPASS_MAXLEN,NOT_NULL);
			if (!$ok)
				{
				$this->_error("Affiliate BannerPass " . $this->lastError());
				return false;
				}
		}
		$this->bannerpass = $p;
		return true;
		}

	function getBannerPass()
		{
		return $this->bannerpass;
		}

	function setClickRedirectURL($c)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkStr($c,CONST_AFF_REDIRURL_MINLEN,
				CONST_AFF_REDIRURL_MAXLEN,NULL_OK);
			if (!$ok)
				{
				$this->_error("Affiliate ClickRedirectURL " . $this->lastError());
				return false;
				}
		}
		$this->clickredirecturl = $c;
		return true;
		}

	function getClickRedirectURL()
		{
		return $this->clickredirecturl;
		}

	function setRatePerOrder($r)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkPrice($r);
			if (!$ok)
				{
				$this->_error("Affiliate RatePerOrder " . $this->lastError());
				return false;
				}
		}
		$this->rateperorder = $r;
		return true;
		}

	function getRatePerOrder()
		{
		return $this->rateperorder;
		}

	function setRatePerSale($r)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkInt($r,0,100);
			if (!$ok)
				{
				$this->_error("Affiliate RatePerSale " . $this->lastError());
				return false;
				}
		}
		$this->ratepersale = $r;
		return true;
		}

	function getRatePerSale()
		{
		return $this->ratepersale;
		}

	function setAzoosFlg($az)
		{
		if ($this->enforce_requirements){
			//$ok = $this->_checkBool($az);
			$ok = $this->_checkInt($az,0,1);
			if (!$ok)
				{
				$this->_error("Azoos Affiliate " . $this->lastError());
				return false;
				}
		}
		$this->azoosflg = $az;
		return true;
		}

	function getAzoosFlg()
		{
		return $this->azoosflg;
		}


	function setTlf($t)
		{
		/*
		$ok = $this->_checkTlf($t);
		if (!$ok)
			{
			$this->_error("Affiliate Phone# " . $this->lastError());
			return false;
			}
		*/
		$this->tlf = $t;
		return true;
		}

	function getTlf()
		{
		return $this->tlf;
		}

	function setPerson($p)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkStr($p,CONST_AFF_PERSONNAME_MINLEN,
				CONST_AFF_PERSONNAME_MAXLEN,NULL_OK);
			if (!$ok)
				{
				$this->_error("Affiliate Person " . $this->lastError());
				return false;
				}
		}
		$this->person = $p;
		return true;
		}

	function getPerson()
		{
		return $this->person;
		}

	function setPayee($p)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkStr($p,CONST_AFF_PERSONNAME_MINLEN,
				CONST_AFF_PERSONNAME_MAXLEN,NULL_OK);
			if (!$ok)
				{
				$this->_error("Affiliate Payee " . $this->lastError());
				return false;
				}
		}
		$this->payee = $p;
		return true;
		}

	function getPayee()
		{
		return $this->payee;
		}

	function setAddr1($a1)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkStr($a1,CONST_ADDR_MINLEN,
				CONST_ADDR_MAXLEN,NULL_OK);
			if (!$ok)
				{
				$this->_error("Affiliate Address1 " . $this->lastError());
				return false;
				}
		}
		$this->addr1 = $a1;
		return true;
		}

	function getAddr1()
		{
		return $this->addr1;
		}

	function setAddr2($a2)
		{
		if (trim(strtolower($a2)) == "none") $a2 = "";
		if ($this->enforce_requirements){
			$ok = $this->_checkStr($a2,CONST_ADDR2_MINLEN,
				CONST_ADDR_MAXLEN,NULL_OK);
			if (!$ok)
				{
				$this->_error("Affiliate Address2 " . $this->lastError());
				return false;
				}
		}
		$this->addr2 = $a2;
		return true;
		}

	function getAddr2()
		{
		return $this->addr2;
		}

	function setCity($c)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkStr($c,CONST_CITY_MINLEN,
				CONST_CITY_MAXLEN,NULL_OK);
			if (!$ok)
				{
				$this->_error("Affiliate City " . $this->lastError());
				return false;
				}
		}
		$this->city = $c;
		return true;
		}

	function getCity()
		{
		return $this->city;
		}

	function setState($s)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkStr($s,CONST_STATE_MINLEN,
				CONST_STATE_MAXLEN,NULL_OK);
			if (!$ok)
				{
				$this->_error("Affiliate State " . $this->lastError());
				return false;
				}
		}
		$this->state = $s;
		return true;
		}

	function getState()
		{
		return $this->state;
		}

	function setZip($z)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkStr($z,CONST_ZIP_MINLEN,
				CONST_ZIP_MAXLEN,NULL_OK);
			if (!$ok)
				{
				$this->_error("Affiliate Zip " . $this->lastError());
				return false;
				}
		}
		$this->zip = $z;
		return true;
		}

	function getZip()
		{
		return $this->zip;
		}

	function setCountry($c)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkStr($c,CONST_COUNTRY_MINLEN,
				CONST_COUNTRY_MAXLEN,NULL_OK);
			if (!$ok)
				{
				$this->_error("Affiliate Country " . $this->lastError());
				return false;
				}
		}
		$this->country = $c;
		return true;
		}

	function getCountry()
		{
		return $this->country;
		}

	function setSSN($s)
		{
		if ($this->enforce_requirements){
			$ok = $this->_checkStr($s,CONST_AFF_SSN_MINLEN,
				CONST_AFF_SSN_MAXLEN,NULL_OK);
			if (!$ok)
				{
				$this->_error("Affiliate SSN/TaxID " . $this->lastError());
				return false;
				}
		}
		$this->ssn = $s;
		return true;
		}

	function getSSN()
		{
		return $this->ssn;
		}

	function getIDByMail($mail)
		{
		return $this->listSQL("mail = '$mail'");
		}

	function getIDByName($name)
		{
		return $this->listSQL("name = '$name'");
		}

	function getIDByBannerPass($bp)
		{
		$bp = strtolower($bp);
		return $this->listSQL("LCASE(bannerpass) = '$bp'");
		}

	function getIDByWebsiteID($wsid)
		{
		return $this->listSQL("websiteid = '$wsid'");
		}

	function genCookieValue($time)
		{
		global $CODEBASE;
		$c = $this->getID() . "-" . $time . "-" .
			md5($CODEBASE . $this->getID() .
				$this->getBannerPass() . $time);
		return $c;
		}

	function checkCookie($cookie)
		{
		global $CODEBASE;

		$x = explode("-",$cookie);
		if (count($x) != 3) return "Unparseable cookie";

		$afid = $x[0];
		$tim = $x[1];
		$md5 = $x[2];

		$af = new Affiliate($afid);
		if (!$af->wasOK())
			return "Affiliate ID#$afid ERROR" . $af->lastError();

		$bp = $af->getBannerPass();
		$check = md5($CODEBASE.$afid.$bp.$tim);
    
    //echo $CODEBASE."->".$afid."->".$bp."->".$tim;
		if ($md5 != $check)
    {
      //mitesh
      $NNNCODEBASE = str_replace("http://","https://",$CODEBASE);
      $check = md5($NNNCODEBASE.$afid.$bp.$tim);  
      if ($md5 != $check)
      {
        $check = md5("http://secure.azoos.com/resume".$afid.$bp.$tim);
        if ($md5 != $check)
        {
          $check = md5("https://secure.azoos.com/resume".$afid.$bp.$tim);
          if ($md5 != $check)
          {
            return "Cookie value invalid $afid $bp $tim"; 
          }          
        }                          
      }    
    }		

		return "";
		}

	function makeBannerPass($bp)
		{
		$bp = strtolower(ereg_replace("[^A-Za-z0-9\._-]","",$bp));
		while (strlen($bp) < CONST_AFF_BPASS_MINLEN)
			{
			$bp .= "-$bp";
			}

		return $bp;
		}

	function getBannerClickURL()
		{
		global $CODEBASENONSSL;

		return $CODEBASENONSSL . "/click.php?bp=" . $this->getBannerPass();
		}

	function getOrderLinkURL()
		{
		global $CODEBASENONSSL;

		return $CODEBASENONSSL . "/click.php?ct=l&bp=" .
			$this->getBannerPass();
		}

	function getAzoosBannerClickURL()
		{
		global $CODEBASENONSSL;

		return $CODEBASENONSSL . "/clickazoos.php?bp=" . $this->getBannerPass();
		}

	function getAzoosOrderLinkURL()
		{
		global $CODEBASENONSSL;

		return $CODEBASENONSSL . "/clickazoos.php?ct=l&bp=" .
			$this->getBannerPass();
		}


	}

?>
