<?

/**
 * Allow the user to change the CC number on file for a particular order
 *
 * Added to allow the user to change the CC number for Extended Download services that expire
 *
 */

require_once("../inc/autoexec.inc.php");
require_once("../inc/forms.inc.php");

$clid = (isset($_GET["clid"]) ? $_GET["clid"] : 0);
$clid = (isset($_POST["clid"]) ? $_POST["clid"] : $clid);
$oid = (isset($_GET["oid"]) ? $_GET["oid"] : 0);
$oid = (isset($_POST["oid"]) ? $_POST["oid"] : $oid);
$i4 = (isset($_GET["i4"]) ? $_GET["i4"] : 0);
$i4 = (isset($_POST["i4"]) ? $_POST["i4"] : $i4);
$i7 = (isset($_GET["i7"]) ? $_GET["i7"] : 0);
$i7 = (isset($_POST["i7"]) ? $_POST["i7"] : $i7);
$newcard = true;

$cki4 = "c" . md5("clid = $clid") . crc32("clid = $clid") . "a";
$cki7 = $i7 * 3600;

if ($cki4 != $i4) die("Unauthorized");
if ((time() - 3600) > $cki7)
	{
	header("Location: ../client/login.php?timeout=yes");
	exit;
	}

if (!strlen($clid)) diehard("Client ID# missing");
if (!is_numeric($clid)) diehard("Client ID#$clid not numeric");
if (ceil($clid) != $clid) diehard("Client ID#$clid is float");
if ($clid < 1) diehard("Client ID#$clid undefined");

$cl = new Client($clid);
if (!$cl->wasOK())
	diehard("Client ID#$clid ERROR: " . $cl->lastError());

if (!strlen($oid)) diehard("Order ID# missing");
if (!is_numeric($oid)) diehard("Order ID#$oid not numeric");
if (ceil($oid) != $oid) diehard("Order ID#$oid is float");
if ($oid < 1) diehard("Order ID#$oid undefined");

$or = new Order($oid);
if (!$or->wasOK())
	diehard("Order ID#$oid ERROR: " . $or->lastError());
$sale = $or->getSale();
$salefmt = sprintf("%.02f",$sale);



//Card info is important
$ci = new Card($or->getCardID());
if (!$ci->wasOK()) diehard("Order ID#$oid Can't get card #" . $or->getCardID() . ". ERROR: " . $or->lastError());



$baselink = $_SERVER["PHP_SELF"] . "?oid=$oid&clid=$clid&i4=$i4&i7=$i7";
$forgetlink = "../client/olist.php?clid=$clid&i4=$i4&i7=$i7";




# da request type

if ($_SERVER["REQUEST_METHOD"] == "GET")
	{
	$frm_newccn = $ci->getNumber();
	$frm_newcct = ($ci->getType() ? $ci->getType() : "VISA");
	$frm_newccy = ($ci->getYear() ? $ci->getYear() : date("Y",time()));
	$frm_newccm = ($ci->getMonth() ? $ci->getMonth() : date("m",time()));
	$frm_newcch = $ci->getHolder();
	$frm_newccb = $ci->getBank();

	$get = true;
	}
else
	{
	$get = false;

	$frm_newccn = getpostvar("frm_newccn");
	$frm_newcct = getpostvar("frm_newcct");
	$frm_newccy = getpostvar("frm_newccy");
	$frm_newccm = getpostvar("frm_newccm");
	$frm_newcch = getpostvar("frm_newcch");
	$frm_newccb = getpostvar("frm_newccb");
	}

# da form

$f = new Form("POST",$_SERVER["PHP_SELF"]);

$f->addInfoRow("Changing Order ID#$oid Payment Method to Credit Card");

$f->addErrInfoRow("Errors in this form: %s");

$f->addHidden("clid",$clid);
$f->addHidden("oid",$oid);
$f->addHidden("i4",$i4);
$f->addHidden("i7",$i7);

$f->addField("frm_newcct","static","Issuer");
$f->addSelect($CARD_TYPES_ARRAY);
$f->checkField("ck_cctype");

function ck_cctype($v)
	{
	global $CARD_TYPES_ARRAY;

	if (!isset($CARD_TYPES_ARRAY[$v]))
		return "Invalid type";

	return "";
	}

$f->addField("frm_newccn","string," . CONST_CC_NUM_MINLEN . "," .
	CONST_CC_NUM_MAXLEN . ",notnull","Card Number");
$f->checkField();

$MONS = array();
for ($i = 1; $i < 13; $i++)
	$MONS[$i] = $i;

$f->addField("frm_newccm","num,1,2","Exp. Month");
$f->addSelect($MONS);
$f->checkField();

$YRS = array();
for ($i = date("Y",time()); $i < (date("Y",time()) + 11); $i++)
	$YRS[$i] = $i;

$f->addField("frm_newccy","num,4,4","Exp. Year");
$f->addSelect($YRS);
$f->checkField();

$f->addField("frm_newcch","string," . CONST_CC_HOLDER_MINLEN . "," .
	CONST_CC_HOLDER_MAXLEN . ",notnull","Card Holder");
$f->checkField();

$f->addField("frm_newccb","string," . CONST_CC_BANK_MINLEN . "," .
	CONST_CC_BANK_MAXLEN . ",nullok","Bank");
$f->checkField();

//$f->addInfoRow("Your card is about to be charged \$$salefmt.");

$f->addSubmit("  CHANGE CARD INFO  ");

$btxt = "  Forget it  ";
$bclick = "javascript:document.location = '$forgetlink';";

$f->addButton($btxt,$bclick);

# if there was an error while form post'ed or it's get display it

if (($f->numErr()) || $get)
        {
	normalPageStart();

        echo $f->dumpForm();

	normalPageEnd();
	exit;
        }

$ci = new Card($or->getCardID());

$err = true;

while (1)
	{
	$ok = $ci->setNumber($frm_newccn);
	if (!$ok) break;
	$ok = $ci->setType($frm_newcct);
	if (!$ok) break;
	$ok = $ci->setMonth($frm_newccm);
	if (!$ok) break;
	$ok = $ci->setYear($frm_newccy);
	if (!$ok) break;
	$ok = $ci->setHolder($frm_newcch);
	if (!$ok) break;
	$ok = $ci->setBank($frm_newccb);
	if (!$ok) break;
	$ok = $ci->Update();
	if (!$ok) break;

	//Update the card id, in case this didn't first have one
	if ($or->getCardID() <= 0){
		$ok = $or->setCardID($ci->getID());
		if (!$ok) break;
		$ok = $or->Update();
		if (!$ok) break;
	}

	$err = false;
	break;
	}

if ($err) diehard("Change Card ERROR: " . $ci->lastError());


$co = new Comment();
$ok = $co->setOrderID($oid);
$ok = $co->setPoster(whoson());
$ok = $co->setComment("Card info changed successfully");
$ok = $co->Update();


header("Location: ../client/olist.php?clid=$clid&i7=$i7&i4=$i4&msg=" .
	urlencode("Order ID#$oid Credit Card info changed."));

?>

